/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.utils.multitenancy.CarbonApplicationContextHolder;

public class ApplicationContext {
    private CarbonApplicationContextHolder carbonApplicationContextHolder = null;
    private static Map<String, String> urlMappingOfApplication = new HashMap<String, String>();

    protected ApplicationContext(CarbonApplicationContextHolder carbonApplicationContextHolder) {
        this.carbonApplicationContextHolder = carbonApplicationContextHolder;
    }

    protected CarbonApplicationContextHolder getCarbonApplicationContextHolder() {
        if (this.carbonApplicationContextHolder == null) {
            return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder();
        }
        return this.carbonApplicationContextHolder;
    }

    public static ApplicationContext getCurrentApplicationContext() {
        return new ApplicationContext(null);
    }

    public String getApplicationName() {
        CarbonBaseUtils.checkSecurity();
        return this.getCarbonApplicationContextHolder().getApplicationName();
    }

    public void putUrlMappingForApplication(String urlMapping, String application) {
        urlMappingOfApplication.put(urlMapping, application);
    }

    public String getApplicationFromUrlMapping(String urlMapping) {
        return urlMappingOfApplication.get(urlMapping);
    }

    public void removeUrlMappingMap(String urlMapping) {
        urlMappingOfApplication.remove(urlMapping);
    }

    public boolean isUrlMappingExists(String urlMapping) {
        return urlMappingOfApplication.containsKey(urlMapping);
    }

    public List<String> getUrlMappingsPerApplication(String applicationContext) {
        ArrayList<String> urlMapping = new ArrayList<String>();
        for (String key : urlMappingOfApplication.keySet()) {
            if (!urlMappingOfApplication.get(key).equalsIgnoreCase(applicationContext)) continue;
            urlMapping.add(key);
        }
        return urlMapping;
    }

    public Map<String, String> getUrlMappingOfApplication() {
        return urlMappingOfApplication;
    }
}

