/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfo;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfoAdminStub;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.UIAuthenticationExtender;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonUIAuthenticationUtil {
    private static Log audit = CarbonConstants.AUDIT_LOG;

    public static void onSuccessAdminLogin(HttpServletRequest request, String userName) throws Exception {
        HttpSession session = request.getSession();
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        if (tenantDomain != null && tenantDomain.trim().length() > 0) {
            session.setAttribute("tenantDomain", (Object)tenantDomain);
            if (request.getAttribute("tenantDomain") == null) {
                request.setAttribute("tenantDomain", (Object)tenantDomain);
            }
        } else {
            audit.info((Object)"User with null domain tried to login.");
            return;
        }
        CarbonUIAuthenticationUtil.onSuccessAdminLogin(request, userName, tenantDomain);
    }

    public static void onSuccessAdminLogin(HttpServletRequest request, String userName, String domain) throws Exception {
        UIAuthenticationExtender[] uiAuthenticationExtenders;
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL(CarbonUIServiceComponent.getServerConfiguration());
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        if (!(serverURL != null && cookie != null || CarbonUtils.isRunningOnLocalTransportMode())) {
            throw new Exception("Cannot proceed logging in. The server URL and/or Cookie is null");
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        if (tenantDomain != null && "carbon.super".equals(tenantDomain.trim())) {
            request.getSession().setAttribute(MultitenantConstants.IS_SUPER_TENANT, (Object)"true");
        } else if (tenantDomain != null && tenantDomain.trim().length() > 0) {
            session.setAttribute("tenantDomain", (Object)tenantDomain);
            if (request.getAttribute("tenantDomain") == null) {
                request.setAttribute("tenantDomain", (Object)tenantDomain);
            }
        } else {
            audit.info((Object)"User with null domain tried to login.");
            return;
        }
        String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)userName);
        CarbonUIAuthenticationUtil.setUserInformation(cookie, serverURL, session);
        session.setAttribute("logged-user", (Object)tenantAwareUserName);
        session.getServletContext().setAttribute("logged-user", (Object)tenantAwareUserName);
        session.setAttribute("authenticated", (Object)Boolean.parseBoolean("true"));
        for (UIAuthenticationExtender uiAuthenticationExtender : uiAuthenticationExtenders = CarbonUIServiceComponent.getUIAuthenticationExtenders()) {
            uiAuthenticationExtender.onSuccessAdminLogin(request, tenantAwareUserName, tenantDomain, serverURL);
        }
    }

    public static void setCookieHeaders(Cookie cookie, ServiceClient serviceClient) {
        ArrayList<Header> headers = new ArrayList<Header>();
        Header rememberMeHeader = new Header("RememberMeCookieData", cookie.getValue());
        headers.add(rememberMeHeader);
        serviceClient.getOptions().setProperty("HTTP_HEADERS", headers);
    }

    private static void setUserInformation(String cookie, String backendServerURL, HttpSession session) throws RemoteException {
        try {
            if (session.getAttribute("user-permissions") != null) {
                return;
            }
            ServletContext servletContext = session.getServletContext();
            ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
            LoggedUserInfoAdminStub stub = new LoggedUserInfoAdminStub(configContext, backendServerURL + "LoggedUserInfoAdmin");
            ServiceClient client = stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
            LoggedUserInfo userInfo = stub.getUserInfo();
            String[] permissionArray = userInfo.getUIPermissionOfUser();
            ArrayList<String> list = new ArrayList<String>();
            for (String permission : permissionArray) {
                list.add(permission);
            }
            session.setAttribute("user-permissions", list);
            if (userInfo.getPasswordExpiration() != null) {
                session.setAttribute("passwordExpires", (Object)userInfo.getPasswordExpiration());
            }
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault("Exception occured", (Throwable)e);
        }
    }
}

