/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.SecuredComponentEntryHttpContext;
import org.wso2.carbon.ui.UIResourceRegistry;
import org.wso2.carbon.ui.deployment.beans.CarbonUIDefinitions;
import org.wso2.carbon.ui.deployment.beans.Context;
import org.wso2.carbon.ui.util.CarbonUIAuthenticationUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonSecuredHttpContext
extends SecuredComponentEntryHttpContext {
    public static final String LOGGED_USER = "logged-user";
    private static final Log log = LogFactory.getLog(CarbonSecuredHttpContext.class);
    private Bundle bundle = null;
    private Pattern tenantEnabledUriPattern;
    private static final String TENANT_ENABLED_URI_PATTERN = "(/.*/|/)t/[^/]*($|/.*)";

    public CarbonSecuredHttpContext(Bundle bundle, String s, UIResourceRegistry uiResourceRegistry, Registry registry) {
        super(bundle, s, uiResourceRegistry);
        this.registry = registry;
        this.bundle = bundle;
        this.tenantEnabledUriPattern = Pattern.compile(TENANT_ENABLED_URI_PATTERN);
    }

    private String getUIErrorCode(String code) {
        if (code == null) {
            return null;
        }
        if (code.equals("50977")) {
            return "invalid.credentials";
        }
        if (code.equals("50976")) {
            return "authentication.failure";
        }
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Cookie[] cookies;
        CarbonUIDefinitions carbonUIDefinitions;
        ServiceReference reference;
        String resourceURI;
        String tmp1;
        int end;
        CarbonUIDefinitions carbonUIDefinitions2;
        ServiceReference reference2;
        Matcher matcher;
        String sessionId;
        HttpSession session;
        String requestedURI = request.getRequestURI();
        CarbonSSOSessionManager ssoSessionManager = CarbonSSOSessionManager.getInstance();
        if (!this.skipSSOSessionInvalidation(request) && !ssoSessionManager.isSessionValid(request.getSession().getId())) {
            requestedURI = "/carbon/admin/logout_action.jsp";
        }
        if (this.skipSSOSessionInvalidation(request) && !ssoSessionManager.isSessionValid(request.getSession().getId())) {
            ssoSessionManager.removeInvalidSession(request.getSession().getId());
        }
        boolean authenticated = false;
        try {
            session = request.getSession();
            sessionId = session.getId();
            Boolean authenticatedObj = (Boolean)session.getAttribute("authenticated");
            if (authenticatedObj != null) {
                authenticated = authenticatedObj;
            }
        }
        catch (Exception e) {
            return false;
        }
        String context = request.getContextPath();
        if ("/".equals(context)) {
            context = "";
        }
        if ((matcher = this.tenantEnabledUriPattern.matcher(requestedURI)).matches()) {
            if (requestedURI.contains("/webapps/")) {
                response.sendError(404, "Web application not found. Request URI: " + requestedURI);
                return false;
            }
            if (requestedURI.contains("/carbon/admin/login.jsp") && !authenticated) {
                response.sendRedirect(context + "/carbon/admin/login.jsp");
                return false;
            }
            return true;
        }
        if (requestedURI.indexOf("//") == 0) {
            requestedURI = requestedURI.substring(1);
        }
        HashMap<Object, Object> httpUrlsToBeByPassed = new HashMap();
        Context defaultContext = null;
        if (this.bundle != null && (reference2 = this.bundle.getBundleContext().getServiceReference(CarbonUIDefinitions.class.getName())) != null && (carbonUIDefinitions2 = (CarbonUIDefinitions)this.bundle.getBundleContext().getService(reference2)) != null) {
            httpUrlsToBeByPassed = carbonUIDefinitions2.getHttpUrls();
            if (carbonUIDefinitions2.getContexts().containsKey("default-context")) {
                defaultContext = carbonUIDefinitions2.getContexts().get("default-context");
            }
        }
        if (requestedURI.equals(context) || requestedURI.equals(context + "/")) {
            if (defaultContext != null && !"".equals(defaultContext.getContextName()) && !"null".equals(defaultContext.getContextName())) {
                String adminConsoleURL = CarbonUIUtil.getAdminConsoleURL(request);
                int index = adminConsoleURL.lastIndexOf("carbon");
                String defaultContextUrl = adminConsoleURL.substring(0, index) + defaultContext.getContextName() + "/";
                response.sendRedirect(defaultContextUrl);
            } else {
                response.sendRedirect("carbon");
            }
            return false;
        }
        String tmp = requestedURI;
        String customWarContext = "";
        if (requestedURI.startsWith("/carbon") && !requestedURI.startsWith("/carbon/carbon/")) {
            requestedURI = tmp;
        } else if (requestedURI.indexOf("filedownload") == -1 && requestedURI.indexOf("fileupload") == -1 && (end = (tmp1 = tmp.replaceFirst("/", "")).indexOf(47)) > -1) {
            customWarContext = tmp1.substring(0, end);
            requestedURI = !requestedURI.startsWith("/registry/registry/") && !requestedURI.startsWith("/registry/carbon/") && (customWarContext.equals("registry") || customWarContext.equals("gadgets") || customWarContext.equals("social")) ? tmp : tmp.substring(end + 1);
        }
        if (!request.isSecure() && !requestedURI.endsWith(".html")) {
            if (requestedURI.endsWith(".css") || requestedURI.endsWith(".gif") || requestedURI.endsWith(".GIF") || requestedURI.endsWith(".jpg") || requestedURI.endsWith(".JPG") || requestedURI.endsWith(".png") || requestedURI.endsWith(".PNG") || requestedURI.endsWith(".xsl") || requestedURI.endsWith(".xslt") || requestedURI.endsWith(".js") || requestedURI.endsWith(".ico") || requestedURI.endsWith("/filedownload") || requestedURI.endsWith("/fileupload") || requestedURI.contains("/fileupload/") || requestedURI.contains("admin/jsp/WSRequestXSSproxy_ajaxprocessor.jsp") || requestedURI.contains("registry/atom") || requestedURI.contains("registry/tags") || requestedURI.contains("gadgets/") || requestedURI.contains("registry/resource")) {
                return true;
            }
            resourceURI = requestedURI.replaceFirst("/carbon/", "../");
            if (httpUrlsToBeByPassed.containsKey(resourceURI)) {
                if (!authenticated) {
                    try {
                        Cookie[] cookies2 = request.getCookies();
                        if (cookies2 != null) {
                            for (Cookie cookie : cookies2) {
                                if (!cookie.getName().equals("wso2.carbon.rememberme") || !this.getAuthenticator(request).reAuthenticateOnSessionExpire(request)) continue;
                                String cookieValue = cookie.getValue();
                                CarbonUIAuthenticationUtil.onSuccessAdminLogin(request, this.getUserNameFromCookie(cookieValue));
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        throw new IOException(e.getMessage(), e);
                    }
                }
                return true;
            }
            String adminConsoleURL = CarbonUIUtil.getAdminConsoleURL(request);
            if (adminConsoleURL != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Request came to admin console via http.Forwarding to : " + adminConsoleURL));
                }
                response.sendRedirect(adminConsoleURL);
                return false;
            }
        }
        resourceURI = requestedURI.replaceFirst("/carbon/", "../");
        if (log.isDebugEnabled()) {
            log.debug((Object)("CarbonSecuredHttpContext -> handleSecurity() requestURI:" + requestedURI + " id:" + sessionId + " resourceURI:" + resourceURI));
        }
        HashMap<Object, Object> urlsToBeByPassed = new HashMap();
        if (this.bundle != null && (reference = this.bundle.getBundleContext().getServiceReference(CarbonUIDefinitions.class.getName())) != null && (carbonUIDefinitions = (CarbonUIDefinitions)this.bundle.getBundleContext().getService(reference)) != null) {
            urlsToBeByPassed = carbonUIDefinitions.getUnauthenticatedUrls();
        }
        if (!urlsToBeByPassed.isEmpty() && urlsToBeByPassed.containsKey(resourceURI)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("By passing authentication check for URI : " + resourceURI));
            }
            String contextPath = request.getContextPath();
            String backendServerURL = request.getParameter("backendURL");
            if (backendServerURL == null) {
                backendServerURL = CarbonUIUtil.getServerURL(session.getServletContext(), request.getSession());
            }
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            backendServerURL = backendServerURL.replace("${carbon.context}", contextPath);
            session.setAttribute("ServerURL", (Object)backendServerURL);
            return true;
        }
        String indexPageURL = CarbonUIUtil.getIndexPageURL(session.getServletContext(), request.getSession());
        if (requestedURI.equals("/carbon/admin/login_action.jsp") && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("requestedURI")) continue;
                indexPageURL = cookie.getValue();
            }
            if (this.tenantEnabledUriPattern.matcher(indexPageURL).matches()) {
                indexPageURL = CarbonUIUtil.removeTenantSpecificStringsFromURL(indexPageURL);
            }
        }
        if (request.getParameter("IndexPageURL") != null) {
            indexPageURL = request.getParameter("IndexPageURL");
        } else if (indexPageURL == null) {
            indexPageURL = "/carbon/admin/index.jsp";
        }
        String defaultHomePage = null;
        if (defaultHomePage == null) {
            defaultHomePage = (String)CarbonUIUtil.getProductParam("WSO2CarbondefaultHomePage");
        }
        if (defaultHomePage != null && defaultHomePage.trim().length() > 0 && indexPageURL.contains("/carbon/admin/index.jsp") && !(indexPageURL = defaultHomePage).startsWith("/")) {
            indexPageURL = "/" + indexPageURL;
        }
        if (requestedURI.indexOf("login.jsp") > -1 || requestedURI.indexOf("login_ajaxprocessor.jsp") > -1 || requestedURI.indexOf("admin/layout/template.jsp") > -1 || requestedURI.endsWith("/filedownload") || requestedURI.endsWith("/fileupload") || requestedURI.indexOf("/fileupload/") > -1 || requestedURI.indexOf("login_action.jsp") > -1 || requestedURI.indexOf("admin/jsp/WSRequestXSSproxy_ajaxprocessor.jsp") > -1) {
            if ((requestedURI.indexOf("login.jsp") > -1 || requestedURI.indexOf("login_ajaxprocessor.jsp") > -1 || requestedURI.indexOf("login_action.jsp") > -1) && authenticated) {
                String tenantDomain;
                if (request.getSession().getAttribute("tenantDomain") != null && (tenantDomain = (String)request.getSession().getAttribute("tenantDomain")) != null && !"carbon.super".equals(tenantDomain)) {
                    context = context + "/t/" + tenantDomain;
                }
                response.sendRedirect(context + indexPageURL);
                return false;
            }
            if (requestedURI.indexOf("login_action.jsp") > -1 && !authenticated) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User is not yet authenticated and now trying to get authenticated;do nothing, leave for authentication at the end");
                }
            } else {
                return true;
            }
        }
        if (this.skipAuthentication(request)) {
            return true;
        }
        if (requestedURI.endsWith(".jsp") && !requestedURI.endsWith("ajaxprocessor.jsp") && !requestedURI.endsWith("session_validate.jsp") && request.getSession().getAttribute("authenticated") != null && ((Boolean)request.getSession().getAttribute("authenticated")).booleanValue() && (request.getSession().getAttribute("tenantDomain") == null && request.getAttribute("tenantDomain") != null || request.getSession().getAttribute("tenantDomain") != null && request.getAttribute("tenantDomain") != null && !request.getSession().getAttribute("tenantDomain").equals(request.getAttribute("tenantDomain")))) {
            requestedURI = "../admin/logout_action.jsp";
        }
        boolean sessionAuth = false;
        String contextPath = request.getContextPath().equals("") || request.getContextPath().equals("/") ? "" : request.getContextPath();
        String httpLogin = request.getParameter("gsHttpRequest");
        if (requestedURI.indexOf("login_action.jsp") > -1) {
            block101: {
                try {
                    String userName = request.getParameter("username");
                    String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
                    if (tenantDomain == null) {
                        tenantDomain = (String)request.getAttribute("tenantDomain");
                    }
                    if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                        contextPath = contextPath + "/t/" + tenantDomain;
                    }
                    if (sessionAuth = this.getAuthenticator(request).authenticate(request)) {
                        String value = request.getParameter("rememberMe");
                        boolean isRememberMe = false;
                        if (value != null && value.equals("rememberMe")) {
                            isRememberMe = true;
                        }
                        if (!authenticated) {
                            try {
                                CarbonUIAuthenticationUtil.onSuccessAdminLogin(request, userName);
                            }
                            catch (Exception e) {
                                log.warn((Object)e.getMessage(), (Throwable)e);
                                this.getAuthenticator(request).unauthenticate(request);
                                request.getSession().invalidate();
                                response.sendRedirect("../../carbon/admin/login.jsp?loginStatus=false");
                                return false;
                            }
                        }
                        try {
                            if (isRememberMe) {
                                String rememberMeCookieValue = (String)request.getAttribute("wso2.carbon.rememberme.value");
                                int age = Integer.parseInt((String)request.getAttribute("wso2.carbon.rememberme.age"));
                                Cookie rmeCookie = new Cookie("wso2.carbon.rememberme", rememberMeCookieValue);
                                rmeCookie.setPath("/");
                                rmeCookie.setSecure(true);
                                rmeCookie.setMaxAge(age);
                                response.addCookie(rmeCookie);
                            }
                        }
                        catch (Exception e) {
                            response.sendRedirect(contextPath + indexPageURL + (indexPageURL.indexOf(63) == -1 ? "?" : "&") + "loginStatus=false");
                            return false;
                        }
                        if (contextPath != null) {
                            if (indexPageURL.startsWith("../..")) {
                                indexPageURL = indexPageURL.substring(5);
                            }
                            response.sendRedirect(contextPath + indexPageURL + (indexPageURL.indexOf(63) == -1 ? "?" : "&") + "loginStatus=true");
                        }
                        break block101;
                    }
                    if (httpLogin != null) {
                        response.sendRedirect("../.." + httpLogin + "?loginStatus=false");
                    } else {
                        response.sendRedirect("../../carbon/admin/login.jsp?loginStatus=false");
                    }
                }
                catch (AuthenticationException e) {
                    log.debug((Object)"Authentication failure ...", (Throwable)e);
                    String uiErrorCode = this.getUIErrorCode(e.getUiErrorCode());
                    if (uiErrorCode != null) {
                        response.sendRedirect("../../carbon/admin/login.jsp?loginStatus=false&errorCode=" + uiErrorCode);
                    } else {
                        response.sendRedirect("../../carbon/admin/login.jsp?loginStatus=false");
                    }
                }
                catch (Exception e) {
                    log.error((Object)"error occurred while login", (Throwable)e);
                    response.sendRedirect("../../carbon/admin/login.jsp?loginStatus=failed");
                }
            }
            return false;
        }
        if (requestedURI.indexOf("logout_action.jsp") > 1) {
            HttpSession currentSession;
            if ("true".equals(request.getParameter("logoutcomplete"))) {
                currentSession = request.getSession(false);
                if (currentSession != null) {
                    session.removeAttribute(LOGGED_USER);
                    session.getServletContext().removeAttribute(LOGGED_USER);
                    try {
                        session.invalidate();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                response.sendRedirect("../../carbon/admin/login.jsp");
                return false;
            }
            try {
                this.getAuthenticator(request).unauthenticate(request);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                response.sendRedirect("../admin/login.jsp");
                return false;
            }
            if (!this.skipSSOSessionInvalidation(request) && !ssoSessionManager.isSessionValid(request.getSession().getId())) {
                block102: {
                    currentSession = request.getSession(false);
                    if (currentSession != null) {
                        session.removeAttribute(LOGGED_USER);
                        session.getServletContext().removeAttribute(LOGGED_USER);
                        try {
                            session.invalidate();
                        }
                        catch (Exception ignored) {
                            if (!log.isDebugEnabled()) break block102;
                            log.debug((Object)"Ignore exception when invalidating session", (Throwable)ignored);
                        }
                    }
                }
                response.sendRedirect("../.." + indexPageURL);
                return false;
            }
            ssoSessionManager.removeInvalidSession(request.getSession().getId());
            if (request.getAttribute("logoutRequest") != null) {
                response.sendRedirect("../../carbon/sso-acs/redirect_ajaxprocessor.jsp?logout=true");
                return false;
            }
            currentSession = request.getSession(false);
            if (currentSession != null) {
                session.removeAttribute(LOGGED_USER);
                session.getServletContext().removeAttribute(LOGGED_USER);
                try {
                    session.invalidate();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            Cookie rmeCookie = new Cookie("wso2.carbon.rememberme", null);
            rmeCookie.setPath("/");
            rmeCookie.setSecure(true);
            rmeCookie.setMaxAge(0);
            response.addCookie(rmeCookie);
            response.sendRedirect(contextPath + indexPageURL);
            return false;
        }
        if (requestedURI.endsWith("/carbon/")) {
            response.sendRedirect(contextPath + indexPageURL);
            return false;
        }
        if (requestedURI.indexOf("/registry/atom") == -1 && requestedURI.endsWith("/carbon")) {
            response.sendRedirect(contextPath + indexPageURL);
            return false;
        }
        if (requestedURI.endsWith(".css") || requestedURI.endsWith(".gif") || requestedURI.endsWith(".GIF") || requestedURI.endsWith(".jpg") || requestedURI.endsWith(".JPG") || requestedURI.endsWith(".png") || requestedURI.endsWith(".PNG") || requestedURI.endsWith(".xsl") || requestedURI.endsWith(".xslt") || requestedURI.endsWith(".js") || requestedURI.startsWith("/registry") || requestedURI.endsWith(".html") || requestedURI.endsWith(".ico") || tmp.startsWith("/openid/") || requestedURI.indexOf("/openid/") > -1 || requestedURI.indexOf("/oauth/") > -1 || requestedURI.indexOf("/oauth2/") > -1 || requestedURI.indexOf("/openidserver") > -1 || requestedURI.indexOf("/gadgets") > -1 || requestedURI.indexOf("/samlsso") > -1) {
            return true;
        }
        if (requestedURI.endsWith(".jsp") && authenticated) {
            return true;
        }
        if (!authenticated) {
            if (requestedURI.endsWith("ajaxprocessor.jsp")) {
                return true;
            }
            if (!requestedURI.endsWith("admin/error.jsp")) {
                String queryString = request.getQueryString();
                String tmpURI = queryString != null ? requestedURI + "?" + queryString : requestedURI;
                tmpURI = "../.." + tmpURI;
                request.getSession(false).setAttribute("requestedUri", (Object)tmpURI);
                if (!tmpURI.contains("session-validate.jsp")) {
                    Cookie cookie = new Cookie("requestedURI", tmpURI);
                    cookie.setPath("/");
                    response.addCookie(cookie);
                }
            }
            try {
                Cookie[] cookies3 = request.getCookies();
                if (cookies3 != null) {
                    for (Cookie cookie : cookies3) {
                        if (!cookie.getName().equals("wso2.carbon.rememberme") || !this.getAuthenticator(request).reAuthenticateOnSessionExpire(request)) continue;
                        String cookieValue = cookie.getValue();
                        CarbonUIAuthenticationUtil.onSuccessAdminLogin(request, this.getUserNameFromCookie(cookieValue));
                        return true;
                    }
                }
            }
            catch (AuthenticationException e) {
                log.debug((Object)"Authentication failure ...", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"error occurred while login", (Throwable)e);
            }
            if (request.getAttribute("tenantDomain") != null) {
                response.sendRedirect("../admin/login.jsp");
            } else {
                response.sendRedirect(contextPath + "/carbon/admin/login.jsp");
            }
            return false;
        }
        if (request.getSession().isNew()) {
            response.sendRedirect(contextPath + "/carbon/admin/login.jsp");
            return false;
        }
        return true;
    }

    private boolean skipSSOSessionInvalidation(HttpServletRequest request) {
        String requestedURI = request.getRequestURI();
        CarbonUIAuthenticator uiAuthenticator = this.getAuthenticator(request);
        List<String> skippingUrls = uiAuthenticator.getSessionValidationSkippingUrls();
        return this.skip(requestedURI, skippingUrls);
    }

    private boolean skipAuthentication(HttpServletRequest request) {
        String requestedURI = request.getRequestURI();
        CarbonUIAuthenticator uiAuthenticator = this.getAuthenticator(request);
        List<String> skippingUrls = uiAuthenticator.getAuthenticationSkippingUrls();
        return this.skip(requestedURI, skippingUrls);
    }

    private boolean skip(String requestedURI, List<String> skippingUrls) {
        for (String skippingUrl : skippingUrls) {
            if (!requestedURI.contains(skippingUrl)) continue;
            return true;
        }
        return false;
    }

    private String getUserNameFromCookie(String cookieValue) {
        int index = cookieValue.indexOf(45);
        return cookieValue.substring(0, index);
    }
}

