/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.Utils;

public class DefaultBundleCreator
implements CarbonLaunchExtension {
    private static final String JARS_DIR = "repository" + File.separator + "components" + File.separator + "lib";

    @Override
    public void perform() {
        File dropinsFolder = new File(Utils.getCarbonComponentRepo(), "dropins");
        File dir = Utils.getBundleDirectory(JARS_DIR);
        File[] files = dir.listFiles(new Utils.JarFileFilter());
        if (files != null) {
            for (File file : files) {
                try {
                    Manifest mf = new Manifest();
                    Attributes attribs = mf.getMainAttributes();
                    attribs.putValue("DynamicImport-Package", "*");
                    Utils.createBundle(file, dropinsFolder, mf, "");
                }
                catch (Throwable e) {
                    System.err.println("Cannot create bundle from jar file " + file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
    }
}

