/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.ui;

import java.rmi.RemoteException;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.common.ServerUpTime;
import org.wso2.carbon.server.admin.stub.ServerAdminStub;
import org.wso2.carbon.server.admin.stub.types.carbon.ServerData;
import org.wso2.carbon.utils.CarbonUtils;

public class ServerAdminClient
implements IServerAdmin {
    private static final Log log = LogFactory.getLog(ServerAdminClient.class);
    private ServerAdminStub serverAdminStub;
    private HttpSession session;

    public ServerAdminClient(ConfigurationContext ctx, String serverURL, String cookie, HttpSession session) throws AxisFault {
        this.session = session;
        String serviceEPR = serverURL + "ServerAdmin";
        this.serverAdminStub = new ServerAdminStub(ctx, serviceEPR);
        ServiceClient client = this.serverAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setTimeOutInMilliSeconds(10000L);
    }

    public ServerAdminClient(String serverURL, String userName, String password) throws AxisFault {
        this.session = null;
        String serviceEPR = serverURL + "ServerAdmin";
        this.serverAdminStub = new ServerAdminStub(serviceEPR);
        ServiceClient client = this.serverAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setTimeOutInMilliSeconds(10000L);
        CarbonUtils.setBasicAccessSecurityHeaders((String)userName, (String)password, (ServiceClient)client);
    }

    public boolean restart() throws Exception {
        boolean result;
        try {
            result = this.serverAdminStub.restart();
            if (result) {
                this.invalidateSession();
            }
        }
        catch (Exception e) {
            String msg = "Cannot restart the server." + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return result;
    }

    public boolean restartGracefully() throws Exception {
        boolean result;
        try {
            result = this.serverAdminStub.restartGracefully();
            if (result) {
                this.invalidateSession();
            }
        }
        catch (Exception e) {
            String msg = "Cannot restart the server. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return result;
    }

    public boolean shutdown() throws Exception {
        boolean result;
        try {
            result = this.serverAdminStub.shutdown();
            if (result) {
                this.invalidateSession();
            }
        }
        catch (RemoteException e) {
            String msg = "Cannot shutdown the server. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return result;
    }

    public boolean shutdownGracefully() throws Exception {
        boolean result;
        try {
            result = this.serverAdminStub.shutdownGracefully();
            if (result) {
                this.invalidateSession();
            }
        }
        catch (RemoteException e) {
            String msg = "Cannot shutdown the server. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return result;
    }

    public org.wso2.carbon.server.admin.common.ServerData getServerData() throws Exception {
        org.wso2.carbon.server.admin.common.ServerData result = new org.wso2.carbon.server.admin.common.ServerData();
        try {
            ServerData original = this.serverAdminStub.getServerData();
            result.setAxis2Location(original.getAxis2Location());
            result.setDbDriverName(original.getDbDriverName());
            result.setDbDriverVersion(original.getDbDriverVersion());
            result.setDbName(original.getDbName());
            result.setDbURL(original.getDbURL());
            result.setDbVersion(original.getDbVersion());
            result.setJavaHome(original.getJavaHome());
            result.setJavaRuntimeName(original.getJavaRuntimeName());
            result.setJavaVersion(original.getJavaVersion());
            result.setJavaVMVendor(original.getJavaVMVendor());
            result.setJavaVMVersion(original.getJavaVMVersion());
            result.setOsName(original.getOsName());
            result.setOsVersion(original.getOsVersion());
            result.setRegistryType(original.getRegistryType());
            result.setRemoteRegistryChroot(original.getRemoteRegistryChroot());
            result.setRemoteRegistryURL(original.getRemoteRegistryURL());
            result.setRepoLocation(original.getRepoLocation());
            result.setServerIp(original.getServerIp());
            result.setServerName(original.getServerName());
            result.setServerStartTime(original.getServerStartTime());
            if (original.getServerUpTime() != null) {
                ServerUpTime serverUpTime = new ServerUpTime(original.getServerUpTime().getDays(), original.getServerUpTime().getHours(), original.getServerUpTime().getMinutes(), original.getServerUpTime().getSeconds());
                result.setServerUpTime(serverUpTime);
            }
            result.setUserCountry(original.getUserCountry());
            result.setUserHome(original.getUserHome());
            result.setUserName(original.getUserName());
            result.setUserTimezone(original.getUserTimezone());
            result.setCarbonVersion(original.getCarbonVersion());
        }
        catch (RemoteException e) {
            String msg = "Cannot get server data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return result;
    }

    private void invalidateSession() {
        try {
            this.session.invalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

