/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.synchronization.operation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.io.FileUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.UserInputCallback;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.carbon.registry.synchronization.message.Message;
import org.wso2.carbon.registry.synchronization.message.MessageCode;
import org.wso2.carbon.registry.synchronization.operation.UpdateCommand;

public class CheckInCommand {
    private String inputFile = null;
    private String workingDir = null;
    private String registryUrl = null;
    private String checkInPath = null;
    private String userUrl = null;
    private String username = null;
    private boolean ignoreConflicts = true;
    private boolean cleanRegistry = false;
    private List<String> filesToClean = new LinkedList<String>();
    private boolean testContentChanged = true;
    private int sentCount = -1;

    public CheckInCommand(String inputFile, String workingDir, String userUrl, String username, boolean ignoreConflicts, boolean cleanRegistry, boolean testContentChanged) throws SynchronizationException {
        this.inputFile = inputFile;
        this.workingDir = workingDir;
        this.userUrl = userUrl;
        this.username = username;
        this.ignoreConflicts = ignoreConflicts;
        this.cleanRegistry = cleanRegistry;
        this.testContentChanged = testContentChanged;
        OMElement metaOMElement = Utils.getMetaOMElement(workingDir);
        if (metaOMElement != null) {
            this.checkInPath = metaOMElement.getAttributeValue(new QName("path"));
        }
        if (userUrl != null) {
            this.registryUrl = Utils.getRegistryUrl(userUrl);
            String suggestedCheckInPath = Utils.getPath(userUrl);
            if (suggestedCheckInPath == null || suggestedCheckInPath.equals("")) {
                suggestedCheckInPath = "/";
            }
            if (!suggestedCheckInPath.equals(this.checkInPath)) {
                this.testContentChanged = false;
                this.checkInPath = suggestedCheckInPath;
            }
        } else {
            if (metaOMElement == null) {
                throw new SynchronizationException(MessageCode.CHECKOUT_BEFORE_CHECK_IN);
            }
            this.registryUrl = metaOMElement.getAttributeValue(new QName("registryUrl"));
        }
    }

    public int getSentCount() {
        return this.sentCount;
    }

    public void execute(Registry registry, UserInputCallback callback) throws SynchronizationException {
        if (this.inputFile != null) {
            this.restoreFromFile(registry);
        } else if (!this.testContentChanged || this.workingDir != null && Utils.contentChanged(new File(this.workingDir))) {
            this.restoreFromFileSystem(registry, callback);
        }
    }

    public void execute(Registry registry) throws SynchronizationException {
        this.execute(registry, null);
    }

    private void restoreFromFile(Registry registry) throws SynchronizationException {
        String workingDir = this.workingDir;
        if (workingDir != null) {
            this.inputFile = workingDir + File.separator + this.inputFile;
        }
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(this.inputFile));
            zis.getNextEntry();
            InputStreamReader reader = new InputStreamReader(zis);
            registry.restore(this.checkInPath, reader);
        }
        catch (FileNotFoundException e) {
            throw new SynchronizationException(MessageCode.FILE_DOES_NOT_EXIST, e, new String[]{"Output file" + this.inputFile});
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new SynchronizationException(MessageCode.ERROR_IN_CONNECTING_REGISTRY, e, new String[]{" registry url:" + this.registryUrl});
            }
            throw new SynchronizationException(MessageCode.ERROR_IN_RESTORING, e, new String[]{"path: " + this.checkInPath, "registry url: " + this.registryUrl, "username: " + this.username});
        }
        if (this.cleanRegistry && this.registryUrl == null) {
            Utils.cleanEmbeddedRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreFromFileSystem(Registry registry, UserInputCallback callback) throws SynchronizationException {
        boolean deleteTempFileFailed;
        File tempFile;
        block30: {
            this.sentCount = 0;
            tempFile = null;
            deleteTempFileFailed = false;
            XMLStreamWriter xmlWriter = null;
            FileWriter writer = null;
            try {
                try {
                    tempFile = File.createTempFile("dump", ".xml");
                    try {
                        writer = new FileWriter(tempFile);
                        xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
                        xmlWriter.writeStartDocument();
                        this.createMetaElement(xmlWriter, this.workingDir, this.checkInPath, callback);
                        xmlWriter.writeEndDocument();
                    }
                    finally {
                        try {
                            if (xmlWriter != null) {
                                xmlWriter.close();
                            }
                        }
                        finally {
                            if (writer != null) {
                                ((Writer)writer).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_CREATING_TEMP_FILE_FOR_DUMP, (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_CREATING_XML_STREAM_WRITER, (Throwable)e);
                }
                try {
                    FileReader reader = null;
                    try {
                        reader = new FileReader(tempFile);
                        registry.restore(this.checkInPath, reader);
                    }
                    finally {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_READING_TEMP_FILE_OF_DUMP, (Throwable)e);
                }
                catch (RegistryException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_RESTORING, (Throwable)((Object)e), new String[]{"path: " + this.checkInPath, "registry url: " + this.registryUrl, "username: " + this.username});
                }
                if (tempFile == null) break block30;
            }
            catch (Throwable throwable) {
                if (tempFile != null) {
                    deleteTempFileFailed = !FileUtils.deleteQuietly((File)tempFile);
                }
                throw throwable;
            }
            boolean bl = deleteTempFileFailed = !FileUtils.deleteQuietly((File)tempFile);
        }
        if (deleteTempFileFailed) {
            throw new SynchronizationException(MessageCode.ERROR_IN_CLEANING_UP, new String[]{"file path: " + tempFile.getAbsolutePath()});
        }
        if (this.cleanRegistry && this.registryUrl == null) {
            Utils.cleanEmbeddedRegistry();
        }
        if (this.filesToClean != null && this.filesToClean.size() > 0) {
            for (String filePath : this.filesToClean) {
                if (Utils.deleteFile(new File(filePath))) continue;
                throw new SynchronizationException(MessageCode.ERROR_IN_CLEANING_UP, new String[]{"file path: " + filePath});
            }
        }
        UpdateCommand updateCommand = new UpdateCommand(this.inputFile, this.workingDir, this.userUrl, true, this.username, this.cleanRegistry);
        updateCommand.execute(registry, callback);
        updateCommand.setSilentUpdate(false);
    }

    private void createMetaElement(XMLStreamWriter xmlWriter, String filePath, String path, UserInputCallback callback) throws SynchronizationException, XMLStreamException {
        File file = new File(filePath);
        if (file.isDirectory()) {
            this.createDirectoryMetaElement(xmlWriter, filePath, path, callback);
        } else {
            this.createMetaElementForChild(xmlWriter, filePath, path, null, callback);
        }
    }

    private void createDirectoryMetaElement(XMLStreamWriter xmlWriter, String filePath, String path, UserInputCallback callback) throws SynchronizationException, XMLStreamException {
        String checkoutPathAttribute;
        String metaDirectoryPath = filePath + File.separator + ".meta";
        String metaFilePath = metaDirectoryPath + File.separator + "~" + ".xml";
        OMElement metaElement = Utils.getOMElementFromMetaFile(metaFilePath);
        if (metaElement == null) {
            metaElement = Utils.createDefaultMetaFile(true, path, this.username);
            Utils.createMetaFile(metaFilePath, metaElement);
        }
        if ((checkoutPathAttribute = metaElement.getAttributeValue(new QName("checkoutPath"))) != null) {
            throw new SynchronizationException(MessageCode.CHECKOUT_OLD_VERSION);
        }
        String resourceName = RegistryUtils.getResourceName(path);
        metaElement.addAttribute("name", resourceName, null);
        Utils.writeMetaElement(xmlWriter, metaElement);
        if (callback != null) {
            callback.displayMessage(new Message(MessageCode.SENT, new String[]{filePath}));
        }
        ++this.sentCount;
        xmlWriter.writeStartElement("children");
        File directory = new File(filePath);
        String[] childrenNames = directory.list();
        LinkedList<String> filesToPreserve = new LinkedList<String>();
        if (childrenNames != null) {
            for (String childFileName : childrenNames) {
                String childResourceName = Utils.decodeFilename(childFileName);
                if (childResourceName.equals(".meta")) continue;
                if (childResourceName.endsWith(".mine") || childResourceName.endsWith(".server")) {
                    throw new SynchronizationException(MessageCode.RESOLVE_CONFLICTS);
                }
                String childPath = path.equals("/") ? "/" + childResourceName : path + "/" + childResourceName;
                String childFilePath = filePath + File.separator + childFileName;
                this.createMetaElementForChild(xmlWriter, childFilePath, childPath, filesToPreserve, callback);
            }
            filesToPreserve.add(this.getAbsoluteFilePath(metaFilePath));
            this.filesToClean.addAll(Utils.cleanUpDirectory(new File(metaDirectoryPath), filesToPreserve));
        }
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.flush();
    }

    private void createMetaElementForChild(XMLStreamWriter xmlWriter, String filePath, String path, List<String> filesToPreserve, UserInputCallback callback) throws SynchronizationException, XMLStreamException {
        File file = new File(filePath);
        String parentFilePath = file.getParent();
        String filename = file.getName();
        if (!file.isDirectory()) {
            OMElement metaElement;
            String metaFilePath = parentFilePath + File.separator + ".meta" + File.separator + "~" + filename + ".xml";
            if (filesToPreserve != null) {
                filesToPreserve.add(this.getAbsoluteFilePath(metaFilePath));
            }
            if ((metaElement = Utils.getOMElementFromMetaFile(metaFilePath)) == null) {
                metaElement = Utils.createDefaultMetaFile(false, path, this.username);
                Utils.createMetaFile(metaFilePath, metaElement);
            }
            String resourceName = RegistryUtils.getResourceName(path);
            metaElement.addAttribute("name", resourceName, null);
            if (!this.ignoreConflicts) {
                metaElement.addAttribute("ignoreConflicts", "false", null);
            }
            Utils.writeMetaElement(xmlWriter, metaElement);
            if (callback != null) {
                callback.displayMessage(new Message(MessageCode.SENT, new String[]{filePath}));
            }
            ++this.sentCount;
            byte[] content = Utils.getBytesFromFile(file);
            String encodedContent = Base64.encode((byte[])content);
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement contentEle = factory.createOMElement(new QName("content"));
            OMText contentText = factory.createOMText(encodedContent);
            contentEle.addChild((OMNode)contentText);
            contentEle.serialize(xmlWriter);
            xmlWriter.writeEndElement();
            xmlWriter.flush();
        } else {
            this.createDirectoryMetaElement(xmlWriter, filePath, path, callback);
        }
    }

    private String getAbsoluteFilePath(String filePath) {
        return new File(filePath).getAbsolutePath();
    }
}

