/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.LogEntryCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.AssociationDAO;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.dao.LogsDAO;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.jdbc.RecursionRepository;
import org.wso2.carbon.registry.core.jdbc.Repository;
import org.wso2.carbon.registry.core.jdbc.VersionRepository;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.queries.QueryProcessorManager;
import org.wso2.carbon.registry.core.jdbc.utils.DumpReader;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.statistics.query.DBQueryStatisticsLog;
import org.wso2.carbon.registry.core.statistics.query.StatisticsRecord;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.VersionedPath;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class EmbeddedRegistry
implements Registry {
    private static final Log log;
    private static final Log dbQueryLog;
    private static List<String> statEnabledOperations;
    private DataAccessManager dataAccessManager = null;
    private static ExecutorService executor;
    private Repository repository;
    private VersionRepository versionRepository;
    private QueryProcessorManager queryProcessorManager;
    private CommentsDAO commentsDAO;
    private RatingsDAO ratingsDAO;
    private TagsDAO tagsDAO;
    private AssociationDAO associationDAO = null;
    private LogsDAO logsDAO = null;
    private String defaultEventingServiceURL;
    private Map<String, String> eventingServiceURLs = new TreeMap<String, String>();
    private RegistryContext registryContext;
    private RealmService realmService = null;

    private static synchronized void initializeStatisticsLogging() {
        if (executor != null) {
            return;
        }
        executor = Executors.newSingleThreadExecutor();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdownNow();
            }
        });
    }

    public EmbeddedRegistry() {
    }

    public EmbeddedRegistry(RegistryContext registryContext, RealmService realmService) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registryContext = registryContext;
        this.dataAccessManager = registryContext.getDataAccessManager();
        this.logsDAO = this.dataAccessManager.getDAOManager().getLogsDAO();
        this.associationDAO = this.dataAccessManager.getDAOManager().getAssociationDAO();
        this.realmService = realmService;
        this.init();
    }

    public void configure(DataAccessManager dataAccessManager, RealmService realmService) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.dataAccessManager = dataAccessManager;
        this.logsDAO = dataAccessManager.getDAOManager().getLogsDAO();
        this.associationDAO = dataAccessManager.getDAOManager().getAssociationDAO();
        this.realmService = realmService;
        this.init();
    }

    private void init() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.beginDBQueryLog(2);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initialing main registry");
        }
        if (this.registryContext == null) {
            this.registryContext = RegistryContext.getBaseInstance(this.realmService);
        }
        this.registryContext.setDataAccessManager(this.dataAccessManager);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing the version repository.");
        }
        this.versionRepository = new VersionRepository(this.dataAccessManager);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing the repository.");
        }
        this.repository = new Repository(this.dataAccessManager, this.versionRepository, this.registryContext.isVersionOnChange(), new RecursionRepository(this));
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing the query manager for processing custom queries.");
        }
        this.queryProcessorManager = new QueryProcessorManager(this.dataAccessManager, this.registryContext);
        this.registryContext.setRepository(this.repository);
        this.registryContext.setVersionRepository(this.versionRepository);
        this.registryContext.setQueryProcessorManager(this.queryProcessorManager);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initialing the content indexing system.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing DAOs depending on the static configurations.");
        }
        this.commentsDAO = this.dataAccessManager.getDAOManager().getCommentsDAO(StaticConfiguration.isVersioningComments());
        this.ratingsDAO = this.dataAccessManager.getDAOManager().getRatingsDAO(StaticConfiguration.isVersioningRatings());
        this.tagsDAO = this.dataAccessManager.getDAOManager().getTagsDAO(StaticConfiguration.isVersioningTags());
        if (log.isTraceEnabled()) {
            log.trace((Object)"Main registry initialized successfully.");
        }
        this.endDBQueryLog(2);
    }

    private void beginDBQueryLog(int level) {
        if (dbQueryLog.isDebugEnabled()) {
            StatisticsRecord statisticsRecord;
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[level];
            String methodName = traceElement.getMethodName();
            if (!statEnabledOperations.isEmpty() && statEnabledOperations.contains(methodName) && traceElement.getClassName().equals(this.getClass().getCanonicalName()) && (statisticsRecord = DBQueryStatisticsLog.getStatisticsRecord()).increment() == 0) {
                DBQueryStatisticsLog.clearStatisticsRecord();
                statisticsRecord = DBQueryStatisticsLog.getStatisticsRecord();
                statisticsRecord.increment();
                statisticsRecord.setOperation(methodName);
            }
        }
    }

    private void endDBQueryLog(int level) {
        if (dbQueryLog.isDebugEnabled()) {
            StatisticsRecord statisticsRecord;
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[level];
            String methodName = traceElement.getMethodName();
            if (!statEnabledOperations.isEmpty() && statEnabledOperations.contains(methodName) && traceElement.getClassName().equals(this.getClass().getCanonicalName()) && (statisticsRecord = DBQueryStatisticsLog.getStatisticsRecord()).decrement() == 0) {
                final StatisticsRecord clone = new StatisticsRecord(statisticsRecord);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (clone.getTableRecords().length > 0) {
                            dbQueryLog.debug((Object)"");
                            dbQueryLog.debug((Object)"---------------------------------------------------");
                            dbQueryLog.debug((Object)("Registry Operation: " + clone.getOperation()));
                            dbQueryLog.debug((Object)"");
                            for (String record : clone.getTableRecords()) {
                                dbQueryLog.debug((Object)("Tables Accessed: " + record));
                            }
                            if (Boolean.toString(true).equals(System.getProperty("carbon.registry.statistics.output.queries.executed"))) {
                                dbQueryLog.debug((Object)"");
                                StringBuffer sb = new StringBuffer();
                                for (String query : clone.getQueries()) {
                                    sb.append("\n").append(query);
                                }
                                dbQueryLog.debug((Object)("Queries Executed:" + sb.toString()));
                            }
                            dbQueryLog.debug((Object)"---------------------------------------------------");
                            dbQueryLog.debug((Object)"");
                        }
                    }
                };
                if (executor != null) {
                    executor.submit(runnable);
                } else {
                    EmbeddedRegistry.initializeStatisticsLogging();
                    executor.submit(runnable);
                }
                DBQueryStatisticsLog.clearStatisticsRecord();
            }
        }
    }

    private void initializeIndex() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    @Override
    public void beginTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.beginDBQueryLog(3);
        this.dataAccessManager.getTransactionManager().beginTransaction();
    }

    @Override
    public void rollbackTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.dataAccessManager.getTransactionManager().rollbackTransaction();
        this.endDBQueryLog(3);
    }

    @Override
    public void commitTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.dataAccessManager.getTransactionManager().commitTransaction();
        this.endDBQueryLog(3);
    }

    @Override
    public RegistryContext getRegistryContext() {
        this.beginDBQueryLog(2);
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        String chroot = CurrentSession.getChroot();
        if (chroot == null) {
            chroot = "/";
        } else if (!chroot.endsWith("/")) {
            chroot = chroot + "/";
        }
        context.setResourcePath(new ResourcePath(chroot));
        RegistryContext output = this.registryContext.getHandlerManager().getRegistryContext(context);
        this.endDBQueryLog(2);
        if (output != null) {
            return output;
        }
        return this.registryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource newResource() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.beginDBQueryLog(2);
        try {
            ResourceImpl resource = new ResourceImpl();
            resource.setAuthorUserName(CurrentSession.getUser());
            ResourceImpl resourceImpl = resource;
            return resourceImpl;
        }
        finally {
            this.endDBQueryLog(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection newCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.beginDBQueryLog(2);
        try {
            CollectionImpl coll = new CollectionImpl();
            coll.setAuthorUserName(CurrentSession.getUser());
            CollectionImpl collectionImpl = coll;
            return collectionImpl;
        }
        finally {
            this.endDBQueryLog(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource get(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            Resource resource = this.registryContext.getHandlerManager().get(context);
            if (!context.isSimulation()) {
                if (resource == null) {
                    resource = context.getResource();
                }
                if (resource == null) {
                    VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
                    resource = versionedPath.getVersion() == -1L ? this.repository.get(resourcePath.getPath()) : this.versionRepository.get(versionedPath);
                }
                if (resource == null) {
                    throw new ResourceNotFoundException(path);
                }
                context.setResource(resource);
                this.registryContext.getHandlerManager("commit").get(context);
                transactionSucceeded = true;
            }
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").get(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getMetaData(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
            Resource resource = versionedPath.getVersion() == -1L ? this.repository.getMetaData(resourcePath.getPath()) : this.versionRepository.getMetaData(versionedPath);
            if (resource == null) {
                throw new ResourceNotFoundException(path);
            }
            transactionSucceeded = true;
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    public String importResource(String suggestedPath, String sourceURL, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.importResource(suggestedPath, sourceURL, (Resource)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection get(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
            Collection collection = versionedPath.getVersion() == -1L ? this.repository.get(resourcePath.getPath(), start, pageSize) : this.versionRepository.get(versionedPath, start, pageSize);
            transactionSucceeded = true;
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resourceExists(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            boolean output = this.registryContext.getHandlerManager().resourceExists(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
                    output = versionedPath.getVersion() == -1L ? this.repository.resourceExists(resourcePath.getPath()) : this.versionRepository.resourceExists(versionedPath);
                }
                this.registryContext.getHandlerManager("commit").resourceExists(context);
                transactionSucceeded = true;
            }
            boolean bl = output;
            return bl;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").resourceExists(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    public String put(String suggestedPath, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.put(suggestedPath, (Resource)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String suggestedPath, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        boolean mustPutChild = false;
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(suggestedPath);
            context.setResourcePath(resourcePath);
            context.setResource(resource);
            if (this.repository.resourceExists(suggestedPath)) {
                context.setOldResource(this.repository.get(suggestedPath));
            }
            if (!"/".equals(resourcePath.getPath())) {
                mustPutChild = true;
                this.registryContext.getHandlerManager().putChild(context);
            }
            this.registryContext.getHandlerManager().put(context);
            if (!context.isSimulation()) {
                String actualPath = context.getActualPath();
                if (!context.isProcessingComplete()) {
                    ((ResourceImpl)resource).prepareContentForPut();
                    actualPath = suggestedPath;
                    try {
                        CurrentSession.setAttribute("isLoggingActivity", context.isLoggingActivity());
                        this.repository.put(suggestedPath, resource);
                    }
                    finally {
                        CurrentSession.removeAttribute("isLoggingActivity");
                    }
                }
                if (mustPutChild) {
                    this.registryContext.getHandlerManager("commit").putChild(context);
                }
                this.registryContext.getHandlerManager("commit").put(context);
                transactionSucceeded = true;
                if (actualPath == null) {
                    String string = suggestedPath;
                    return string;
                }
                String string = actualPath;
                return string;
            }
            String string = suggestedPath;
            return string;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    if (mustPutChild) {
                        this.registryContext.getHandlerManager("rollback").putChild(context);
                    }
                    this.registryContext.getHandlerManager("rollback").put(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String importResource(String suggestedPath, String sourceURL, Resource metaResource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        RequestContext importChildContext = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(suggestedPath);
            importChildContext.setResourcePath(resourcePath);
            context.setResourcePath(resourcePath);
            context.setSourceURL(sourceURL);
            context.setResource(metaResource);
            if (this.repository.resourceExists(suggestedPath)) {
                Resource resource = this.repository.get(suggestedPath);
                importChildContext.setOldResource(resource);
                context.setOldResource(resource);
            }
            this.registryContext.getHandlerManager().importChild(importChildContext);
            this.registryContext.getHandlerManager().importResource(context);
            if (!context.isSimulation()) {
                String savedPath = context.getActualPath();
                if (!context.isProcessingComplete()) {
                    savedPath = suggestedPath;
                    if (context.getResource() != null) {
                        metaResource = context.getResource();
                    }
                    try {
                        CurrentSession.setAttribute("isLoggingActivity", context.isLoggingActivity());
                        this.repository.importResource(resourcePath.getPath(), sourceURL, metaResource);
                    }
                    finally {
                        CurrentSession.removeAttribute("isLoggingActivity");
                    }
                }
                if (savedPath != null && context.isLoggingActivity()) {
                    this.registryContext.getLogWriter().addLog(savedPath, CurrentSession.getUser(), 1, null);
                }
                this.registryContext.getHandlerManager("commit").importChild(importChildContext);
                this.registryContext.getHandlerManager("commit").importResource(context);
                transactionSucceeded = true;
                if (savedPath != null) {
                    String string = savedPath;
                    return string;
                }
            }
            String string = suggestedPath;
            return string;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").importChild(importChildContext);
                    this.registryContext.getHandlerManager("rollback").importResource(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setRegistryContext(this.registryContext);
            context.setResourcePath(resourcePath);
            this.registryContext.getHandlerManager().delete(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete() && this.repository.resourceExists(resourcePath.getPath())) {
                    this.repository.delete(resourcePath.getPath());
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(resourcePath.getPath(), CurrentSession.getUser(), 7, null);
                    }
                }
                this.registryContext.getHandlerManager("commit").delete(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").delete(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rename(String currentPath, String newName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(currentPath);
            context.setRegistryContext(this.registryContext);
            context.setSourcePath(currentPath);
            context.setTargetPath(newName);
            String newPath = this.registryContext.getHandlerManager().rename(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    try {
                        CurrentSession.setAttribute("isLoggingActivity", context.isLoggingActivity());
                        newPath = this.repository.rename(resourcePath, newName);
                    }
                    finally {
                        CurrentSession.removeAttribute("isLoggingActivity");
                    }
                }
                if (context.isLoggingActivity()) {
                    this.registryContext.getLogWriter().addLog(newPath, CurrentSession.getUser(), 9, currentPath);
                }
                this.registryContext.getHandlerManager("commit").rename(context);
                transactionSucceeded = true;
            }
            String string = newPath;
            return string;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").rename(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String move(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath currentResourcePath = new ResourcePath(currentPath);
            context.setSourcePath(currentPath);
            context.setTargetPath(newPath);
            context.setRegistryContext(this.registryContext);
            String movedPath = this.registryContext.getHandlerManager().move(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    try {
                        CurrentSession.setAttribute("isLoggingActivity", context.isLoggingActivity());
                        movedPath = this.repository.move(currentResourcePath, newPath);
                    }
                    finally {
                        CurrentSession.removeAttribute("isLoggingActivity");
                    }
                }
                if (context.isLoggingActivity()) {
                    this.registryContext.getLogWriter().addLog(newPath, CurrentSession.getUser(), 10, currentPath);
                }
                this.registryContext.getHandlerManager("commit").move(context);
                transactionSucceeded = true;
            }
            String string = movedPath;
            return string;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").move(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String copy(String sourcePath, String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath sourceResourcePath = new ResourcePath(sourcePath);
            ResourcePath targetResourcePath = new ResourcePath(targetPath);
            context.setSourcePath(sourcePath);
            context.setTargetPath(targetPath);
            String copiedPath = this.registryContext.getHandlerManager().copy(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    try {
                        CurrentSession.setAttribute("isLoggingActivity", context.isLoggingActivity());
                        copiedPath = this.repository.copy(sourceResourcePath, targetResourcePath);
                    }
                    finally {
                        CurrentSession.removeAttribute("isLoggingActivity");
                    }
                }
                if (context.isLoggingActivity()) {
                    this.registryContext.getLogWriter().addLog(sourcePath, CurrentSession.getUser(), 11, targetPath);
                }
                this.registryContext.getHandlerManager("commit").copy(context);
                transactionSucceeded = true;
            }
            String string = copiedPath;
            return string;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").copy(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createVersion(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            this.registryContext.getHandlerManager().createVersion(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    this.versionRepository.createSnapshot(resourcePath, true, true);
                }
                this.registryContext.getHandlerManager("commit").createVersion(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").createVersion(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getVersions(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            context.setResourcePath(new ResourcePath(path));
            String[] output = this.registryContext.getHandlerManager().getVersions(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    output = this.versionRepository.getVersions(path);
                }
                this.registryContext.getHandlerManager("commit").getVersions(context);
                transactionSucceeded = true;
            }
            String[] stringArray = output;
            return stringArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getVersions(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreVersion(String versionPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            context.setVersionPath(versionPath);
            ResourcePath versionedResourcePath = new ResourcePath(versionPath);
            String path = versionedResourcePath.getPath();
            if (this.repository.resourceExists(path)) {
                context.setOldResource(this.repository.get(path));
            }
            this.registryContext.getHandlerManager().restoreVersion(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    if (this.repository.resourceExists(path)) {
                        this.repository.prepareVersionRestore(path);
                    }
                    this.versionRepository.restoreVersion(versionedResourcePath);
                    VersionedPath versionedPath = RegistryUtils.getVersionedPath(versionedResourcePath);
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(path, CurrentSession.getUser(), 8, Long.toString(versionedPath.getVersion()));
                    }
                }
                this.registryContext.getHandlerManager("commit").restoreVersion(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").restoreVersion(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            ResourcePath targetResourcePath;
            this.beginTransaction();
            ResourcePath sourceResourcePath = new ResourcePath(sourcePath);
            if (this.repository.resourceExists(sourceResourcePath.getPath())) {
                sourcePath = sourceResourcePath.getPathWithVersion();
            }
            if (this.repository.resourceExists((targetResourcePath = new ResourcePath(targetPath)).getPath())) {
                targetPath = targetResourcePath.getPathWithVersion();
            }
            context.setSourcePath(sourcePath);
            context.setTargetPath(targetPath);
            context.setAssociationType(associationType);
            context.setOldAssociationsOnSource(this.getAllAssociations(sourcePath));
            context.setOldAssociationsOnTarget(this.getAllAssociations(targetPath));
            this.registryContext.getHandlerManager().addAssociation(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    this.associationDAO.addAssociation(sourcePath, targetPath, associationType);
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(sourcePath, CurrentSession.getUser(), 15, associationType + ";" + targetPath);
                    }
                }
                this.registryContext.getHandlerManager("commit").addAssociation(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").addAssociation(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            ResourcePath targetResourcePath;
            this.beginTransaction();
            ResourcePath sourceResourcePath = new ResourcePath(sourcePath);
            if (this.repository.resourceExists(sourceResourcePath.getPath())) {
                sourcePath = sourceResourcePath.getPathWithVersion();
            }
            if (this.repository.resourceExists((targetResourcePath = new ResourcePath(targetPath)).getPath())) {
                targetPath = targetResourcePath.getPathWithVersion();
            }
            context.setSourcePath(sourcePath);
            context.setTargetPath(targetPath);
            context.setAssociationType(associationType);
            context.setOldAssociationsOnSource(this.getAllAssociations(sourcePath));
            context.setOldAssociationsOnTarget(this.getAllAssociations(targetPath));
            this.registryContext.getHandlerManager().removeAssociation(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    this.associationDAO.removeAssociation(sourcePath, targetPath, associationType);
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(sourcePath, CurrentSession.getUser(), 16, associationType + ";" + targetPath);
                    }
                }
                this.registryContext.getHandlerManager("commit").removeAssociation(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").removeAssociation(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association[] getAllAssociations(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            if (this.repository.resourceExists(processedPath.getPath())) {
                resourcePath = processedPath.getPathWithVersion();
            }
            context.setResourcePath(new ResourcePath(resourcePath));
            Association[] associations = this.registryContext.getHandlerManager().getAllAssociations(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    associations = this.associationDAO.getAllAssociations(resourcePath);
                }
                this.registryContext.getHandlerManager("commit").getAllAssociations(context);
                transactionSucceeded = true;
            }
            Association[] associationArray = associations;
            return associationArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getAllAssociations(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association[] getAssociations(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            if (this.repository.resourceExists(processedPath.getPath())) {
                resourcePath = processedPath.getPathWithVersion();
            }
            context.setResourcePath(new ResourcePath(resourcePath));
            context.setAssociationType(associationType);
            Association[] associations = this.registryContext.getHandlerManager().getAssociations(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    associations = this.associationDAO.getAllAssociationsForType(resourcePath, associationType);
                }
                this.registryContext.getHandlerManager("commit").getAssociations(context);
                transactionSucceeded = true;
            }
            Association[] associationArray = associations;
            return associationArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getAssociations(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTag(String resourcePath, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String ILLEGAL_CHARACTERS_FOR_TAG = ".*[~!@#;%^*+={}\\|\\\\<>\"'].*";
        Pattern illegalCharactersPattern = Pattern.compile(".*[~!@#;%^*+={}\\|\\\\<>\"'].*");
        if (illegalCharactersPattern.matcher(tag).matches()) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("The tag '" + tag + "' contains one or more illegal " + "characters (~!@#;%^*()+={}|\\<>\"')");
        }
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            context.setResourcePath(processedPath);
            context.setTag(tag);
            context.setOldTags(this.getTags(processedPath.getPath()));
            this.registryContext.getHandlerManager().applyTag(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    if (!processedPath.isCurrentVersion()) {
                        String msg = "Failed to apply tag to the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    resourcePath = processedPath.getPath();
                    String[] tags = tag.split(",");
                    ResourceImpl resource = this.tagsDAO.getResourceWithMinimumData(resourcePath);
                    if (resource == null) {
                        String msg = "Failed to apply tag " + tag + " on resource " + resourcePath + ". Resource " + resourcePath + " does not exist.";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    String userName = CurrentSession.getUser();
                    if (!AuthorizationUtils.authorize(resource.getPath(), "http://www.wso2.org/projects/registry/actions/get")) {
                        String msg = "Failed to apply tag " + tag + " on resource " + resourcePath + ". User " + userName + " is not authorized to read the resource.";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    for (int i = 0; i < tags.length; ++i) {
                        tags[i] = tags[i].trim();
                        if (tags[i].length() == 0 || tags[i].equals(" ") || this.tagsDAO.taggingExists(tags[i], resource, userName)) continue;
                        this.tagsDAO.addTagging(tags[i], resource, userName);
                        if (!context.isLoggingActivity()) continue;
                        this.registryContext.getLogWriter().addLog(resourcePath, userName, 4, tags[i]);
                    }
                }
                this.registryContext.getHandlerManager("commit").applyTag(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").applyTag(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggedResourcePath[] getResourcePathsWithTag(String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            context.setTag(tag);
            TaggedResourcePath[] output = this.registryContext.getHandlerManager().getResourcePathsWithTag(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    java.util.Collection taggedPathsSet;
                    String[] tags = tag.trim().split(",");
                    for (int i = 0; i < tags.length; ++i) {
                        tags[i] = tags[i].trim();
                    }
                    HashMap<String, TaggedResourcePath> taggedPaths = new HashMap<String, TaggedResourcePath>();
                    List pathList = this.tagsDAO.getPathsWithAnyTag(tags);
                    for (String path : pathList) {
                        TaggedResourcePath taggedResourcePath = new TaggedResourcePath();
                        taggedResourcePath.setResourcePath(path);
                        ResourceImpl resourceImpl = this.tagsDAO.getResourceWithMinimumData(path);
                        for (String currentTag : tags) {
                            long count = this.tagsDAO.getTagCount(resourceImpl, currentTag);
                            taggedResourcePath.addTagCount(currentTag, count);
                            taggedPaths.put(currentTag + path, taggedResourcePath);
                        }
                    }
                    if (output == null || output.length == 0) {
                        taggedPathsSet = taggedPaths.values();
                        output = taggedPathsSet.toArray(new TaggedResourcePath[taggedPathsSet.size()]);
                    } else {
                        for (TaggedResourcePath taggedResourcePath : output) {
                            for (String currentTag : taggedResourcePath.getTagCounts().keySet()) {
                                taggedPaths.put(currentTag + taggedResourcePath.getResourcePath(), taggedResourcePath);
                            }
                        }
                        taggedPathsSet = taggedPaths.values();
                        output = taggedPathsSet.toArray(new TaggedResourcePath[taggedPathsSet.size()]);
                    }
                }
                this.registryContext.getHandlerManager("commit").getResourcePathsWithTag(context);
                transactionSucceeded = true;
            }
            TaggedResourcePath[] taggedResourcePathArray = output;
            return taggedResourcePathArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getResourcePathsWithTag(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag[] getTags(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            context.setResourcePath(new ResourcePath(path));
            Tag[] output = this.registryContext.getHandlerManager().getTags(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    ResourcePath resourcePath = new ResourcePath(path = RegistryUtils.prepareGeneralPath(path));
                    VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
                    ResourceImpl resourceImpl = versionedPath.getVersion() == -1L ? this.tagsDAO.getResourceWithMinimumData(resourcePath.getPath()) : (ResourceImpl)this.versionRepository.getMetaData(versionedPath);
                    if (resourceImpl == null) {
                        String msg = "Failed to get tags of " + path + ". The resource doesn't exists.";
                        log.debug((Object)msg);
                        output = new Tag[]{};
                    } else {
                        output = this.tagsDAO.getTagsWithCount(resourceImpl);
                    }
                }
                this.registryContext.getHandlerManager("commit").getTags(context);
                transactionSucceeded = true;
            }
            Tag[] tagArray = output;
            return tagArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getTags(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTag(String path, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        block23: {
            boolean transactionSucceeded = false;
            RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
            try {
                this.beginTransaction();
                ResourcePath processedPath = new ResourcePath(path);
                context.setResourcePath(processedPath);
                context.setTag(tag);
                context.setOldTags(this.getTags(processedPath.getPath()));
                this.registryContext.getHandlerManager().removeTag(context);
                if (context.isSimulation()) break block23;
                if (!context.isProcessingComplete()) {
                    ResourceImpl resource;
                    RealmConfiguration realmConfig;
                    if (!processedPath.isCurrentVersion()) {
                        String msg = "Failed to remove tag from the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    path = processedPath.getPath();
                    path = RegistryUtils.prepareGeneralPath(path);
                    String user = CurrentSession.getUser();
                    UserRealm userRealm = CurrentSession.getUserRealm();
                    boolean adminUser = false;
                    try {
                        realmConfig = userRealm.getRealmConfiguration();
                    }
                    catch (UserStoreException e) {
                        String msg = "Failed to retrieve realm configuration.";
                        log.error((Object)msg, (Throwable)e);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
                    }
                    try {
                        String[] roles = userRealm.getUserStoreManager().getRoleListOfUser(user);
                        String adminRoleName = realmConfig.getAdminRoleName();
                        if (RegistryUtils.containsString(adminRoleName, roles)) {
                            adminUser = true;
                        }
                    }
                    catch (UserStoreException e) {
                        String msg = "Failed to get roles of the current user. User will be considered as non-admin user.\n" + e.getMessage();
                        log.error((Object)msg, (Throwable)e);
                        adminUser = false;
                    }
                    String adminUsername = realmConfig.getAdminUserName();
                    if (adminUsername.equals(user)) {
                        adminUser = true;
                    }
                    if (adminUser) {
                        resource = this.tagsDAO.getResourceWithMinimumData(path);
                        this.tagsDAO.removeTags(resource, tag);
                    } else {
                        resource = (ResourceImpl)this.repository.getMetaData(path);
                        String author = resource.getAuthorUserName();
                        if (user.equals(author)) {
                            this.tagsDAO.removeTags(resource, tag);
                        } else {
                            this.tagsDAO.removeTags(resource, tag, user);
                        }
                    }
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(path, user, 5, tag);
                    }
                }
                this.registryContext.getHandlerManager("commit").removeTag(context);
                transactionSucceeded = true;
            }
            finally {
                if (transactionSucceeded) {
                    this.commitTransaction();
                } else {
                    try {
                        this.registryContext.getHandlerManager("rollback").removeTag(context);
                    }
                    finally {
                        this.rollbackTransaction();
                    }
                }
            }
        }
    }

    public String addComment(String resourcePath, org.wso2.carbon.registry.api.Comment comment) throws RegistryException {
        return this.addComment(resourcePath, (Comment)comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addComment(String resourcePath, Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            context.setResourcePath(processedPath);
            context.setComment(comment);
            context.setOldComments(this.getComments(processedPath.getPath()));
            String output = this.registryContext.getHandlerManager().addComment(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    if (!processedPath.isCurrentVersion()) {
                        String msg = "Failed to add comment to the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    resourcePath = processedPath.getPath();
                    String userName = CurrentSession.getUser();
                    if (!AuthorizationUtils.authorize(resourcePath, "http://www.wso2.org/projects/registry/actions/get")) {
                        String msg = "Failed to apply comment " + comment.getText() + " on resource " + resourcePath + ". User " + userName + " is not authorized to read the " + "resource.";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    try {
                        ResourceImpl resource = this.commentsDAO.getResourceWithMinimumData(resourcePath);
                        if (resource == null) {
                            String msg = "Failed to add comment " + comment.getText() + " to resource " + resourcePath + ". Resource " + resourcePath + " does not exist.";
                            log.error((Object)msg);
                            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                        }
                        int commentId = this.commentsDAO.addComment(resource, userName, comment);
                        String commentPath = resourcePath + ";" + "comments:" + commentId;
                        if (context.isLoggingActivity()) {
                            this.registryContext.getLogWriter().addLog(resourcePath, userName, 2, comment.getText());
                        }
                        output = commentPath;
                    }
                    catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
                        String msg = "Failed to add comment " + comment.getText() + " on resource " + resourcePath + ". User " + userName + ".";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                }
                this.registryContext.getHandlerManager("commit").addComment(context);
                transactionSucceeded = true;
            }
            String string = output;
            return string;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").addComment(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editComment(String commentPath, String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(commentPath);
            Comment comment = new Comment();
            comment.setCommentPath(commentPath);
            comment.setText(text);
            context.setResourcePath(processedPath);
            context.setComment(comment);
            context.setOldComments(this.getComments(commentPath));
            this.registryContext.getHandlerManager().editComment(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    String userName = CurrentSession.getUser();
                    String[] parts = commentPath.split(";");
                    if (parts.length == 2) {
                        String resourcePath = parts[0];
                        String commentPart = parts[1];
                        if (!AuthorizationUtils.authorize(resourcePath, "http://www.wso2.org/projects/registry/actions/get")) {
                            String msg = "Failed to edit comment " + text + " on resource " + resourcePath + ". User " + userName + " is not authorized to read " + "the resource.";
                            log.error((Object)msg);
                            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                        }
                        if (commentPart.startsWith("comments:")) {
                            String commentId = commentPart.substring(9);
                            this.commentsDAO.updateComment(Long.parseLong(commentId), text);
                        }
                    }
                }
                this.registryContext.getHandlerManager("commit").editComment(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").editComment(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComment(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(commentPath);
            Comment comment = new Comment();
            comment.setCommentPath(commentPath);
            context.setResourcePath(processedPath);
            context.setComment(comment);
            context.setOldComments(this.getComments(commentPath));
            this.registryContext.getHandlerManager().removeComment(context);
            if (!context.isProcessingComplete()) {
                RealmConfiguration realmConfig;
                if (!processedPath.isCurrentVersion()) {
                    String msg = "Failed to remove tag from the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                    log.error((Object)msg);
                    throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                }
                String user = CurrentSession.getUser();
                UserRealm userRealm = CurrentSession.getUserRealm();
                boolean adminUser = false;
                try {
                    realmConfig = userRealm.getRealmConfiguration();
                }
                catch (UserStoreException e) {
                    String msg = "Failed to retrieve realm configuration.";
                    log.error((Object)msg, (Throwable)e);
                    throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
                }
                try {
                    String[] roles = userRealm.getUserStoreManager().getRoleListOfUser(user);
                    String adminRoleName = realmConfig.getAdminRoleName();
                    if (RegistryUtils.containsString(adminRoleName, roles)) {
                        adminUser = true;
                    }
                }
                catch (UserStoreException e) {
                    String msg = "Failed to get roles of the current user. User will be considered as non-admin user.\n" + e.getMessage();
                    log.error((Object)msg, (Throwable)e);
                    adminUser = false;
                }
                String adminUsername = realmConfig.getAdminUserName();
                if (adminUsername.equals(user)) {
                    adminUser = true;
                }
                String[] parts = commentPath.split(";");
                String commentPart = parts[1];
                String commentId = null;
                if (parts.length == 2 && commentPart.startsWith("comments:")) {
                    commentId = parts[1].substring(9);
                }
                Comment temp = this.commentsDAO.getComment(Long.parseLong(commentId), processedPath.getPath());
                if (adminUser) {
                    this.commentsDAO.deleteComment(Long.parseLong(commentId));
                } else {
                    ResourceImpl resource = (ResourceImpl)this.repository.getMetaData(processedPath.getPath());
                    String author = resource.getAuthorUserName();
                    if (user.equals(author)) {
                        this.commentsDAO.deleteComment(Long.parseLong(commentId));
                    } else if (temp != null && user.equals(temp.getUser())) {
                        this.commentsDAO.deleteComment(Long.parseLong(commentId));
                    } else {
                        String msg = "User: " + user + " is not authorized to delete the comment on the resource: " + processedPath.getPath();
                        log.warn((Object)msg);
                        throw new AuthorizationFailedException(msg);
                    }
                }
                if (context.isLoggingActivity()) {
                    if (temp != null) {
                        this.registryContext.getLogWriter().addLog(processedPath.getPath(), user, 3, temp.getText());
                    } else {
                        this.registryContext.getLogWriter().addLog(processedPath.getPath(), user, 3, commentPath);
                    }
                }
            }
            this.registryContext.getHandlerManager("commit").removeComment(context);
            transactionSucceeded = true;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").removeComment(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment[] getComments(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            Comment[] output = this.registryContext.getHandlerManager().getComments(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
                    ResourceImpl resourceImpl = versionedPath.getVersion() == -1L ? this.commentsDAO.getResourceWithMinimumData(resourcePath.getPath()) : (ResourceImpl)this.versionRepository.getMetaData(versionedPath);
                    output = resourceImpl == null ? new Comment[]{} : this.commentsDAO.getComments(resourceImpl);
                }
                this.registryContext.getHandlerManager("commit").getComments(context);
                transactionSucceeded = true;
            }
            Comment[] commentArray = output;
            return commentArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getComments(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rateResource(String resourcePath, int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            String userName = CurrentSession.getUser();
            context.setResourcePath(new ResourcePath(resourcePath));
            context.setRating(rating);
            context.setOldRating(this.getRating(resourcePath, userName));
            context.setOldAverageRating(this.getAverageRating(resourcePath));
            this.registryContext.getHandlerManager().rateResource(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    ResourcePath processedPath = new ResourcePath(resourcePath);
                    if (!processedPath.isCurrentVersion()) {
                        String msg = "Failed to apply rating to the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    resourcePath = processedPath.getPath();
                    ResourceImpl resourceImpl = this.ratingsDAO.getResourceWithMinimumData(resourcePath);
                    if (resourceImpl != null) {
                        if (!AuthorizationUtils.authorize(resourcePath, "http://www.wso2.org/projects/registry/actions/get")) {
                            String msg = "Failed to rate resource " + resourcePath + " with rating " + rating + ". User " + userName + " is not authorized to read the resource.";
                            log.error((Object)msg);
                            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                        }
                        int rateID = this.ratingsDAO.getRateID(resourceImpl, userName);
                        if (rateID > -1) {
                            if (rating == 0) {
                                this.ratingsDAO.removeRating(resourceImpl, rateID);
                            } else {
                                this.ratingsDAO.updateRating(resourceImpl, rateID, rating);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Updated the rating on the resource " + resourcePath + " by user " + userName));
                            }
                        } else {
                            this.ratingsDAO.addRating(resourceImpl, userName, rating);
                        }
                        if (context.isLoggingActivity()) {
                            this.registryContext.getLogWriter().addLog(resourcePath, userName, 6, Integer.toString(rating));
                        }
                    } else {
                        String msg = "Rate on Null resource " + resourcePath;
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                }
                this.registryContext.getHandlerManager("commit").rateResource(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").rateResource(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAverageRating(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            float rating = this.registryContext.getHandlerManager().getAverageRating(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
                    ResourceImpl resourceImpl = versionedPath.getVersion() == -1L ? this.ratingsDAO.getResourceWithMinimumData(resourcePath.getPath()) : (ResourceImpl)this.versionRepository.getMetaData(versionedPath);
                    if (resourceImpl == null) {
                        String msg = "Rate on Null resource " + path;
                        log.debug((Object)msg);
                        rating = 0.0f;
                    } else {
                        rating = this.ratingsDAO.getAverageRating(resourceImpl);
                    }
                }
                this.registryContext.getHandlerManager("commit").getAverageRating(context);
                transactionSucceeded = true;
            }
            float f = rating;
            return f;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getAverageRating(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRating(String path, String userName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            context.setUserName(userName);
            int rating = this.registryContext.getHandlerManager().getRating(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
                    ResourceImpl resourceImpl = versionedPath.getVersion() == -1L ? this.ratingsDAO.getResourceWithMinimumData(resourcePath.getPath()) : (ResourceImpl)this.versionRepository.getMetaData(versionedPath);
                    if (resourceImpl == null) {
                        String msg = "Rate on Null resource " + path;
                        log.error((Object)msg);
                        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                    }
                    rating = this.ratingsDAO.getRating(resourceImpl, userName);
                }
                this.registryContext.getHandlerManager("commit").getRating(context);
                transactionSucceeded = true;
            }
            int n = rating;
            return n;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").getRating(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection executeQuery(String path, Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        Resource query = null;
        try {
            String purePath;
            this.beginTransaction();
            UserRegistry systemRegistry = new UserRegistry("wso2.system.user", CurrentSession.getTenantId(), this, this.realmService, null);
            if (path != null && systemRegistry.resourceExists(purePath = RegistryUtils.getPureResourcePath(path)) && (query = systemRegistry.get(purePath)) != null && (query.getMediaType() == null || query.getMediaType().length() == 0)) {
                query = null;
            }
            if (path != null) {
                context.setResourcePath(new ResourcePath(path));
            }
            context.setResource(query);
            context.setQueryParameters(parameters);
            Collection output = this.registryContext.getHandlerManager().executeQuery(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    if (query == null) {
                        query = this.newResource();
                        String mediaType = (String)parameters.get("mediaType");
                        query.setMediaType(mediaType != null ? mediaType : "application/vnd.sql.query");
                    }
                    Collection temp = this.queryProcessorManager.executeQuery(this, query, parameters);
                    LinkedHashSet<String> results = new LinkedHashSet<String>();
                    if (output != null) {
                        String[] children = output.getChildren();
                        if (children != null) {
                            for (String child : children) {
                                if (child == null || !this.resourceExists(child)) continue;
                                results.add(child);
                            }
                        }
                        if (temp != null) {
                            children = temp.getChildren();
                            if (children != null) {
                                for (String child : children) {
                                    if (child == null || !this.resourceExists(child)) continue;
                                    results.add(child);
                                }
                            }
                        } else {
                            temp = output;
                        }
                        temp.setContent(results.toArray(new String[results.size()]));
                    }
                    output = temp;
                }
                this.registryContext.getHandlerManager("commit").executeQuery(context);
                transactionSucceeded = true;
            }
            Collection collection = output;
            return collection;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").executeQuery(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry[] getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        try {
            this.beginTransaction();
            List logEntryList = this.logsDAO.getLogs(resourcePath, action, userName, from, to, recentFirst);
            for (int i = logEntryList.size() - 1; i >= 0; --i) {
                LogEntry logEntry = (LogEntry)((Object)logEntryList.get(i));
                if (logEntry != null) continue;
                logEntryList.remove(i);
            }
            LogEntry[] logEntries = new LogEntry[logEntryList.size()];
            for (int i = 0; i < logEntryList.size(); ++i) {
                logEntries[i] = (LogEntry)((Object)logEntryList.get(i));
            }
            transactionSucceeded = true;
            LogEntry[] logEntryArray = logEntries;
            return logEntryArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntryCollection getLogCollection(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        try {
            this.beginTransaction();
            LogEntryCollection logEntryCollection = new LogEntryCollection();
            logEntryCollection.setLogCount(this.logsDAO.getLogsCount(resourcePath, action, userName, from, to, recentFirst));
            logEntryCollection.setDataAccessManager(this.dataAccessManager);
            logEntryCollection.setResourcePath(resourcePath);
            logEntryCollection.setAction(action);
            logEntryCollection.setUserName(userName);
            logEntryCollection.setFrom(from);
            logEntryCollection.setTo(to);
            logEntryCollection.setRecentFirst(recentFirst);
            transactionSucceeded = true;
            LogEntryCollection logEntryCollection2 = logEntryCollection;
            return logEntryCollection2;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    public String[] getAvailableAspects() {
        return this.registryContext.getAspectNames(CurrentSession.getCallerTenantId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateAspect(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            if (!processedPath.isCurrentVersion()) {
                String msg = "Failed to associate aspectName to the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
            }
            resourcePath = processedPath.getPath();
            Resource resource = this.get(resourcePath);
            if (resource.getAspects() == null || !resource.getAspects().contains(aspectName)) {
                Aspect aspect = this.getAspect(aspectName);
                if (aspect == null) {
                    throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Couldn't find aspectName '" + aspectName + "'");
                }
                aspect.associate(resource, this);
                resource.addAspect(aspectName);
                this.put(resource.getPath(), resource);
                this.registryContext.getLogWriter().addLog(resource.getPath(), CurrentSession.getUser(), 17, aspectName);
            }
            transactionSucceeded = true;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    private Aspect getAspect(String name) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registryContext.getAspect(name, CurrentSession.getCallerTenantId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            if (!processedPath.isCurrentVersion()) {
                String msg = "Failed to invoke aspect of the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
            }
            resourcePath = processedPath.getPath();
            Resource resource = this.get(resourcePath);
            Aspect aspect = this.getResourceAspect(resource, aspectName);
            context.setOldResource(this.get(resourcePath));
            context.setResource(resource);
            context.setAspect(aspect);
            context.setAction(action);
            this.registryContext.getHandlerManager().invokeAspect(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    aspect.invoke(context, action);
                }
                resource.discard();
                this.registryContext.getHandlerManager("commit").invokeAspect(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").invokeAspect(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action, Map<String, String> parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            if (!processedPath.isCurrentVersion()) {
                String msg = "Failed to invoke aspect of the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
            }
            resourcePath = processedPath.getPath();
            Resource resource = this.get(resourcePath);
            Aspect aspect = this.getResourceAspect(resource, aspectName);
            context.setOldResource(this.get(resourcePath));
            context.setResource(resource);
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                context.setProperty(e.getKey(), e.getValue());
            }
            context.setProperty("parameterNames", Collections.unmodifiableSet(parameters.keySet()));
            context.setAspect(aspect);
            context.setAction(action);
            this.registryContext.getHandlerManager().invokeAspect(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    aspect.invoke(context, action, parameters);
                }
                resource.discard();
                this.registryContext.getHandlerManager("commit").invokeAspect(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").invokeAspect(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Aspect getResourceAspect(Resource resource, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        try {
            this.beginTransaction();
            Aspect aspect = this.getAspect(aspectName);
            if (aspect == null) {
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Aspect '" + aspectName + "' is not registered!");
            }
            List<String> resourceAspects = resource.getAspects();
            if (resourceAspects == null || !resourceAspects.contains(aspectName)) {
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Resource at '" + resource.getPath() + "' not associated with aspect '" + aspectName + "'");
            }
            transactionSucceeded = true;
            Aspect aspect2 = aspect;
            return aspect2;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAspectActions(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            ResourcePath processedPath = new ResourcePath(resourcePath);
            if (!processedPath.isCurrentVersion()) {
                String msg = "Failed to get aspect actions of the resource " + processedPath + ". Given path refers to an archived version of the resource.";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
            }
            resourcePath = processedPath.getPath();
            Resource resource = this.get(resourcePath);
            Aspect aspect = this.getResourceAspect(resource, aspectName);
            context.setResource(resource);
            String[] actions = aspect.getAvailableActions(context);
            transactionSucceeded = true;
            String[] stringArray = actions;
            return stringArray;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    public Collection searchContent(String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLink(String path, String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            Resource resource;
            this.beginTransaction();
            if (path.equals(target)) {
                String msg = "Path and target are same, path = target = " + path + ". You can't create a symbolic link to itself.";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
            }
            Resource oldResource = this.repository.getMetaData(target);
            if (this.repository.resourceExists(path)) {
                resource = this.repository.get(path);
                resource.addProperty("registry.existingresource", "true");
            } else {
                resource = oldResource != null ? (oldResource instanceof Collection ? new CollectionImpl() : new ResourceImpl()) : new CollectionImpl();
            }
            resource.addProperty("registry.nonrecursive", "true");
            resource.addProperty("registry.linkrestoration", path + ";" + target + ";" + CurrentSession.getUser());
            resource.setMediaType("application/vnd.wso2-link");
            try {
                CurrentSession.setAttribute("isLoggingActivity", false);
                this.repository.put(path, resource);
            }
            finally {
                CurrentSession.removeAttribute("isLoggingActivity");
            }
            resource.discard();
            HandlerManager hm = this.registryContext.getHandlerManager();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            context.setTargetPath(target);
            hm.createLink(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    RegistryUtils.registerHandlerForSymbolicLinks(this.registryContext, path, target, CurrentSession.getUser());
                    String author = CurrentSession.getUser();
                    RegistryUtils.addMountEntry(RegistryUtils.getSystemRegistry(this), this.registryContext, path, target, false, author);
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(path, CurrentSession.getUser(), 13, target);
                    }
                }
                this.registryContext.getHandlerManager("commit").createLink(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").createLink(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLink(String path, String target, String targetSubPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            Resource resource;
            this.beginTransaction();
            if (this.repository.resourceExists(path)) {
                resource = this.repository.get(path);
                resource.addProperty("registry.existingresource", "true");
            } else {
                resource = new CollectionImpl();
            }
            resource.addProperty("registry.nonrecursive", "true");
            resource.addProperty("registry.linkrestoration", path + ";" + target + ";" + targetSubPath + ";" + CurrentSession.getUser());
            resource.setMediaType("application/vnd.wso2-link");
            try {
                CurrentSession.setAttribute("isLoggingActivity", false);
                this.repository.put(path, resource);
            }
            finally {
                CurrentSession.removeAttribute("isLoggingActivity");
            }
            resource.discard();
            HandlerManager hm = this.registryContext.getHandlerManager();
            ResourcePath resourcePath = new ResourcePath(path);
            context.setResourcePath(resourcePath);
            context.setTargetPath(target);
            context.setTargetSubPath(targetSubPath);
            hm.createLink(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    RegistryUtils.registerHandlerForRemoteLinks(this.registryContext, path, target, targetSubPath, CurrentSession.getUser());
                    String author = CurrentSession.getUser();
                    RegistryUtils.addMountEntry(RegistryUtils.getSystemRegistry(this), this.registryContext, path, target, targetSubPath, author);
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(path, CurrentSession.getUser(), 12, target + ";" + targetSubPath);
                    }
                }
                this.registryContext.getHandlerManager("commit").createLink(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").createLink(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLink(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        block19: {
            boolean transactionSucceeded = false;
            RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
            try {
                this.beginTransaction();
                ResourcePath resourcePath = new ResourcePath(path);
                context.setResourcePath(resourcePath);
                this.registryContext.getHandlerManager().removeLink(context);
                Handler handlerToRemove = (Handler)context.getProperty("SymlinkToRemovePropertyName");
                if (handlerToRemove != null) {
                    this.registryContext.getHandlerManager().removeHandler(handlerToRemove, "tenant");
                }
                if (context.isSimulation()) break block19;
                if (!context.isProcessingComplete()) {
                    try {
                        Collection mountCollection = (Collection)this.get(RegistryUtils.getAbsolutePath(this.registryContext, "/_system/local/repository/components/org.wso2.carbon.registry/mount"));
                        String[] mountResources = mountCollection.getChildren();
                        Resource resource = null;
                        for (String mountResource : mountResources) {
                            String relativePath;
                            String mountResName = mountResource.substring(mountResource.lastIndexOf(47) + 1);
                            if (!mountResName.equals((relativePath = RegistryUtils.getRelativePath(this.registryContext, path)).replace("/", "-"))) continue;
                            resource = this.get(mountResource);
                            break;
                        }
                        if (resource == null) {
                            String msg = "Couldn't find the mount point to remove. ";
                            log.error((Object)msg);
                            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                        }
                        RegistryUtils.getSystemRegistry(this).delete(resource.getPath());
                    }
                    catch (ResourceNotFoundException ignored) {
                        // empty catch block
                    }
                    if (this.repository.resourceExists(path)) {
                        Resource r = this.repository.get(path);
                        if (!Boolean.toString(true).equals(r.getProperty("registry.existingresource"))) {
                            this.repository.delete(path);
                        }
                    }
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(path, CurrentSession.getUser(), 14, null);
                    }
                }
                this.registryContext.getHandlerManager("commit").removeLink(context);
                transactionSucceeded = true;
            }
            finally {
                if (transactionSucceeded) {
                    this.commitTransaction();
                } else {
                    try {
                        this.registryContext.getHandlerManager("rollback").removeLink(context);
                    }
                    finally {
                        this.rollbackTransaction();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String path, Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        block16: {
            boolean transactionSucceeded = false;
            RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
            try {
                this.beginTransaction();
                context.setDumpingReader(reader);
                context.setResourcePath(new ResourcePath(path));
                this.registryContext.getHandlerManager().restore(context);
                if (context.isSimulation()) break block16;
                if (!context.isProcessingComplete()) {
                    try {
                        CurrentSession.setAttribute("isLoggingActivity", context.isLoggingActivity());
                        this.repository.restore(path, reader);
                    }
                    finally {
                        CurrentSession.removeAttribute("isLoggingActivity");
                    }
                    if (context.isLoggingActivity()) {
                        this.registryContext.getLogWriter().addLog(path, CurrentSession.getUser(), 8, null);
                    }
                }
                this.registryContext.getHandlerManager("commit").restore(context);
                transactionSucceeded = true;
            }
            finally {
                if (transactionSucceeded) {
                    this.commitTransaction();
                } else {
                    try {
                        this.registryContext.getHandlerManager("rollback").restore(context);
                    }
                    finally {
                        this.rollbackTransaction();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("total read: " + DumpReader.getTotalRead()));
                    log.debug((Object)("total buffered: " + DumpReader.getTotalBuffered()));
                    log.debug((Object)("maximum buffer size: " + DumpReader.getMaxBufferedSize()));
                    log.debug((Object)("total buffer read size: " + DumpReader.getTotalBufferedRead()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            context.setResourcePath(new ResourcePath(path));
            context.setDumpingWriter(writer);
            this.registryContext.getHandlerManager().dump(context);
            if (!context.isSimulation()) {
                if (!context.isProcessingComplete()) {
                    this.repository.dump(path, writer);
                }
                this.registryContext.getHandlerManager("commit").dump(context);
                transactionSucceeded = true;
            }
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                try {
                    this.registryContext.getHandlerManager("rollback").dump(context);
                }
                finally {
                    this.rollbackTransaction();
                }
            }
        }
    }

    @Override
    public String getEventingServiceURL(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (path == null || this.eventingServiceURLs.size() == 0) {
            return this.defaultEventingServiceURL;
        }
        Set<Map.Entry<String, String>> entries = this.eventingServiceURLs.entrySet();
        for (Map.Entry<String, String> e : entries) {
            if (e.getValue() == null) {
                this.eventingServiceURLs.remove(e.getKey());
                continue;
            }
            if (!path.matches(e.getKey())) continue;
            return e.getValue();
        }
        return this.defaultEventingServiceURL;
    }

    @Override
    public void setEventingServiceURL(String path, String eventingServiceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (path == null) {
            this.defaultEventingServiceURL = eventingServiceURL;
        } else {
            this.eventingServiceURLs.put(path, eventingServiceURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAspect(String name, Aspect aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            this.registryContext.addAspect(name, aspect, CurrentSession.getCallerTenantId());
            if (!context.isProcessingComplete()) {
                transactionSucceeded = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAspect(String name) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        RequestContext context = new RequestContext(this, this.repository, this.versionRepository);
        try {
            this.beginTransaction();
            this.registryContext.removeAspect(name, CurrentSession.getCallerTenantId());
            if (!context.isProcessingComplete()) {
                transactionSucceeded = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVersionHistory(String path, long snapshotId) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean transactionSucceeded = false;
        try {
            this.beginTransaction();
            this.versionRepository.removeVersionHistory(path, snapshotId);
            transactionSucceeded = true;
        }
        finally {
            if (transactionSucceeded) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
        return false;
    }

    static {
        String property;
        log = LogFactory.getLog(EmbeddedRegistry.class);
        dbQueryLog = DBQueryStatisticsLog.getLog();
        statEnabledOperations = new LinkedList<String>();
        executor = null;
        if (dbQueryLog.isDebugEnabled()) {
            EmbeddedRegistry.initializeStatisticsLogging();
        }
        if ((property = System.getProperty("carbon.registry.statistics.operations")) != null) {
            statEnabledOperations.addAll(Arrays.asList(property.split(",")));
        }
    }
}

