/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class RemoteResourceImpl
extends ResourceImpl {
    private URL contentURL;
    private String authorizationString;

    public void setContentURL(URL contentURL) {
        this.contentURL = contentURL;
    }

    public String getAuthorizationString() {
        return this.authorizationString;
    }

    public void setAuthorizationString(String authorizationString) {
        this.authorizationString = authorizationString;
    }

    @Override
    public InputStream getContentStream() throws RegistryException {
        InputStream is;
        if (this.content != null && (is = super.getContentStream()) != null) {
            return is;
        }
        if (this.contentURL != null) {
            return this.getContentStreamFromURL();
        }
        return null;
    }

    @Override
    public Object getContent() throws RegistryException {
        if (this.content != null) {
            if (this.content instanceof String) {
                return RegistryUtils.encodeString((String)this.content);
            }
            return this.content;
        }
        try {
            int nextChar;
            InputStream is = this.getContentStreamFromURL();
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((nextChar = is.read()) != -1) {
                os.write(nextChar);
            }
            os.flush();
            this.content = os.toByteArray();
            return this.content;
        }
        catch (Exception e) {
            throw new RegistryException("Couldn't get content stream", e);
        }
    }

    private InputStream getContentStreamFromURL() throws RegistryException {
        if (this.contentURL != null) {
            try {
                URLConnection uc = new URL(this.contentURL.toString().replace(" ", "+")).openConnection();
                if (uc instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)uc).setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
                if (this.authorizationString != null) {
                    uc.setRequestProperty("Authorization", this.authorizationString);
                }
                return uc.getInputStream();
            }
            catch (IOException e) {
                throw new RegistryException("Couldn't open stream to source URL " + this.contentURL, e);
            }
        }
        return null;
    }
}

