/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.engine.phases.Sizing;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;
import org.wso2.carbon.feature.mgt.core.ResolutionResult;
import org.wso2.carbon.feature.mgt.core.internal.ServiceHolder;
import org.wso2.carbon.feature.mgt.core.operations.ProfileChangeOperation;
import org.wso2.carbon.feature.mgt.core.util.ProvisioningUtils;
import org.wso2.carbon.feature.mgt.core.util.SizingPhaseSet;

public class RevertOperation
extends ProfileChangeOperation {
    public RevertOperation(String actionType) {
        super(actionType);
    }

    @Override
    public ResolutionResult reviewProfileChangeAction(IProfile profile) throws ProvisioningException {
        IProfile snapshot = ProvisioningUtils.getProfile("_SELF_", this.timestamp);
        if (snapshot == null) {
            throw new ProvisioningException("Invalid Profile Configuration");
        }
        IPlanner planner = ServiceHolder.getPlanner();
        IProvisioningPlan plan = planner.getDiffPlan(profile, snapshot, (IProgressMonitor)new NullProgressMonitor());
        ProfileChangeRequest profileChangeRequest = this.generateProfileChangeRequest(profile, this.getInitialStatus(), null);
        if (plan.getAdditions() != null) {
            IInstallableUnit[] planAdditions = (IInstallableUnit[])plan.getAdditions().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class);
            profileChangeRequest.addInstallableUnits(planAdditions);
        }
        if (plan.getRemovals() != null) {
            IInstallableUnit[] planRemovals = (IInstallableUnit[])plan.getRemovals().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class);
            profileChangeRequest.removeInstallableUnits(planRemovals);
        }
        if (plan == null) {
            throw new ProvisioningException("Failed to generate the Provisioning Plan");
        }
        return this.generateResolutionResult(profileChangeRequest, plan, this.getInitialStatus());
    }

    @Override
    public ProfileChangeRequest generateProfileChangeRequest(IProfile profile, MultiStatus status, IProgressMonitor monitor) {
        return new ProfileChangeRequest(profile);
    }

    @Override
    public long getSize(IProvisioningPlan provisioningPlan, IProfile profile, IEngine engine, ProvisioningContext context, IProgressMonitor monitor) {
        SizingPhaseSet set;
        IStatus status;
        if (provisioningPlan == null) {
            return -3L;
        }
        if (((ProvisioningPlan)provisioningPlan).getOperands().length == 0) {
            return 0L;
        }
        long installPlanSize = 0L;
        if (provisioningPlan.getInstallerPlan() != null && (status = engine.perform(provisioningPlan, (IPhaseSet)(set = new SizingPhaseSet(new Sizing(100))), null)).isOK()) {
            installPlanSize = set.getSizing().getDiskSize();
        }
        if ((status = engine.perform(provisioningPlan, (IPhaseSet)(set = new SizingPhaseSet(new Sizing(100))), null)).isOK()) {
            return installPlanSize + set.getSizing().getDiskSize();
        }
        return -2L;
    }

    @Override
    public MultiStatus getInitialStatus() {
        return new MultiStatus("org.wso2.carbon.feature.mgt.core", 10001, "Your original revert request has been modified.", null);
    }
}

