/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.Base64;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.res.StringManager;

public abstract class WebSocketServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(B2CConverter.ISO_8859_1);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.websocket");
    private Queue<MessageDigest> sha1Helpers = new ConcurrentLinkedQueue<MessageDigest>();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String subProtocol = null;
        List extensions = Collections.emptyList();
        if (!this.headerContainsToken(req, "upgrade", "websocket")) {
            resp.sendError(400);
            return;
        }
        if (!this.headerContainsToken(req, "connection", "upgrade")) {
            resp.sendError(400);
            return;
        }
        if (!this.headerContainsToken(req, "sec-websocket-version", "13")) {
            resp.setStatus(426);
            resp.setHeader("Sec-WebSocket-Version", "13");
            return;
        }
        String key = req.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            resp.sendError(400);
            return;
        }
        String origin = req.getHeader("Origin");
        if (!this.verifyOrigin(origin)) {
            resp.sendError(403);
            return;
        }
        List<String> subProtocols = this.getTokensFromHeader(req, "Sec-WebSocket-Protocol-Client");
        if (!subProtocols.isEmpty()) {
            subProtocol = this.selectSubProtocol(subProtocols);
        }
        resp.setHeader("Upgrade", "websocket");
        resp.setHeader("Connection", "upgrade");
        resp.setHeader("Sec-WebSocket-Accept", this.getWebSocketAccept(key));
        if (subProtocol != null) {
            resp.setHeader("Sec-WebSocket-Protocol", subProtocol);
        }
        if (!extensions.isEmpty()) {
            // empty if block
        }
        StreamInbound inbound = this.createWebSocketInbound(subProtocol);
        HttpServletRequest inner = req;
        while (inner instanceof ServletRequestWrapper) {
            inner = ((ServletRequestWrapper)inner).getRequest();
        }
        if (inner instanceof RequestFacade) {
            ((RequestFacade)inner).doUpgrade(inbound);
        } else {
            resp.sendError(500, sm.getString("servlet.reqUpgradeFail"));
        }
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    private String getWebSocketAccept(String key) throws ServletException {
        MessageDigest sha1Helper = this.sha1Helpers.poll();
        if (sha1Helper == null) {
            try {
                sha1Helper = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
        }
        sha1Helper.reset();
        sha1Helper.update(key.getBytes(B2CConverter.ISO_8859_1));
        String result = Base64.encode(sha1Helper.digest(WS_ACCEPT));
        this.sha1Helpers.add(sha1Helper);
        return result;
    }

    protected boolean verifyOrigin(String origin) {
        return true;
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        return null;
    }

    protected abstract StreamInbound createWebSocketInbound(String var1);
}

