/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.core.services.authentication.AbstractAuthenticator;
import org.wso2.carbon.core.services.authentication.AuthenticationFailureException;
import org.wso2.carbon.core.services.authentication.AuthenticationUtil;
import org.wso2.carbon.core.services.authentication.BasicAccessAuthenticator;
import org.wso2.carbon.core.services.internal.CarbonServicesServiceComponent;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CookieAuthenticator
extends AbstractAuthenticator {
    private static final String AUTHENTICATOR_NAME = "CookieAuthenticator";
    private static final Log log = LogFactory.getLog(BasicAccessAuthenticator.class);

    @Override
    protected String getUserNameFromRequest(MessageContext msgContext) {
        String cookieData = this.getCookieData(msgContext);
        int index = cookieData.indexOf(45);
        return cookieData.substring(0, index);
    }

    protected String getCookieData(MessageContext msgContext) {
        return AuthenticationUtil.getHeader("RememberMeCookieData", msgContext);
    }

    @Override
    protected void doAuthentication(String userNameInRequest, int tenantId, MessageContext msgContext) throws AuthenticationFailureException {
        block7: {
            UserRealm realm;
            String userName = MultitenantUtils.getTenantAwareUsername((String)userNameInRequest);
            String cookieData = this.getCookieData(msgContext);
            int index = cookieData.indexOf(45);
            String uuid = cookieData.substring(index + 1);
            try {
                realm = this.getRealmService().getTenantUserRealm(tenantId);
            }
            catch (Exception e) {
                log.error((Object)("Error retrieving user realm for authentication. Tenant id " + tenantId + " user name " + userNameInRequest), (Throwable)e);
                throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
            }
            if (realm != null) {
                try {
                    boolean isAuthenticated = realm.getUserStoreManager().isValidRememberMeToken(userName, uuid);
                    if (!isAuthenticated) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed authentication for user " + userNameInRequest));
                        }
                        throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.INVALID_PASSWORD, userNameInRequest);
                    }
                    break block7;
                }
                catch (UserStoreException e) {
                    log.error((Object)("Error retrieving user store manager for authentication. Tenant id " + tenantId + " user name " + userNameInRequest), (Throwable)e);
                    throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
                }
            }
            log.error((Object)("Error retrieving user realm for authentication. Tenant id " + tenantId + " user name " + userNameInRequest));
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
        }
    }

    @Override
    protected RealmService getRealmService() throws Exception {
        return CarbonServicesServiceComponent.getRealmService();
    }

    @Override
    protected BundleContext getBundleContext() throws Exception {
        return CarbonServicesServiceComponent.getBundleContext();
    }

    @Override
    public boolean canHandle(MessageContext msgContext) {
        String cookieData = this.getCookieData(msgContext);
        return cookieData != null;
    }

    @Override
    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public int getPriority() {
        int configuredPriority = super.getPriority();
        if (configuredPriority == -1) {
            return 5;
        }
        return configuredPriority;
    }
}

