/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;

public class AuthenticationUtil {
    public static final String HEADER_X_ORIGINATING_IP_FORM_1 = "X-Originating-IP";
    public static final String HEADER_X_ORIGINATING_IP_FORM_2 = "X-IP";
    public static final String HEADER_X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String IP_ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final Log log = LogFactory.getLog(AuthenticationUtil.class);

    public static String getOriginatingIPAddress(MessageContext msgCtx) {
        String originatingIP = AuthenticationUtil.getHeader(HEADER_X_ORIGINATING_IP_FORM_1, msgCtx);
        if (originatingIP == null) {
            originatingIP = AuthenticationUtil.getHeader(HEADER_X_ORIGINATING_IP_FORM_2, msgCtx);
        }
        return originatingIP;
    }

    public static String[] getForwardingAddresses(MessageContext msgCtx) {
        String forwardingAddresses = AuthenticationUtil.getHeader(HEADER_X_FORWARDED_FOR, msgCtx);
        if (forwardingAddresses != null) {
            return forwardingAddresses.split(",");
        }
        return new String[0];
    }

    private static void printForwardingAddresses(String[] forwardingAddresses) throws AuthenticationException {
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("The request passed following hops - ");
            for (String address : forwardingAddresses) {
                AuthenticationUtil.validateRemoteAddress(address);
                stringBuilder.append(address);
                stringBuilder.append(",");
            }
            log.debug((Object)stringBuilder.toString());
        }
    }

    public static String getRemoteAddress(MessageContext msgCtx) throws AuthenticationException {
        String[] forwardingAddresses;
        if (msgCtx == null) {
            return null;
        }
        String remoteAddress = AuthenticationUtil.getOriginatingIPAddress(msgCtx);
        if (remoteAddress == null && (forwardingAddresses = AuthenticationUtil.getForwardingAddresses(msgCtx)).length > 0) {
            remoteAddress = forwardingAddresses[0].trim();
            AuthenticationUtil.printForwardingAddresses(forwardingAddresses);
        }
        if (remoteAddress == null) {
            remoteAddress = (String)msgCtx.getProperty("REMOTE_ADDR");
        }
        AuthenticationUtil.validateRemoteAddress(remoteAddress);
        return remoteAddress;
    }

    public static void validateRemoteAddress(String address) throws AuthenticationException {
        if (address == null || address.isEmpty()) {
            return;
        }
        address = address.replaceAll("\\s+", "");
        if (!AuthenticationUtil.isValidIPAddress(address = address.trim()) && !AuthenticationUtil.isValidDNSAddress(address)) {
            throw new AuthenticationException("Authentication Failed : Invalid remote address passed - " + address);
        }
    }

    private static boolean isValidDNSAddress(String address) {
        try {
            InetAddress ipAddress = InetAddress.getByName(address);
            return AuthenticationUtil.isValidIPAddress(ipAddress.getHostAddress());
        }
        catch (UnknownHostException e) {
            log.warn((Object)("Could not find IP address for domain name : " + address));
            return false;
        }
    }

    private static boolean isValidIPAddress(String ipAddress) {
        Pattern pattern = Pattern.compile(IP_ADDRESS_PATTERN);
        Matcher matcher = pattern.matcher(ipAddress);
        return matcher.matches();
    }

    public static String getHeader(String headerName, MessageContext messageContext) {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request != null) {
            String tmp = request.getHeader(headerName);
            if (tmp == null) {
                tmp = request.getHeader(headerName.toLowerCase());
            }
            return tmp;
        }
        Map map = (Map)messageContext.getProperty("TRANSPORT_HEADERS");
        if (map != null) {
            String tmp = (String)map.get(headerName);
            if (tmp == null) {
                tmp = (String)map.get(headerName.toLowerCase());
            }
            return tmp;
        }
        return null;
    }
}

