/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.transport;

import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.SessionContextUtil;

public abstract class AbstractTransportListener
implements TransportListener,
ManagementSupport {
    private static final Log log = LogFactory.getLog(AbstractTransportListener.class);
    private static final String TRANSPORT_MANAGER = "org.wso2.carbon.tomcat.ext.transport.ServletTransportManager";
    private Class transportManagerClass;
    private Object transportManager;
    private String transport;
    protected ConfigurationContext configurationContext;
    protected int port = -1;
    protected int proxyPort = -1;
    private boolean isStopped;
    private MetricsCollector metrics = new MetricsCollector();

    public void init(ConfigurationContext configContext, TransportInDescription transportIn) throws AxisFault {
        block10: {
            String portSysProp;
            this.configurationContext = configContext;
            this.transport = transportIn.getName();
            if (CarbonUtils.isRunningInStandaloneMode()) {
                try {
                    this.transportManagerClass = Class.forName(TRANSPORT_MANAGER);
                    this.transportManager = this.transportManagerClass.newInstance();
                    Method method = this.transportManagerClass.getMethod("getPort", String.class);
                    this.port = (Integer)method.invoke(this.transportManager, this.transport);
                    transportIn.addParameter(this.getParameter("port", String.valueOf(this.port)));
                }
                catch (Exception e) {
                    String msg = "Cannot get transport port";
                    log.error((Object)msg, (Throwable)e);
                    throw new AxisFault(msg, (Throwable)e);
                }
            }
            if ((portSysProp = System.getProperty(this.transport + "Port")) != null) {
                try {
                    this.port = Integer.parseInt(portSysProp);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using " + this.transport + " port " + this.port + " defined in System property " + this.transport + "Port"));
                    }
                }
                catch (NumberFormatException ignored) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug((Object)ignored);
                }
            }
        }
        if (CarbonUtils.isRunningInStandaloneMode()) {
            this.transport = transportIn.getName();
        } else {
            Parameter proxyPortParam = transportIn.getParameter("proxyPort");
            if (proxyPortParam != null) {
                this.proxyPort = Integer.parseInt(proxyPortParam.getValue().toString().trim());
            }
        }
    }

    public synchronized void start() throws AxisFault {
        if (CarbonUtils.isRunningInStandaloneMode() && this.isStopped) {
            try {
                Class<?> transportManagerClass = Class.forName(TRANSPORT_MANAGER);
                Object transportManager = transportManagerClass.newInstance();
                Class[] parametertype = new Class[]{String.class};
                Method method = transportManagerClass.getMethod("startTransport", parametertype);
                method.invoke(transportManager, (Object[])new String[]{this.transport});
            }
            catch (Exception e) {
                String msg = "Cannot start " + this.transport + " transport";
                log.fatal((Object)msg, (Throwable)e);
                return;
            }
        }
        this.isStopped = false;
    }

    public synchronized void stop() throws AxisFault {
        if (CarbonUtils.isRunningInStandaloneMode() && this.transportManagerClass != null) {
            try {
                Method method = this.transportManagerClass.getMethod("stopTransport", String.class);
                method.invoke(this.transportManager, this.transport);
            }
            catch (Exception e) {
                String msg = "Cannot get stop transport";
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        this.isStopped = true;
    }

    public EndpointReference getEPR(String protocol, String serviceName, String ip) throws AxisFault {
        if (this.configurationContext == null) {
            return null;
        }
        String serviceContextPath = this.configurationContext.getServiceContextPath();
        if (serviceContextPath == null) {
            throw new AxisFault("couldn't find service path");
        }
        return this.genEpr(protocol, ip, serviceContextPath, serviceName);
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return SessionContextUtil.createSessionContext(messageContext);
    }

    public void destroy() {
        this.configurationContext = null;
    }

    protected EndpointReference genEpr(String protocol, String ip, String serviceContextPath, String serviceName) throws AxisFault {
        try {
            if (ip == null) {
                ip = NetworkUtils.getLocalHostname();
            }
            String tmp = protocol + "://" + ip;
            tmp = this.proxyPort == 80 || this.proxyPort == 443 ? tmp + serviceContextPath + "/" + serviceName : (this.proxyPort != -1 ? tmp + ":" + this.proxyPort + serviceContextPath + "/" + serviceName : tmp + ":" + this.port + serviceContextPath + "/" + serviceName);
            return new EndpointReference(tmp + "/");
        }
        catch (SocketException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private Parameter getParameter(String name, String value) {
        Parameter p = new Parameter(name, (Object)value);
        p.setParameterType(1);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement paramElement = fac.createOMElement(new QName("parameter"));
        paramElement.addAttribute("name", name, null);
        paramElement.setText(value);
        p.setParameterElement(paramElement);
        return p;
    }

    public void pause() throws AxisFault {
    }

    public void resume() throws AxisFault {
    }

    public void maintenenceShutdown(long l) throws AxisFault {
    }

    public int getActiveThreadCount() {
        return 0;
    }

    public int getQueueSize() {
        return 0;
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }
}

