/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core.rolesofuser;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.BaseCache;
import org.wso2.carbon.caching.core.rolesofuser.UserRolesCacheEntry;
import org.wso2.carbon.caching.core.rolesofuser.UserRolesCacheKey;

public class UserRolesCache
extends BaseCache {
    private static Log log = LogFactory.getLog(UserRolesCache.class);
    private static UserRolesCache userRolesCache = null;
    private static final String USER_ROLES_CACHE = "USER_ROLES_CACHE";

    private UserRolesCache(String cacheName) {
        super(cacheName);
    }

    public static synchronized UserRolesCache getUserRolesCacheInstance() {
        if (userRolesCache == null) {
            userRolesCache = new UserRolesCache(USER_ROLES_CACHE);
        }
        return userRolesCache;
    }

    private boolean isCacheNull() {
        if (this.cache == null) {
            if (log.isDebugEnabled()) {
                StackTraceElement[] elemets = Thread.currentThread().getStackTrace();
                String traceString = "";
                for (int i = 1; i < elemets.length; ++i) {
                    traceString = traceString + elemets[i] + System.getProperty("line.separator");
                }
                log.debug((Object)("USER_ROLES_CAHCHE doesn't exist in CacheManager:\n" + traceString));
            }
            return true;
        }
        return false;
    }

    public void addToCache(int tenantId, String userName, String[] userRoleList) {
        if (this.isCacheNull()) {
            return;
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(tenantId, userName);
        UserRolesCacheEntry userRolesCacheEntry = new UserRolesCacheEntry(userRoleList);
        super.addToCache(userRolesCacheKey, userRolesCacheEntry);
    }

    public String[] getRolesListOfUser(int tenantId, String userName) {
        if (this.isCacheNull()) {
            return new String[0];
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(tenantId, userName);
        UserRolesCacheEntry userRolesCacheEntry = (UserRolesCacheEntry)super.getValueFromCache(userRolesCacheKey);
        String[] roleList = userRolesCacheEntry.getUserRolesList();
        return roleList;
    }

    public void clearCacheByTenant(int tenantId) {
        if (this.isCacheNull()) {
            return;
        }
        Set objectSet = this.cache.keySet();
        for (Object object : objectSet) {
            UserRolesCacheKey userRolesCacheKey = (UserRolesCacheKey)object;
            if (tenantId != userRolesCacheKey.getTenantId()) continue;
            this.cache.remove((Object)userRolesCacheKey);
        }
    }

    public void clearCacheEntry(int tenantId, String userName) {
        if (this.isCacheNull()) {
            return;
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(tenantId, userName);
        if (this.cache.containsKey((Object)userRolesCacheKey)) {
            this.cache.remove((Object)userRolesCacheKey);
        }
    }
}

