/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core.authorization;

import java.io.Serializable;

public class AuthorizationKey
implements Serializable {
    private static final long serialVersionUID = 926710669453381695L;
    private String userName;
    private String resourceId;
    private String action;
    private int tenantId;

    public AuthorizationKey(int tenantId, String userName, String resourceId, String action) {
        this.userName = userName;
        this.resourceId = resourceId;
        this.action = action;
        this.tenantId = tenantId;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof AuthorizationKey)) {
            return false;
        }
        AuthorizationKey secondObject = (AuthorizationKey)otherObject;
        return this.checkAttributesAreEqual(this.tenantId, this.userName, this.resourceId, this.action, secondObject);
    }

    public int hashCode() {
        return this.getHashCodeForAttributes(this.tenantId, this.userName, this.resourceId, this.action);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getAction() {
        return this.action;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    private int getHashCodeForAttributes(int tenantId, String userName, String resourceId, String action) {
        if (tenantId != -1 && userName != null) {
            if (tenantId == -1234) {
                tenantId = 0;
            }
            return tenantId + userName.hashCode() * 5 + resourceId.hashCode() * 7 + action.hashCode() * 11;
        }
        return resourceId.hashCode() * 7 + action.hashCode() * 11;
    }

    private boolean checkAttributesAreEqual(int tenantId, String userName, String resourceIdentifier, String actionName, AuthorizationKey authorizationKey) {
        return tenantId == authorizationKey.getTenantId() && userName.equals(authorizationKey.getUserName()) && resourceIdentifier.equals(authorizationKey.getResourceId()) && actionName.equals(authorizationKey.getAction());
    }
}

