/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.sync.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.utils.CoordinationUtils;

public abstract class ZKSyncPrimitive
implements Watcher {
    private static final Log log = LogFactory.getLog(ZKSyncPrimitive.class);
    private ZooKeeper zooKeeper;
    private String id;
    private String rootPath;
    private BlockingQueue<WatchedEvent> eventQueue;
    private int waitTimeout;

    public ZKSyncPrimitive(ZooKeeper zooKeeper, String baseName, String id, int waitTimeout) throws CoordinationException {
        this.zooKeeper = zooKeeper;
        this.rootPath = CoordinationUtils.createPathFromId(baseName, id);
        this.eventQueue = new LinkedBlockingQueue<WatchedEvent>();
        this.waitTimeout = waitTimeout;
        this.createRecursive(this.getRootPath());
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    private boolean createNode(String path) throws CoordinationException {
        try {
            this.getZooKeeper().create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            return true;
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NODEEXISTS) {
                return true;
            }
            if (e.code() == KeeperException.Code.NONODE) {
                return false;
            }
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    protected void createRecursive(String path) throws CoordinationException {
        ZKPath zkpath = new ZKPath(path);
        int steps = 0;
        while (!this.createNode(zkpath.getSubPath(steps))) {
            ++steps;
        }
        while (steps > 0) {
            this.createNode(zkpath.getSubPath(--steps));
        }
    }

    protected ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    protected void releaseResources() {
        block3: {
            try {
                this.getZooKeeper().delete(this.getRootPath(), -1);
            }
            catch (InterruptedException e) {
                log.error((Object)"Interrupted in releasing resources", (Throwable)e);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) break block3;
                log.error((Object)"Error in releasing resources", (Throwable)e);
            }
        }
    }

    public BlockingQueue<WatchedEvent> getEventQueue() {
        return this.eventQueue;
    }

    public WatchedEvent takeQueuedEvent() throws CoordinationException {
        try {
            int timeout = this.getWaitTimeout();
            if (timeout == -1) {
                return this.getEventQueue().take();
            }
            WatchedEvent event = this.getEventQueue().poll(timeout, TimeUnit.MILLISECONDS);
            if (event == null) {
                throw new CoordinationException(CoordinationException.ExceptionCode.WAIT_TIMEOUT);
            }
            return event;
        }
        catch (InterruptedException e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void process(WatchedEvent event) {
        this.getEventQueue().add(event);
    }

    private class ZKPath {
        private String value;
        private List<Integer> indices;

        public ZKPath(String value) {
            this.value = value;
            this.indices = new ArrayList<Integer>();
            this.indices.add(this.value.length());
            for (int i = value.length() - 1; i > 0; --i) {
                if (this.value.charAt(i) != '/') continue;
                this.indices.add(i);
            }
        }

        public String getValue() {
            return this.value;
        }

        public List<Integer> getIndices() {
            return this.indices;
        }

        public String getSubPath(int steps) throws CoordinationException {
            List<Integer> indices = this.getIndices();
            if (steps > indices.size() - 1) {
                throw new CoordinationException("A subpath cannot be created from the path: '" + this.getValue() + "' by going back " + steps + " steps.");
            }
            return this.getValue().substring(0, indices.get(steps));
        }
    }
}

