/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.sync.impl;

import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.sync.Lock;
import org.wso2.carbon.coordination.core.sync.impl.ZKSyncPrimitive;

public class ZKLock
extends ZKSyncPrimitive
implements Lock {
    private String createdPath;

    public ZKLock(ZooKeeper zooKeeper, String lockId, int waitTimeout) throws CoordinationException {
        super(zooKeeper, ZKLock.class.getCanonicalName(), lockId, waitTimeout);
    }

    public String getCreatedPath() {
        return this.createdPath;
    }

    private void setCreatedPath(String createdPath) {
        this.createdPath = createdPath;
    }

    private String getPathBeforeMine(List<String> ids, String myId) {
        String currentId = ids.get(0);
        for (int i = 1; i < ids.size(); ++i) {
            if (!ids.get(i).equals(myId)) continue;
            return this.getRootPath() + "/" + currentId;
        }
        return null;
    }

    @Override
    public void acquire() throws CoordinationException {
        try {
            String myPath = this.getZooKeeper().create(this.getRootPath() + "/node", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            this.setCreatedPath(myPath);
            String myId = this.getCreatedPath().substring(this.getCreatedPath().lastIndexOf("/") + 1);
            while (true) {
                List ids = this.getZooKeeper().getChildren(this.getRootPath(), false);
                Collections.sort(ids);
                if (myId.equals(ids.get(0))) {
                    return;
                }
                String predNodePath = this.getPathBeforeMine(ids, myId);
                if (this.getZooKeeper().exists(predNodePath, (Watcher)this) == null) continue;
                do {
                    this.takeQueuedEvent();
                } while (this.getZooKeeper().exists(predNodePath, (Watcher)this) != null);
            }
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public void release() throws CoordinationException {
        if (this.getCreatedPath() == null) {
            throw new CoordinationException("Lock#acquire() has to be called first before Lock#release()", CoordinationException.ExceptionCode.GENERIC_ERROR);
        }
        try {
            this.getZooKeeper().delete(this.getCreatedPath(), -1);
        }
        catch (KeeperException e) {
            if (e.code() != KeeperException.Code.NONODE) {
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
        finally {
            this.setCreatedPath(null);
        }
    }
}

