/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.sync.impl;

import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.sync.IntegerCounter;
import org.wso2.carbon.coordination.core.sync.impl.ZKSyncPrimitive;

public class ZKIntegerCounter
extends ZKSyncPrimitive
implements IntegerCounter {
    public ZKIntegerCounter(ZooKeeper zooKeeper, String counterId) throws CoordinationException {
        super(zooKeeper, ZKIntegerCounter.class.getCanonicalName(), counterId, -1);
    }

    @Override
    public int incrementAndGet() throws CoordinationException {
        try {
            Stat stat = this.getZooKeeper().setData(this.getRootPath(), new byte[0], -1);
            return stat.getVersion();
        }
        catch (Exception e) {
            throw new CoordinationException("Error in getting a new integer counter value: " + e.getMessage(), CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public void delete() throws CoordinationException {
        try {
            this.getZooKeeper().delete(this.getRootPath(), -1);
        }
        catch (Exception e) {
            throw new CoordinationException("Error in deleting the counter: " + e.getMessage(), CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }
}

