/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.services.impl;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.CoordinationConfiguration;
import org.wso2.carbon.coordination.core.services.CoordinationService;
import org.wso2.carbon.coordination.core.sync.Barrier;
import org.wso2.carbon.coordination.core.sync.Group;
import org.wso2.carbon.coordination.core.sync.IntegerCounter;
import org.wso2.carbon.coordination.core.sync.Lock;
import org.wso2.carbon.coordination.core.sync.Queue;
import org.wso2.carbon.coordination.core.sync.impl.ZKBarrier;
import org.wso2.carbon.coordination.core.sync.impl.ZKGroup;
import org.wso2.carbon.coordination.core.sync.impl.ZKIntegerCounter;
import org.wso2.carbon.coordination.core.sync.impl.ZKLock;
import org.wso2.carbon.coordination.core.sync.impl.ZKQueue;
import org.wso2.carbon.coordination.core.utils.CoordinationUtils;

public class ZKCoordinationService
implements CoordinationService,
Watcher {
    public static final int MAX_ZK_MESSAGE_SIZE = 819200;
    public static final int MAX_SCHEDULER_THREADS = 10;
    public static final int ZNODE_CLEANUP_DELAY = 120000;
    public static final int ZNODE_CLEANUP_TASK_INTERVAL = 30000;
    private static final Log log = LogFactory.getLog(ZKCoordinationService.class);
    private ZooKeeper zooKeeper;
    private boolean enabled;
    private boolean closed = false;
    private static ScheduledExecutorService scheduler;
    private static List<ZNodeDeletionEntry> znodeTimerDeletionList;
    private static List<String> znodeOnCloseDeletionList;

    public ZKCoordinationService(CoordinationConfiguration conf) throws CoordinationException {
        this.enabled = conf.isEnabled();
        if (this.isEnabled()) {
            try {
                this.zooKeeper = new ZooKeeper(conf.getConnectionString(), conf.getSessionTimeout(), (Watcher)this);
                if (znodeOnCloseDeletionList == null) {
                    znodeOnCloseDeletionList = new Vector<String>();
                }
                if (scheduler == null || scheduler.isShutdown()) {
                    znodeTimerDeletionList = new Vector<ZNodeDeletionEntry>();
                    scheduler = Executors.newScheduledThreadPool(10);
                    scheduler.scheduleWithFixedDelay(new ZNodeDeletionTask(), 30000L, 30000L, TimeUnit.MILLISECONDS);
                }
                log.info((Object)"Coordination service connection established with ZooKeeper.");
            }
            catch (IOException e) {
                new CoordinationException(CoordinationException.ExceptionCode.IO_ERROR, (Exception)e);
            }
        } else {
            log.info((Object)"Coordination service disabled.");
        }
    }

    public ZKCoordinationService(String configurationFilePath) throws CoordinationException {
        this(CoordinationUtils.loadCoordinationClientConfig(configurationFilePath));
    }

    public static List<ZNodeDeletionEntry> getZNodeTimerDeletionList() {
        return znodeTimerDeletionList;
    }

    public static List<String> getZNodeOnCloseDeletionList() {
        return znodeOnCloseDeletionList;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void checkService() throws CoordinationException {
        if (!this.isEnabled()) {
            throw new CoordinationException(CoordinationException.ExceptionCode.COORDINATION_SERVICE_NOT_ENABLED);
        }
    }

    @Override
    public Barrier createBarrier(String id, int count, int waitTimeout) throws CoordinationException {
        this.checkService();
        return new ZKBarrier(this.getZooKeeper(), id, count, waitTimeout);
    }

    @Override
    public Group createGroup(String id) throws CoordinationException {
        this.checkService();
        if ("__COMM__/GROUP_COMMUNICATION".equals(id)) {
            throw new CoordinationException("'__COMM__/GROUP_COMMUNICATION' cannot be used a group id, since it is reserved.", CoordinationException.ExceptionCode.GENERIC_ERROR);
        }
        return new ZKGroup(this.getZooKeeper(), id);
    }

    @Override
    public Queue createQueue(String id, int waitTimeout) throws CoordinationException {
        this.checkService();
        return new ZKQueue(this.getZooKeeper(), id, waitTimeout);
    }

    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws CoordinationException {
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.isEnabled()) {
                this.cleanupOnCloseZNodes();
                this.getZooKeeper().close();
            }
            this.closed = true;
        }
        catch (InterruptedException e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)e);
        }
    }

    private void cleanupOnCloseZNodes() {
        for (String path : ZKCoordinationService.getZNodeOnCloseDeletionList()) {
            this.deleteZNode(path);
        }
    }

    @Override
    public Lock createLock(String id, int waitTimeout) throws CoordinationException {
        this.checkService();
        return new ZKLock(this.getZooKeeper(), id, waitTimeout);
    }

    public static void scheduleOnCloseZNodeDeletion(String path) {
        ZKCoordinationService.getZNodeOnCloseDeletionList().add(path);
    }

    public static void scheduleTimedZNodeDeletion(String path) {
        ZKCoordinationService.getZNodeTimerDeletionList().add(new ZNodeDeletionEntry(path, System.currentTimeMillis()));
    }

    private void deleteZNode(String path) {
        try {
            this.getZooKeeper().delete(path, -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void process(WatchedEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("At ZKCoordinationService#process: " + event.toString()));
        }
    }

    @Override
    public IntegerCounter createIntegerCounter(String id) throws CoordinationException {
        this.checkService();
        return new ZKIntegerCounter(this.getZooKeeper(), id);
    }

    private class ZNodeDeletionTask
    implements Runnable {
        private ZNodeDeletionTask() {
        }

        @Override
        public void run() {
            for (ZNodeDeletionEntry entry : ZKCoordinationService.getZNodeTimerDeletionList()) {
                if (!this.readyToDelete(entry)) continue;
                ZKCoordinationService.this.deleteZNode(entry.getPath());
            }
        }

        private boolean readyToDelete(ZNodeDeletionEntry entry) {
            return System.currentTimeMillis() - entry.getCreatedTime() > 120000L;
        }
    }

    private static class ZNodeDeletionEntry {
        private long createdTime;
        private String path;

        public ZNodeDeletionEntry(String path, long createdTime) {
            this.path = path;
            this.createdTime = createdTime;
        }

        public long getCreatedTime() {
            return this.createdTime;
        }

        public String getPath() {
            return this.path;
        }
    }
}

