/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.coordination.common.CoordinationException;

public class CoordinationConfiguration {
    private List<Server> servers;
    private int sessionTimeout;
    private boolean enabled;

    public CoordinationConfiguration(String filePath) throws CoordinationException {
        this.initConfig(filePath);
    }

    private void initConfig(String filePath) throws CoordinationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            NodeList tmpList;
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Element docEl = dBuilder.parse(filePath).getDocumentElement();
            if (!docEl.getNodeName().equals("CoordinationClientConfiguration")) {
                throw new CoordinationException("The root element of the coordination client configuration must be 'CoordinationClientConfiguration'", CoordinationException.ExceptionCode.CONFIGURATION_ERROR);
            }
            String enabledAttr = docEl.getAttribute("enabled");
            this.enabled = true;
            if (enabledAttr != null && enabledAttr.length() > 0) {
                this.enabled = Boolean.parseBoolean(enabledAttr);
            }
            if ((tmpList = docEl.getElementsByTagName("SessionTimeout")).getLength() > 0) {
                try {
                    this.sessionTimeout = Integer.parseInt(((Element)tmpList.item(0)).getTextContent());
                }
                catch (NumberFormatException e) {
                    throw new CoordinationException("Invalid session timeout value", CoordinationException.ExceptionCode.CONFIGURATION_ERROR, (Exception)e);
                }
            }
            if ((tmpList = docEl.getElementsByTagName("Servers")).getLength() == 0) {
                throw new CoordinationException("Servers section is missing in the configuration", CoordinationException.ExceptionCode.CONFIGURATION_ERROR);
            }
            Element serversEl = (Element)tmpList.item(0);
            if ((tmpList = serversEl.getElementsByTagName("Server")).getLength() == 0) {
                throw new CoordinationException("There must be atleast one server entry in the configuration", CoordinationException.ExceptionCode.CONFIGURATION_ERROR);
            }
            this.servers = new ArrayList<Server>();
            int nservers = tmpList.getLength();
            for (int i = 0; i < nservers; ++i) {
                this.servers.add(this.parseServerConfig((Element)tmpList.item(i)));
            }
        }
        catch (Exception e) {
            if (e instanceof CoordinationException) {
                throw (CoordinationException)e;
            }
            throw new CoordinationException(CoordinationException.ExceptionCode.CONFIGURATION_ERROR, e);
        }
    }

    private Server parseServerConfig(Element serverEl) throws CoordinationException {
        String host = serverEl.getAttribute("host");
        if (host == null || host.length() == 0) {
            throw new CoordinationException("Host attribute must be there in a server element", CoordinationException.ExceptionCode.CONFIGURATION_ERROR);
        }
        int port = -1;
        String portStr = serverEl.getAttribute("port");
        if (portStr != null && portStr.length() > 0) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new CoordinationException("Invalid server port value", CoordinationException.ExceptionCode.CONFIGURATION_ERROR, (Exception)e);
            }
            if (port <= 0) {
                throw new CoordinationException("The server port must be a positive integer", CoordinationException.ExceptionCode.CONFIGURATION_ERROR);
            }
        }
        return new Server(host, port);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Server> listServers() {
        return this.servers;
    }

    public String getConnectionString() {
        StringBuilder builder = new StringBuilder();
        List<Server> servers = this.listServers();
        for (int i = 0; i < servers.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            Server tmpServer = servers.get(i);
            int tmpPort = tmpServer.getPort();
            builder.append(tmpServer.getHost());
            if (tmpPort <= 0) continue;
            builder.append(":" + tmpPort);
        }
        return builder.toString();
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public class Server {
        private String host;
        private int port;

        public Server(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

