/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.pool;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.XAConnection;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DisposableConnectionFacade;
import org.apache.tomcat.jdbc.pool.FairBlockingQueue;
import org.apache.tomcat.jdbc.pool.JdbcInterceptor;
import org.apache.tomcat.jdbc.pool.MultiLockFairBlockingQueue;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolExhaustedException;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import org.apache.tomcat.jdbc.pool.ProxyConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    public static final String POOL_JMX_TYPE_PREFIX = "tomcat.jdbc:type=";
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    private AtomicInteger size = new AtomicInteger(0);
    private PoolConfiguration poolProperties;
    private BlockingQueue<PooledConnection> busy;
    private BlockingQueue<PooledConnection> idle;
    private volatile PoolCleaner poolCleaner;
    private volatile boolean closed = false;
    private Constructor<?> proxyClassConstructor;
    private ThreadPoolExecutor cancellator = new ThreadPoolExecutor(0, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    protected org.apache.tomcat.jdbc.pool.jmx.ConnectionPool jmxPool = null;
    private AtomicInteger waitcount = new AtomicInteger(0);
    private AtomicLong poolVersion = new AtomicLong(Long.MIN_VALUE);
    private static volatile Timer poolCleanTimer = null;
    private static HashSet<PoolCleaner> cleaners = new HashSet();

    public ConnectionPool(PoolConfiguration prop) throws SQLException {
        this.init(prop);
    }

    public Future<Connection> getConnectionAsync() throws SQLException {
        Future<PooledConnection> pcf;
        block5: {
            try {
                PooledConnection pc = this.borrowConnection(0, null, null);
                if (pc != null) {
                    return new ConnectionFuture(pc);
                }
            }
            catch (SQLException x) {
                if (x.getMessage().indexOf("NoWait") >= 0) break block5;
                throw x;
            }
        }
        if (this.idle instanceof FairBlockingQueue) {
            pcf = ((FairBlockingQueue)this.idle).pollAsync();
            return new ConnectionFuture(pcf);
        }
        if (this.idle instanceof MultiLockFairBlockingQueue) {
            pcf = ((MultiLockFairBlockingQueue)this.idle).pollAsync();
            return new ConnectionFuture(pcf);
        }
        throw new SQLException("Connection pool is misconfigured, doesn't support async retrieval. Set the 'fair' property to 'true'");
    }

    public Connection getConnection() throws SQLException {
        PooledConnection con = this.borrowConnection(-1, null, null);
        return this.setupConnection(con);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        PooledConnection con = this.borrowConnection(-1, username, password);
        return this.setupConnection(con);
    }

    public String getName() {
        return this.getPoolProperties().getPoolName();
    }

    public int getWaitCount() {
        return this.waitcount.get();
    }

    public PoolConfiguration getPoolProperties() {
        return this.poolProperties;
    }

    public int getSize() {
        return this.size.get();
    }

    public int getActive() {
        return this.busy.size();
    }

    public int getIdle() {
        return this.idle.size();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected Connection setupConnection(PooledConnection con) throws SQLException {
        JdbcInterceptor handler = con.getHandler();
        if (handler == null) {
            handler = new ProxyConnection(this, con, this.getPoolProperties().isUseEquals());
            PoolProperties.InterceptorDefinition[] proxies = this.getPoolProperties().getJdbcInterceptorsAsArray();
            for (int i = proxies.length - 1; i >= 0; --i) {
                try {
                    JdbcInterceptor interceptor = proxies[i].getInterceptorClass().newInstance();
                    interceptor.setProperties(proxies[i].getProperties());
                    interceptor.setNext(handler);
                    interceptor.reset(this, con);
                    handler = interceptor;
                    continue;
                }
                catch (Exception x) {
                    SQLException sx = new SQLException("Unable to instantiate interceptor chain.");
                    sx.initCause(x);
                    throw sx;
                }
            }
            con.setHandler(handler);
        } else {
            for (JdbcInterceptor next = handler; next != null; next = next.getNext()) {
                next.reset(this, con);
            }
        }
        try {
            this.getProxyConstructor(con.getXAConnection() != null);
            Connection connection = null;
            connection = this.getPoolProperties().getUseDisposableConnectionFacade() ? (Connection)this.proxyClassConstructor.newInstance(new DisposableConnectionFacade(handler)) : (Connection)this.proxyClassConstructor.newInstance(handler);
            return connection;
        }
        catch (Exception x) {
            SQLException s = new SQLException();
            s.initCause(x);
            throw s;
        }
    }

    public Constructor<?> getProxyConstructor(boolean xa) throws NoSuchMethodException {
        if (this.proxyClassConstructor == null) {
            Class<?> proxyClass = xa ? Proxy.getProxyClass(ConnectionPool.class.getClassLoader(), Connection.class, javax.sql.PooledConnection.class, XAConnection.class) : Proxy.getProxyClass(ConnectionPool.class.getClassLoader(), Connection.class, javax.sql.PooledConnection.class);
            this.proxyClassConstructor = proxyClass.getConstructor(InvocationHandler.class);
        }
        return this.proxyClassConstructor;
    }

    protected void close(boolean force) {
        BlockingQueue<PooledConnection> pool;
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.poolCleaner != null) {
            this.poolCleaner.stopRunning();
        }
        BlockingQueue<PooledConnection> blockingQueue = this.idle.size() > 0 ? this.idle : (pool = force ? this.busy : this.idle);
        while (pool.size() > 0) {
            try {
                PooledConnection con = pool.poll(1000L, TimeUnit.MILLISECONDS);
                while (con != null) {
                    if (pool == this.idle) {
                        this.release(con);
                    } else {
                        this.abandon(con);
                    }
                    if (pool.size() > 0) {
                        con = pool.poll(1000L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                if (this.getPoolProperties().getPropagateInterruptState()) {
                    Thread.currentThread().interrupt();
                }
                Thread.interrupted();
            }
            if (pool.size() != 0 || !force || pool == this.busy) continue;
            pool = this.busy;
        }
        if (this.getPoolProperties().isJmxEnabled()) {
            this.jmxPool = null;
        }
        PoolProperties.InterceptorDefinition[] proxies = this.getPoolProperties().getJdbcInterceptorsAsArray();
        for (int i = 0; i < proxies.length; ++i) {
            try {
                proxies[i].getInterceptorClass().newInstance().poolClosed(this);
                continue;
            }
            catch (Exception x) {
                log.debug("Unable to inform interceptor of pool closure.", x);
            }
        }
    }

    protected void init(PoolConfiguration properties) throws SQLException {
        this.poolProperties = properties;
        if (properties.getMaxActive() < 1) {
            log.warn("maxActive is smaller than 1, setting maxActive to: 100");
            properties.setMaxActive(100);
        }
        if (properties.getMaxActive() < properties.getInitialSize()) {
            log.warn("initialSize is larger than maxActive, setting initialSize to: " + properties.getMaxActive());
            properties.setInitialSize(properties.getMaxActive());
        }
        if (properties.getMinIdle() > properties.getMaxActive()) {
            log.warn("minIdle is larger than maxActive, setting minIdle to: " + properties.getMaxActive());
            properties.setMinIdle(properties.getMaxActive());
        }
        if (properties.getMaxIdle() > properties.getMaxActive()) {
            log.warn("maxIdle is larger than maxActive, setting maxIdle to: " + properties.getMaxActive());
            properties.setMaxIdle(properties.getMaxActive());
        }
        if (properties.getMaxIdle() < properties.getMinIdle()) {
            log.warn("maxIdle is smaller than minIdle, setting maxIdle to: " + properties.getMinIdle());
            properties.setMaxIdle(properties.getMinIdle());
        }
        this.busy = new ArrayBlockingQueue<PooledConnection>(properties.getMaxActive(), false);
        this.idle = properties.isFairQueue() ? new FairBlockingQueue<PooledConnection>() : new ArrayBlockingQueue<PooledConnection>(properties.getMaxActive(), properties.isFairQueue());
        this.initializePoolCleaner(properties);
        if (this.getPoolProperties().isJmxEnabled()) {
            this.createMBean();
        }
        PoolProperties.InterceptorDefinition[] proxies = this.getPoolProperties().getJdbcInterceptorsAsArray();
        for (int i = 0; i < proxies.length; ++i) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Creating interceptor instance of class:" + proxies[i].getInterceptorClass());
                }
                JdbcInterceptor interceptor = proxies[i].getInterceptorClass().newInstance();
                interceptor.setProperties(proxies[i].getProperties());
                interceptor.poolStarted(this);
                continue;
            }
            catch (Exception x) {
                log.error("Unable to inform interceptor of pool start.", x);
                if (this.jmxPool != null) {
                    this.jmxPool.notify("INIT FAILED", ConnectionPool.getStackTrace(x));
                }
                this.close(true);
                SQLException ex = new SQLException();
                ex.initCause(x);
                throw ex;
            }
        }
        PooledConnection[] initialPool = new PooledConnection[this.poolProperties.getInitialSize()];
        try {
            for (int i = 0; i < initialPool.length; ++i) {
                initialPool[i] = this.borrowConnection(0, null, null);
            }
        }
        catch (SQLException x) {
            if (this.jmxPool != null) {
                this.jmxPool.notify("INIT FAILED", ConnectionPool.getStackTrace(x));
            }
            this.close(true);
            throw x;
        }
        finally {
            for (int i = 0; i < initialPool.length; ++i) {
                if (initialPool[i] == null) continue;
                try {
                    this.returnConnection(initialPool[i]);
                    continue;
                }
                catch (Exception x) {}
            }
        }
        this.closed = false;
    }

    public void initializePoolCleaner(PoolConfiguration properties) {
        if (properties.isPoolSweeperEnabled()) {
            this.poolCleaner = new PoolCleaner(this, properties.getTimeBetweenEvictionRunsMillis());
            this.poolCleaner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandon(PooledConnection con) {
        if (con == null) {
            return;
        }
        try {
            con.lock();
            String trace = con.getStackTrace();
            if (this.getPoolProperties().isLogAbandoned()) {
                log.warn("Connection has been abandoned " + con + ":" + trace);
            }
            if (this.jmxPool != null) {
                this.jmxPool.notify("CONNECTION ABANDONED", trace);
            }
            this.release(con);
        }
        finally {
            con.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspect(PooledConnection con) {
        if (con == null) {
            return;
        }
        if (con.isSuspect()) {
            return;
        }
        try {
            con.lock();
            String trace = con.getStackTrace();
            if (this.getPoolProperties().isLogAbandoned()) {
                log.warn("Connection has been marked suspect, possibly abandoned " + con + "[" + (System.currentTimeMillis() - con.getTimestamp()) + " ms.]:" + trace);
            }
            if (this.jmxPool != null) {
                this.jmxPool.notify("SUSPECT CONNETION ABANDONED", trace);
            }
            con.setSuspect(true);
        }
        finally {
            con.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(PooledConnection con) {
        if (con == null) {
            return;
        }
        try {
            con.lock();
            if (con.release()) {
                this.size.addAndGet(-1);
                con.setHandler(null);
            }
        }
        finally {
            con.unlock();
        }
        if (this.waitcount.get() > 0) {
            this.idle.offer(this.create(true));
        }
    }

    private PooledConnection borrowConnection(int wait, String username, String password) throws SQLException {
        long timetowait;
        long maxWait;
        if (this.isClosed()) {
            throw new SQLException("Connection pool closed.");
        }
        long now = System.currentTimeMillis();
        PooledConnection con = (PooledConnection)this.idle.poll();
        do {
            PooledConnection result;
            if (con != null && (result = this.borrowConnection(now, con, username, password)) != null) {
                return result;
            }
            if (this.size.get() < this.getPoolProperties().getMaxActive()) {
                if (this.size.addAndGet(1) > this.getPoolProperties().getMaxActive()) {
                    this.size.decrementAndGet();
                } else {
                    return this.createConnection(now, con, username, password);
                }
            }
            maxWait = wait;
            if (wait == -1) {
                maxWait = this.getPoolProperties().getMaxWait() <= 0 ? Long.MAX_VALUE : (long)this.getPoolProperties().getMaxWait();
            }
            timetowait = Math.max(0L, maxWait - (System.currentTimeMillis() - now));
            this.waitcount.incrementAndGet();
            try {
                con = this.idle.poll(timetowait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                if (this.getPoolProperties().getPropagateInterruptState()) {
                    Thread.currentThread().interrupt();
                } else {
                    Thread.interrupted();
                }
                SQLException sx = new SQLException("Pool wait interrupted.");
                sx.initCause(ex);
                throw sx;
            }
            finally {
                this.waitcount.decrementAndGet();
            }
            if (maxWait != 0L || con != null) continue;
            if (this.jmxPool != null) {
                this.jmxPool.notify("POOL EMPTY", "Pool empty - no wait.");
            }
            throw new PoolExhaustedException("[" + Thread.currentThread().getName() + "] " + "NoWait: Pool empty. Unable to fetch a connection, none available[" + this.busy.size() + " in use].");
        } while (con != null || System.currentTimeMillis() - now < maxWait);
        if (this.jmxPool != null) {
            this.jmxPool.notify("POOL EMPTY", "Pool empty - timeout.");
        }
        throw new PoolExhaustedException("[" + Thread.currentThread().getName() + "] " + "Timeout: Pool empty. Unable to fetch a connection in " + maxWait / 1000L + " seconds, none available[size:" + this.size.get() + "; busy:" + this.busy.size() + "; idle:" + this.idle.size() + "; lastwait:" + timetowait + "].");
    }

    protected PooledConnection createConnection(long now, PooledConnection notUsed, String username, String password) throws SQLException {
        PooledConnection con = this.create(false);
        if (username != null) {
            con.getAttributes().put("user", username);
        }
        if (password != null) {
            con.getAttributes().put("password", password);
        }
        boolean error = false;
        try {
            con.lock();
            con.connect();
            if (con.validate(4)) {
                con.setTimestamp(now);
                if (this.getPoolProperties().isLogAbandoned()) {
                    con.setStackTrace(ConnectionPool.getThreadDump());
                }
                if (!this.busy.offer(con)) {
                    log.debug("Connection doesn't fit into busy array, connection will not be traceable.");
                }
                PooledConnection pooledConnection = con;
                return pooledConnection;
            }
            error = true;
        }
        catch (Exception e) {
            error = true;
            if (log.isDebugEnabled()) {
                log.debug("Unable to create a new JDBC connection.", e);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (error) {
                this.release(con);
            }
            con.unlock();
        }
        return null;
    }

    protected PooledConnection borrowConnection(long now, PooledConnection con, String username, String password) throws SQLException {
        boolean setToNull = false;
        try {
            con.lock();
            boolean usercheck = con.checkUser(username, password);
            if (con.isReleased()) {
                PooledConnection pooledConnection = null;
                return pooledConnection;
            }
            if (!con.isDiscarded() && !con.isInitialized()) {
                try {
                    con.connect();
                }
                catch (Exception x) {
                    this.release(con);
                    setToNull = true;
                    if (x instanceof SQLException) {
                        throw (SQLException)x;
                    }
                    SQLException ex = new SQLException(x.getMessage());
                    ex.initCause(x);
                    throw ex;
                }
            }
            if (usercheck && !con.isDiscarded() && con.validate(1)) {
                con.setTimestamp(now);
                if (this.getPoolProperties().isLogAbandoned()) {
                    con.setStackTrace(ConnectionPool.getThreadDump());
                }
                if (!this.busy.offer(con)) {
                    log.debug("Connection doesn't fit into busy array, connection will not be traceable.");
                }
                PooledConnection x = con;
                return x;
            }
            con.reconnect();
            if (con.validate(4)) {
                con.setTimestamp(now);
                if (this.getPoolProperties().isLogAbandoned()) {
                    con.setStackTrace(ConnectionPool.getThreadDump());
                }
                if (!this.busy.offer(con)) {
                    log.debug("Connection doesn't fit into busy array, connection will not be traceable.");
                }
                PooledConnection x = con;
                return x;
            }
            try {
                this.release(con);
                setToNull = true;
                throw new SQLException("Failed to validate a newly established connection.");
            }
            catch (Exception x) {
                this.release(con);
                setToNull = true;
                if (x instanceof SQLException) {
                    throw (SQLException)x;
                }
                SQLException ex = new SQLException(x.getMessage());
                ex.initCause(x);
                throw ex;
            }
        }
        finally {
            con.unlock();
            if (setToNull) {
                con = null;
            }
        }
    }

    protected boolean terminateTransaction(PooledConnection con) {
        try {
            if (con.getPoolProperties().getDefaultAutoCommit() == Boolean.FALSE) {
                boolean autocommit;
                if (this.getPoolProperties().getRollbackOnReturn()) {
                    boolean autocommit2 = con.getConnection().getAutoCommit();
                    if (!autocommit2) {
                        con.getConnection().rollback();
                    }
                } else if (this.getPoolProperties().getCommitOnReturn() && !(autocommit = con.getConnection().getAutoCommit())) {
                    con.getConnection().commit();
                }
            }
            return true;
        }
        catch (SQLException x) {
            log.warn("Unable to terminate transaction, connection will be closed.", x);
            return false;
        }
    }

    protected boolean shouldClose(PooledConnection con, int action) {
        if (con.getConnectionVersion() < this.getPoolVersion()) {
            return true;
        }
        if (con.isDiscarded()) {
            return true;
        }
        if (this.isClosed()) {
            return true;
        }
        if (!con.validate(action)) {
            return true;
        }
        if (!this.terminateTransaction(con)) {
            return true;
        }
        if (this.getPoolProperties().getMaxAge() > 0L) {
            return System.currentTimeMillis() - con.getLastConnected() > this.getPoolProperties().getMaxAge();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(PooledConnection con) {
        if (this.isClosed()) {
            this.release(con);
            return;
        }
        if (con != null) {
            try {
                con.lock();
                if (this.busy.remove(con)) {
                    if (!this.shouldClose(con, 2)) {
                        con.setStackTrace(null);
                        con.setTimestamp(System.currentTimeMillis());
                        if (this.idle.size() >= this.poolProperties.getMaxIdle() && !this.poolProperties.isPoolSweeperEnabled() || !this.idle.offer(con)) {
                            if (log.isDebugEnabled()) {
                                log.debug("Connection [" + con + "] will be closed and not returned to the pool, idle[" + this.idle.size() + "]>=maxIdle[" + this.poolProperties.getMaxIdle() + "] idle.offer failed.");
                            }
                            this.release(con);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Connection [" + con + "] will be closed and not returned to the pool.");
                        }
                        this.release(con);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Connection [" + con + "] will be closed and not returned to the pool, busy.remove failed.");
                    }
                    this.release(con);
                }
            }
            finally {
                con.unlock();
            }
        }
    }

    protected boolean shouldAbandon() {
        float perc;
        float max;
        if (this.poolProperties.getAbandonWhenPercentageFull() == 0) {
            return true;
        }
        float used = this.busy.size();
        return used / (max = (float)this.poolProperties.getMaxActive()) * 100.0f >= (perc = (float)this.poolProperties.getAbandonWhenPercentageFull());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAbandoned() {
        try {
            if (this.busy.size() == 0) {
                return;
            }
            Iterator locked = this.busy.iterator();
            int sto = this.getPoolProperties().getSuspectTimeout();
            while (locked.hasNext()) {
                PooledConnection con = (PooledConnection)locked.next();
                boolean setToNull = false;
                try {
                    con.lock();
                    if (this.idle.contains(con)) continue;
                    long time = con.getTimestamp();
                    long now = System.currentTimeMillis();
                    if (this.shouldAbandon() && now - time > con.getAbandonTimeout()) {
                        this.busy.remove(con);
                        this.abandon(con);
                        setToNull = true;
                        continue;
                    }
                    if (sto <= 0 || now - time <= (long)(sto * 1000)) continue;
                    this.suspect(con);
                }
                finally {
                    con.unlock();
                    if (!setToNull) continue;
                    con = null;
                }
            }
        }
        catch (ConcurrentModificationException e) {
            log.debug("checkAbandoned failed.", e);
        }
        catch (Exception e) {
            log.warn("checkAbandoned failed, it will be retried.", e);
        }
    }

    public void checkIdle() {
        this.checkIdle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIdle(boolean ignoreMinSize) {
        try {
            if (this.idle.size() == 0) {
                return;
            }
            long now = System.currentTimeMillis();
            Iterator unlocked = this.idle.iterator();
            while ((ignoreMinSize || this.idle.size() >= this.getPoolProperties().getMinIdle()) && unlocked.hasNext()) {
                PooledConnection con = (PooledConnection)unlocked.next();
                boolean setToNull = false;
                try {
                    long time;
                    con.lock();
                    if (this.busy.contains(con) || !this.shouldReleaseIdle(now, con, time = con.getTimestamp())) continue;
                    this.release(con);
                    this.idle.remove(con);
                    setToNull = true;
                }
                finally {
                    con.unlock();
                    if (!setToNull) continue;
                    con = null;
                }
            }
        }
        catch (ConcurrentModificationException e) {
            log.debug("checkIdle failed.", e);
        }
        catch (Exception e) {
            log.warn("checkIdle failed, it will be retried.", e);
        }
    }

    protected boolean shouldReleaseIdle(long now, PooledConnection con, long time) {
        if (con.getConnectionVersion() < this.getPoolVersion()) {
            return true;
        }
        return con.getReleaseTime() > 0L && now - time > con.getReleaseTime() && this.getSize() > this.getPoolProperties().getMinIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllIdle() {
        try {
            if (this.idle.size() == 0) {
                return;
            }
            for (PooledConnection con : this.idle) {
                try {
                    con.lock();
                    if (this.busy.contains(con) || con.validate(3)) continue;
                    this.idle.remove(con);
                    this.release(con);
                }
                finally {
                    con.unlock();
                }
            }
        }
        catch (ConcurrentModificationException e) {
            log.debug("testAllIdle failed.", e);
        }
        catch (Exception e) {
            log.warn("testAllIdle failed, it will be retried.", e);
        }
    }

    protected static String getThreadDump() {
        Exception x = new Exception();
        x.fillInStackTrace();
        return ConnectionPool.getStackTrace(x);
    }

    public static String getStackTrace(Throwable x) {
        if (x == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(bout);
        x.printStackTrace(writer);
        String result = bout.toString();
        return x.getMessage() != null && x.getMessage().length() > 0 ? x.getMessage() + ";" + result : result;
    }

    protected PooledConnection create(boolean incrementCounter) {
        if (incrementCounter) {
            this.size.incrementAndGet();
        }
        PooledConnection con = new PooledConnection(this.getPoolProperties(), this);
        return con;
    }

    public void purge() {
        this.purgeOnReturn();
        this.checkIdle(true);
    }

    public void purgeOnReturn() {
        this.poolVersion.incrementAndGet();
    }

    protected void finalize(PooledConnection con) {
        for (JdbcInterceptor handler = con.getHandler(); handler != null; handler = handler.getNext()) {
            handler.reset(null, null);
        }
    }

    protected void disconnectEvent(PooledConnection con, boolean finalizing) {
        for (JdbcInterceptor handler = con.getHandler(); handler != null; handler = handler.getNext()) {
            handler.disconnected(this, con, finalizing);
        }
    }

    public org.apache.tomcat.jdbc.pool.jmx.ConnectionPool getJmxPool() {
        return this.jmxPool;
    }

    protected void createMBean() {
        try {
            this.jmxPool = new org.apache.tomcat.jdbc.pool.jmx.ConnectionPool(this);
        }
        catch (Exception x) {
            log.warn("Unable to start JMX integration for connection pool. Instance[" + this.getName() + "] can't be monitored.", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void registerCleaner(PoolCleaner cleaner) {
        ConnectionPool.unregisterCleaner(cleaner);
        cleaners.add(cleaner);
        if (poolCleanTimer == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ConnectionPool.class.getClassLoader());
                poolCleanTimer = new Timer("PoolCleaner[" + System.identityHashCode(ConnectionPool.class.getClassLoader()) + ":" + System.currentTimeMillis() + "]", true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
        poolCleanTimer.scheduleAtFixedRate((TimerTask)cleaner, cleaner.sleepTime, cleaner.sleepTime);
    }

    private static synchronized void unregisterCleaner(PoolCleaner cleaner) {
        boolean removed = cleaners.remove(cleaner);
        if (removed) {
            cleaner.cancel();
            if (poolCleanTimer != null) {
                poolCleanTimer.purge();
                if (cleaners.size() == 0) {
                    poolCleanTimer.cancel();
                    poolCleanTimer = null;
                }
            }
        }
    }

    public static Set<TimerTask> getPoolCleaners() {
        return Collections.unmodifiableSet(cleaners);
    }

    public long getPoolVersion() {
        return this.poolVersion.get();
    }

    public static Timer getPoolTimer() {
        return poolCleanTimer;
    }

    protected class PoolCleaner
    extends TimerTask {
        protected ConnectionPool pool;
        protected long sleepTime;
        protected volatile boolean run = true;
        protected volatile long lastRun = 0L;

        PoolCleaner(ConnectionPool pool, long sleepTime) {
            this.pool = pool;
            this.sleepTime = sleepTime;
            if (sleepTime <= 0L) {
                log.warn("Database connection pool evicter thread interval is set to 0, defaulting to 30 seconds");
                this.sleepTime = 30000L;
            } else if (sleepTime < 1000L) {
                log.warn("Database connection pool evicter thread interval is set to lower than 1 second.");
            }
        }

        public void run() {
            if (this.pool.isClosed()) {
                if (this.pool.getSize() <= 0) {
                    this.run = false;
                }
            } else if (System.currentTimeMillis() - this.lastRun > this.sleepTime) {
                this.lastRun = System.currentTimeMillis();
                try {
                    if (this.pool.getPoolProperties().isRemoveAbandoned()) {
                        this.pool.checkAbandoned();
                    }
                    if (this.pool.getPoolProperties().getMinIdle() < this.pool.idle.size()) {
                        this.pool.checkIdle();
                    }
                    if (this.pool.getPoolProperties().isTestWhileIdle()) {
                        this.pool.testAllIdle();
                    }
                }
                catch (Exception x) {
                    log.error("", x);
                }
            }
        }

        public void start() {
            ConnectionPool.registerCleaner(this);
        }

        public void stopRunning() {
            ConnectionPool.unregisterCleaner(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConnectionFuture
    implements Future<Connection>,
    Runnable {
        Future<PooledConnection> pcFuture = null;
        AtomicBoolean configured = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        Connection result = null;
        SQLException cause = null;
        AtomicBoolean cancelled = new AtomicBoolean(false);
        volatile PooledConnection pc = null;

        public ConnectionFuture(Future<PooledConnection> pcf) {
            this.pcFuture = pcf;
        }

        public ConnectionFuture(PooledConnection pc) throws SQLException {
            this.pc = pc;
            this.result = ConnectionPool.this.setupConnection(pc);
            this.configured.set(true);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.pc != null) {
                return false;
            }
            if (!this.cancelled.get() && this.cancelled.compareAndSet(false, true)) {
                ConnectionPool.this.cancellator.execute(this);
            }
            return true;
        }

        @Override
        public Connection get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException x) {
                throw new ExecutionException(x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            PooledConnection pc;
            PooledConnection pooledConnection = pc = this.pc != null ? this.pc : this.pcFuture.get(timeout, unit);
            if (pc != null) {
                if (this.result != null) {
                    return this.result;
                }
                if (this.configured.compareAndSet(false, true)) {
                    try {
                        pc = ConnectionPool.this.borrowConnection(System.currentTimeMillis(), pc, null, null);
                        this.result = ConnectionPool.this.setupConnection(pc);
                    }
                    catch (SQLException x) {
                        this.cause = x;
                    }
                    finally {
                        this.latch.countDown();
                    }
                } else {
                    this.latch.await(timeout, unit);
                }
                if (this.result == null) {
                    throw new ExecutionException(this.cause);
                }
                return this.result;
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return this.pc == null && (this.pcFuture.isCancelled() || this.cancelled.get());
        }

        @Override
        public boolean isDone() {
            return this.pc != null || this.pcFuture.isDone();
        }

        @Override
        public void run() {
            try {
                Connection con = this.get();
                con.close();
            }
            catch (ExecutionException ex) {
            }
            catch (Exception x) {
                log.error("Unable to cancel ConnectionFuture.", x);
            }
        }
    }
}

