/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

public abstract class AbstractJSONMessageFormatter
implements MessageFormatter {
    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String contentType = (String)msgCtxt.getProperty("ContentType");
        String encoding = format.getCharSetEncoding();
        if (contentType == null) {
            contentType = (String)msgCtxt.getProperty("messageType");
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        OMElement element = msgCtxt.getEnvelope().getBody().getFirstElement();
        this.reformatElement(element);
        if (element instanceof OMSourcedElementImpl && this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource()) != null) {
            String jsonToWrite = this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource());
            return jsonToWrite.getBytes();
        }
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            XMLStreamWriter jsonWriter = this.getJSONWriter(bytesOut, format);
            element.serializeAndConsume(jsonWriter);
            jsonWriter.writeEndDocument();
            return bytesOut.toByteArray();
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new AxisFault("Mapped formatted JSON with namespaces are not supported in Axis2. Make sure that your request doesn't include namespaces or use the Badgerfish convention");
        }
    }

    public String formatSOAPAction(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        return null;
    }

    private XMLStreamWriter getJSONWriter(OutputStream outStream, OMOutputFormat format) throws AxisFault {
        try {
            return this.getJSONWriter(new OutputStreamWriter(outStream, format.getCharSetEncoding()));
        }
        catch (UnsupportedEncodingException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
    }

    protected abstract XMLStreamWriter getJSONWriter(Writer var1);

    protected abstract String getStringToWrite(OMDataSource var1);

    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        OMElement element = msgCtxt.getEnvelope().getBody().getFirstElement();
        this.reformatElement(element);
        try {
            if (element instanceof OMSourcedElementImpl && this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource()) != null) {
                String jsonToWrite = this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource());
                out.write(jsonToWrite.getBytes());
            } else {
                XMLStreamWriter jsonWriter = this.getJSONWriter(out, format);
                element.serializeAndConsume(jsonWriter);
                jsonWriter.writeEndDocument();
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new AxisFault("Mapped formatted JSON with namespaces are not supported in Axis2. Make sure that your request doesn't include namespaces or use the Badgerfish convention");
        }
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        String httpMethod = (String)msgCtxt.getProperty("HTTP_METHOD");
        OMElement dataOut = msgCtxt.getEnvelope().getBody().getFirstElement();
        if (dataOut != null && httpMethod != null && "GET".equalsIgnoreCase(httpMethod)) {
            try {
                String jsonString;
                if (dataOut instanceof OMSourcedElementImpl && this.getStringToWrite(((OMSourcedElementImpl)dataOut).getDataSource()) != null) {
                    jsonString = this.getStringToWrite(((OMSourcedElementImpl)dataOut).getDataSource());
                } else {
                    StringWriter out = new StringWriter();
                    XMLStreamWriter jsonWriter = this.getJSONWriter(out);
                    dataOut.serializeAndConsume(jsonWriter);
                    jsonWriter.writeEndDocument();
                    jsonString = out.toString();
                }
                jsonString = URIEncoderDecoder.quoteIllegal((String)jsonString, (String)"-._~!$&()*+,;=:@?/%");
                String param = "query=" + jsonString;
                String returnURLFile = targetURL.getFile() + "?" + param;
                return new URL(targetURL.getProtocol(), targetURL.getHost(), targetURL.getPort(), returnURLFile);
            }
            catch (MalformedURLException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        return targetURL;
    }

    private void reformatElement(OMElement elem) {
        this.removeIndentations(elem);
        this.removeNamespaces(elem, true);
    }

    private void removeIndentations(OMElement elem) {
        Iterator children = elem.getChildren();
        while (children.hasNext()) {
            OMNode child = (OMNode)children.next();
            if (child instanceof OMText) {
                if (!"".equals(((OMText)child).getText().trim())) continue;
                children.remove();
                continue;
            }
            if (!(child instanceof OMElement)) continue;
            this.removeIndentations((OMElement)child);
        }
    }

    private void removeNamespaces(OMElement elem, boolean processAttrbs) {
        String prefix;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = elem.getNamespace();
        if (ns != null) {
            prefix = elem.getNamespace().getPrefix();
            elem.setNamespace(omFactory.createOMNamespace("", prefix));
        }
        Iterator children = elem.getChildElements();
        while (children.hasNext()) {
            this.removeNamespaces((OMElement)children.next(), processAttrbs);
        }
        if (!processAttrbs) {
            return;
        }
        Iterator attrbs = elem.getAllAttributes();
        while (attrbs.hasNext()) {
            OMAttribute attrb = (OMAttribute)attrbs.next();
            prefix = attrb.getQName().getPrefix();
            attrb.setOMNamespace(omFactory.createOMNamespace("", prefix));
        }
    }
}

