/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public final class UserCoreUtil {
    private static Log log = LogFactory.getLog(UserCoreUtil.class);
    private static Boolean isEmailUserName;
    private static String domainCalculation;
    private static Boolean isCrossTenantUniqueUserName;
    private static final SynchronizingClass loadlock;
    private static RealmService realmService;
    private static final String DUMMY_VALUE = "dummy";

    private UserCoreUtil() {
    }

    public static String[] combineArrays(String[] arr1, String[] arr2) throws UserStoreException {
        if (arr1 == null || arr1.length == 0) {
            return arr2;
        }
        if (arr2 == null || arr2.length == 0) {
            return arr1;
        }
        Object[] newArray = new String[arr1.length + arr2.length];
        for (int i = 0; i < arr1.length; ++i) {
            newArray[i] = arr1[i];
        }
        int j = 0;
        for (int i = arr1.length; i < newArray.length; ++i) {
            Arrays.toString(newArray);
            newArray[i] = arr2[j];
            ++j;
        }
        return newArray;
    }

    public static String[] combine(String[] array, List<String> list) throws UserStoreException {
        String[] newArray = array;
        if (list.size() > 0) {
            newArray = new String[list.size() + array.length];
            int i = 0;
            Iterator<String> ite = list.iterator();
            while (ite.hasNext()) {
                String name;
                newArray[i] = name = ite.next();
                ++i;
            }
            String[] arr$ = array;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name;
                newArray[i] = name = arr$[i$];
                ++i;
            }
        }
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadData() {
        SynchronizingClass synchronizingClass = loadlock;
        synchronized (synchronizingClass) {
            if (isEmailUserName == null) {
                try {
                    if (realmService != null) {
                        UserRealm realm = realmService.getBootstrapRealm();
                        RealmConfiguration realmConfig = realm.getRealmConfiguration();
                        if (isCrossTenantUniqueUserName == null) {
                            String isUnique = realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenants");
                            isCrossTenantUniqueUserName = "true".equals(isUnique) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        }
                        if (isEmailUserName == null) {
                            String isEmail = realmConfig.getUserStoreProperty("IsEmailUserName");
                            isEmailUserName = "true".equals(isEmail) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        }
                        if (domainCalculation == null && (domainCalculation = realmConfig.getUserStoreProperty("DomainCalculation")) == null) {
                            domainCalculation = "default";
                        }
                    } else {
                        log.error((Object)"UserCoreUtil.loadData is called before the realm service is set. So using default settings.");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed to load data :" + e.getMessage()), (Throwable)e);
                    throw new RuntimeException("Failed to load data :" + e.getMessage(), e);
                }
            }
        }
    }

    public static String[] optimizePermissions(String[] rawResourcePath) {
        Arrays.sort(rawResourcePath);
        int index = 0;
        ArrayList<String> lst = new ArrayList<String>();
        block0: while (index < rawResourcePath.length) {
            String shortestString = rawResourcePath[index];
            lst.add(shortestString);
            ++index;
            Pattern p = Pattern.compile("(.*)/.*$");
            while (index < rawResourcePath.length) {
                Matcher m = p.matcher(rawResourcePath[index]);
                if (!m.find()) continue;
                String s = m.group(1);
                if (!s.equals(shortestString)) continue block0;
                ++index;
            }
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static Boolean getIsEmailUserName() {
        return isEmailUserName;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static void setRealmService(RealmService realmService) {
        UserCoreUtil.realmService = realmService;
    }

    public static Boolean getIsCrossTenantUniqueUserName() {
        return isCrossTenantUniqueUserName;
    }

    public static String getPasswordToStore(String password, String passwordHashMethod, boolean isKdcEnabled) throws UserStoreException {
        if (isKdcEnabled) {
            return password;
        }
        String passwordToStore = password;
        if (passwordHashMethod != null) {
            if (passwordHashMethod.equals("PLAIN_TEXT")) {
                return passwordToStore;
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(passwordHashMethod);
                byte[] digestValue = messageDigest.digest(password.getBytes());
                passwordToStore = "{" + passwordHashMethod + "}" + Base64.encode((byte[])digestValue);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UserStoreException("Invalid hashMethod", e);
            }
        }
        return passwordToStore;
    }

    public static boolean isKdcEnabled(RealmConfiguration realmConfig) {
        String stringKdcEnabled = realmConfig.getUserStoreProperty("kdcEnabled");
        if (stringKdcEnabled != null) {
            return Boolean.parseBoolean(stringKdcEnabled);
        }
        return false;
    }

    public static String getDummyPassword() {
        Random rand = new Random();
        return DUMMY_VALUE + rand.nextInt(999999);
    }

    static {
        loadlock = new SynchronizingClass();
        realmService = null;
    }

    private static class SynchronizingClass {
        private SynchronizingClass() {
        }
    }
}

