/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.sql.DataSource;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.ldap.ReadOnlyLDAPUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ReadWriteLDAPUserStoreManager
extends ReadOnlyLDAPUserStoreManager {
    private static Log logger = LogFactory.getLog(ReadWriteLDAPUserStoreManager.class);
    public static final String PASSWORD_HASH_METHOD = "passwordHashMethod";
    public static final String PASSWORD_HASH_METHOD_SHA = "SHA";
    public static final String PASSWORD_HASH_METHOD_MD5 = "MD5";
    public static final String ATTR_NAME_CN = "cn";
    public static final String ATTR_NAME_SN = "sn";
    protected static final String KRB5_PRINCIPAL_NAME_ATTRIBUTE = "krb5PrincipalName";
    protected static final String KRB5_KEY_VERSION_NUMBER_ATTRIBUTE = "krb5KeyVersionNumber";
    private static boolean isFirstStartup = true;
    private static Log log = LogFactory.getLog(ReadWriteLDAPUserStoreManager.class);
    protected static final String EMPTY_ATTRIBUTE_STRING = "";
    protected Random random = new Random();
    protected boolean kdcEnabled = false;

    public ReadWriteLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read-Write UserStoreManager initialization started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.profileManager = profileManager;
        this.userRealm = realm;
        this.tenantID = tenantId;
        this.kdcEnabled = UserCoreUtil.isKdcEnabled(realmConfig);
        this.checkRequiredUserStoreConfigurations();
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        isFirstStartup = (Boolean)properties.get("FistStartupCheck");
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, tenantId, realmConfig, this.userRealm);
        this.connectionSource = (LDAPConnectionContext)properties.get("ldapConnectionSource");
        if (this.connectionSource == null) {
            this.connectionSource = new LDAPConnectionContext(realmConfig);
        }
        try {
            this.connectionSource.getContext();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException("Cannot create connection to LDAP server. Error message " + e.getMessage());
        }
        this.realm = realm;
        this.addInitialData();
        this.adminUserName = realmConfig.getAdminUserName();
        this.initUserRolesCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read-Write UserStoreManager initialization ended " + System.currentTimeMillis()));
        }
    }

    public ReadWriteLDAPUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected String getRealmName() {
        String defaultRealmName = this.realmConfig.getUserStoreProperty("defaultRealmName");
        if (defaultRealmName != null) {
            return defaultRealmName;
        }
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String[] domainComponents = searchBase.split("dc=");
        StringBuilder builder = new StringBuilder();
        for (String dc : domainComponents) {
            if (dc.contains("=")) continue;
            String trimmedDc = dc.trim();
            if (trimmedDc.endsWith(",")) {
                builder.append(trimmedDc.replace(',', '.'));
                continue;
            }
            builder.append(trimmedDc);
        }
        return builder.toString().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.doAddUser(userName, credential, roleList, claims, profileName, false);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.doAddUserValidityChecks(userName, credential);
        DirContext dirContext = this.getSearchBaseDirectoryContext();
        BasicAttributes basicAttributes = this.getAddUserBasicAttributes(userName);
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        userPassword.add(UserCoreUtil.getPasswordToStore((String)credential, this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD), this.kdcEnabled));
        basicAttributes.put(userPassword);
        this.setUserClaims(claims, basicAttributes, userName);
        try {
            NameParser ldapParser = dirContext.getNameParser(EMPTY_ATTRIBUTE_STRING);
            Name compoundName = ldapParser.parse(this.realmConfig.getUserStoreProperty("UserNameAttribute") + "=" + userName);
            dirContext.bind(compoundName, null, (Attributes)basicAttributes);
            this.updateUserRoles(userName, roleList);
        }
        catch (NamingException e) {
            String errorMessage = "Can not access the directory context or user already exists in the system";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String errorMessage = "Error in obtaining claim mapping.";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
    }

    protected void doAddUserValidityChecks(String userName, Object credential) throws UserStoreException {
        if (!this.checkUserNameValid(userName)) {
            throw new UserStoreException("User name not valid. User name must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("UsernameJavaRegEx"));
        }
        if (!this.checkUserPasswordValid(credential)) {
            throw new UserStoreException("Credential not valid. Credential must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("PasswordJavaRegEx"));
        }
        if (this.isExistingUser(userName)) {
            throw new UserStoreException("User " + userName + " already exist in the LDAP");
        }
    }

    protected DirContext getSearchBaseDirectoryContext() throws UserStoreException {
        DirContext mainDirContext = this.connectionSource.getContext();
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        try {
            DirContext dirContext = (DirContext)mainDirContext.lookup(searchBase);
            return dirContext;
        }
        catch (NamingException e) {
            String errorMessage = "Can not access the directory context oruser already exists in the system";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(mainDirContext);
        }
    }

    protected BasicAttributes getAddUserBasicAttributes(String userName) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        String userObjectClass = this.realmConfig.getUserStoreProperty("UserEntryObjectClass");
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add(userObjectClass);
        if (this.kdcEnabled) {
            objectClass.add("krb5principal");
            objectClass.add("krb5kdcentry");
            objectClass.add("subschema");
        }
        basicAttributes.put(objectClass);
        BasicAttribute userNameAttribute = new BasicAttribute(this.realmConfig.getUserStoreProperty("UserNameAttribute"));
        userNameAttribute.add(userName);
        basicAttributes.put(userNameAttribute);
        if (this.kdcEnabled) {
            String principal = userName + "@" + this.getRealmName();
            BasicAttribute principalAttribute = new BasicAttribute(KRB5_PRINCIPAL_NAME_ATTRIBUTE);
            principalAttribute.add(principal);
            basicAttributes.put(principalAttribute);
            BasicAttribute versionNumberAttribute = new BasicAttribute(KRB5_KEY_VERSION_NUMBER_ATTRIBUTE);
            versionNumberAttribute.add("0");
            basicAttributes.put(versionNumberAttribute);
        }
        return basicAttributes;
    }

    protected void setUserClaims(Map<String, String> claims, BasicAttributes basicAttributes, String userName) throws UserStoreException {
        boolean isSNExists = false;
        boolean isCNExists = false;
        if (claims != null) {
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                String attributeName;
                if (EMPTY_ATTRIBUTE_STRING.equals(entry.getValue())) continue;
                String claimURI = entry.getKey();
                ClaimMapping claimMapping = null;
                try {
                    claimMapping = (ClaimMapping)this.claimManager.getClaimMapping(claimURI);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = "Error in obtaining claim mapping.";
                    logger.error((Object)errorMessage, (Throwable)e);
                    throw new UserStoreException(errorMessage, e);
                }
                if (claimMapping != null) {
                    attributeName = claimMapping.getMappedAttribute();
                    if (ATTR_NAME_CN.equals(attributeName)) {
                        isCNExists = true;
                    } else if (ATTR_NAME_SN.equals(attributeName)) {
                        isSNExists = true;
                    }
                } else {
                    attributeName = claimURI;
                }
                BasicAttribute claim = new BasicAttribute(attributeName);
                claim.add(claims.get(entry.getKey()));
                basicAttributes.put(claim);
            }
        }
        if (!isCNExists) {
            BasicAttribute cn = new BasicAttribute(ATTR_NAME_CN);
            cn.add(userName);
            basicAttributes.put(cn);
        }
        if (!isSNExists) {
            BasicAttribute sn = new BasicAttribute(ATTR_NAME_SN);
            sn.add(userName);
            basicAttributes.put(sn);
        }
    }

    protected void updateUserRoles(String userName, String[] roleList) throws UserStoreException {
        if (roleList != null && roleList.length != 0) {
            for (String role : roleList) {
                if (this.readLDAPUserGroups && this.writeLDAPUserGroups) {
                    if (!this.isInternalRole(role)) {
                        this.updateRoleListOfUser(userName, new String[0], new String[]{role});
                    } else if (this.isInternalRole(role)) {
                        this.hybridRoleManager.addHybridRole(role, new String[]{userName});
                        this.clearUserRolesCacheByTenant(this.tenantID);
                    }
                }
                if ((this.readLDAPUserGroups || this.writeLDAPUserGroups) && (!this.readLDAPUserGroups || this.writeLDAPUserGroups)) continue;
                this.hybridRoleManager.addHybridRole(role, new String[]{userName});
                this.clearUserRolesCacheByTenant(this.tenantID);
            }
        }
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        if ((!this.readLDAPUserGroups && !this.writeLDAPUserGroups || this.readLDAPUserGroups && !this.writeLDAPUserGroups) && this.hybridRoleManager != null) {
            this.hybridRoleManager.deleteUser(userName);
        }
        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", userName);
        String[] returningUserAttributes = new String[]{userNameAttribute};
        DirContext mainDirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> userResults = this.searchInUserBase(searchFilter, returningUserAttributes, 2, mainDirContext);
        NamingEnumeration<SearchResult> groupResults = null;
        DirContext subDirContext = null;
        try {
            String[] rolesOfUser;
            SearchResult userResult = null;
            String userDN = null;
            while (userResults.hasMore()) {
                userResult = userResults.next();
                userDN = userResult.getName();
            }
            if (this.readLDAPUserGroups && this.writeLDAPUserGroups && (rolesOfUser = this.getRoleListOfUser(userName)).length != 0) {
                String roleNameSearchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
                String[] returningGroupAttributes = new String[]{this.realmConfig.getUserStoreProperty("MembershipAttribute")};
                for (String role : rolesOfUser) {
                    if (this.isInternalRole(role)) continue;
                    String groupSearchFilter = roleNameSearchFilter.replace("?", role);
                    groupResults = this.searchInGroupBase(groupSearchFilter, returningGroupAttributes, 2, mainDirContext);
                    SearchResult groupResult = null;
                    while (groupResults.hasMore()) {
                        groupResult = groupResults.next();
                    }
                    if (!this.isOnlyUserInRole(userDN, groupResult) || this.emptyRolesAllowed) continue;
                    String errorMessage = "User: " + userName + " is the only user " + "in " + role + "." + "There should be at " + "least one user" + " in the role. Hence can" + " not delete the user.";
                    logger.error((Object)errorMessage);
                    throw new UserStoreException(errorMessage);
                }
                for (String role : rolesOfUser) {
                    if (!this.isInternalRole(role)) {
                        this.updateRoleListOfUser(userName, new String[]{role}, new String[0]);
                        continue;
                    }
                    if (!this.isInternalRole(role)) continue;
                    this.hybridRoleManager.deleteUser(userName);
                }
            }
            if (userResult.getAttributes().get(userNameAttribute).get().equals(userName)) {
                subDirContext = (DirContext)mainDirContext.lookup(this.userSearchBase);
                subDirContext.destroySubcontext(userDN);
            }
            this.userRealm.getAuthorizationManager().clearUserAuthorization(userName);
            this.clearUserRolesCacheByTenant(this.tenantID);
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while deleting the user. ";
                logger.error((Object)errorMessage, (Throwable)e);
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(groupResults);
                JNDIUtil.closeNamingEnumeration(userResults);
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(groupResults);
        JNDIUtil.closeNamingEnumeration(userResults);
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        this.doUpdateCredentialsValidityChecks(userName, newCredential);
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"userPassword"});
        NamingEnumeration<SearchResult> namingEnumeration = null;
        NamingEnumeration<?> passwords = null;
        try {
            namingEnumeration = dirContext.search(searchBase, searchFilter, searchControls);
            NameClassPair searchResult = null;
            while (namingEnumeration.hasMore()) {
                searchResult = namingEnumeration.next();
                Attributes attributes = ((SearchResult)searchResult).getAttributes();
                Attribute userPassword = attributes.get("userPassword");
                String passwordHashMethod = this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD);
                if (oldCredential != null && (passwords = userPassword.getAll()).hasMore()) {
                    byte[] byteArray = (byte[])passwords.next();
                    String password = new String(byteArray);
                    if (password.startsWith("{")) {
                        passwordHashMethod = password.substring(password.indexOf(123) + 1, password.indexOf(125));
                    }
                    if (!password.equals(UserCoreUtil.getPasswordToStore((String)oldCredential, passwordHashMethod, this.kdcEnabled))) {
                        throw new UserStoreException("Old password does not match");
                    }
                }
                String dnName = searchResult.getName();
                subDirContext = (DirContext)dirContext.lookup(searchBase);
                BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
                passwordAttribute.add(UserCoreUtil.getPasswordToStore((String)newCredential, passwordHashMethod, this.kdcEnabled));
                BasicAttributes basicAttributes = new BasicAttributes(true);
                basicAttributes.put(passwordAttribute);
                subDirContext.modifyAttributes(dnName, 2, (Attributes)basicAttributes);
            }
            if (searchResult.getNameInNamespace().equals(this.realmConfig.getUserStoreProperty("ConnectionName"))) {
                this.connectionSource.updateCredential((String)newCredential);
            }
        }
        catch (NamingException e) {
            throw new UserStoreException("Can not access the directory service", e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(passwords);
            JNDIUtil.closeNamingEnumeration(namingEnumeration);
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(dirContext);
        }
    }

    protected void doUpdateCredentialsValidityChecks(String userName, Object newCredential) throws UserStoreException {
        if (!this.isExistingUser(userName)) {
            throw new UserStoreException("User " + userName + " does not exisit in the user store");
        }
        if (!this.checkUserPasswordValid(newCredential)) {
            throw new UserStoreException("Credential not valid. Credential must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("PasswordJavaRegEx"));
        }
    }

    @Override
    public Map<String, String> getProperties(Tenant tenant) throws UserStoreException {
        Map existingProperties = this.realmConfig.getUserStoreProperties();
        String tenantSufix = this.getTenantSuffix(tenant.getDomain());
        String propertyName = null;
        HashMap<String, String> newProperties = new HashMap<String, String>();
        for (Map.Entry iter : existingProperties.entrySet()) {
            propertyName = (String)iter.getKey();
            if (propertyName.equals("UserSearchBase")) {
                newProperties.put(propertyName, tenantSufix);
                continue;
            }
            newProperties.put(propertyName, (String)iter.getValue());
        }
        return newProperties;
    }

    private String getTenantSuffix(String domain) {
        String[] domainParts = domain.split("\\.");
        StringBuffer suffixName = new StringBuffer();
        for (String domainPart : domainParts) {
            suffixName.append(",dc=").append(domainPart);
        }
        return suffixName.toString().replaceFirst(",", EMPTY_ATTRIBUTE_STRING);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        userSearchFilter = userSearchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(null);
        NamingEnumeration<SearchResult> returnedResultList = null;
        String returnedUserEntry = null;
        try {
            returnedResultList = dirContext.search(userSearchBase, userSearchFilter, searchControls);
            returnedUserEntry = returnedResultList.next().getName();
        }
        catch (NamingException e) {
            throw new UserStoreException("Results could not be retrieved from the directory context", e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(returnedResultList);
        }
        if (profileName == null) {
            profileName = "default";
        }
        if (claims.get("profileConfiguration") == null) {
            claims.put("profileConfiguration", "default");
        }
        try {
            BasicAttributes updatedAttributes = new BasicAttributes(true);
            for (Map.Entry<String, String> claimEntry : claims.entrySet()) {
                String claimURI = claimEntry.getKey();
                if (claimURI.equals("profileConfiguration")) continue;
                ClaimMapping claimMapping = (ClaimMapping)this.claimManager.getClaimMapping(claimURI);
                String attributeName = null;
                attributeName = claimMapping != null ? claimMapping.getMappedAttribute() : claimURI;
                BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                if (EMPTY_ATTRIBUTE_STRING.equals(claimEntry.getValue())) {
                    currentUpdatedAttribute.clear();
                } else if (claimEntry.getValue() != null && claimEntry.getValue().contains(",")) {
                    String[] values;
                    for (String newValue : values = claimEntry.getValue().split(",")) {
                        if (newValue == null || newValue.trim().length() <= 0) continue;
                        currentUpdatedAttribute.add(newValue.trim());
                    }
                } else {
                    currentUpdatedAttribute.add(claimEntry.getValue());
                }
                updatedAttributes.put(currentUpdatedAttribute);
            }
            subDirContext = (DirContext)dirContext.lookup(userSearchBase);
            subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
        }
        catch (InvalidAttributeValueException e) {
            try {
                String errorMessage = "One or more attribute values provided are incompatible. Please check and try again.";
                logger.error((Object)errorMessage, (Throwable)e);
                throw new UserStoreException(errorMessage, e);
                catch (InvalidAttributeIdentifierException e2) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    logger.error((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(errorMessage, e2);
                }
                catch (NoSuchAttributeException e3) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    logger.error((Object)errorMessage, (Throwable)e3);
                    throw new UserStoreException(errorMessage, e3);
                }
                catch (NamingException e4) {
                    errorMessage = "Profile information could not be updated in ApacheDS LDAP user store";
                    logger.error((Object)errorMessage, (Throwable)e4);
                    throw new UserStoreException(errorMessage, e4);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e5) {
                    errorMessage = "Error in obtaining claim mapping.";
                    logger.error((Object)errorMessage, (Throwable)e5);
                    throw new UserStoreException(errorMessage, e5);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String value, String profileName) throws UserStoreException {
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        userSearchFilter = userSearchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(null);
        NamingEnumeration<SearchResult> returnedResultList = null;
        String returnedUserEntry = null;
        try {
            returnedResultList = dirContext.search(userSearchBase, userSearchFilter, searchControls);
            returnedUserEntry = returnedResultList.next().getName();
        }
        catch (NamingException e) {
            throw new UserStoreException("Results could not be retrieved from the directory context", e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(returnedResultList);
        }
        try {
            BasicAttributes updatedAttributes = new BasicAttributes(true);
            ClaimMapping claimMapping = (ClaimMapping)this.claimManager.getClaimMapping(claimURI);
            String attributeName = null;
            attributeName = claimMapping != null ? claimMapping.getMappedAttribute() : claimURI;
            BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
            if (EMPTY_ATTRIBUTE_STRING.equals(value)) {
                currentUpdatedAttribute.clear();
            } else if (value.contains(",")) {
                String[] values;
                for (String newValue : values = value.split(",")) {
                    if (newValue == null || newValue.trim().length() <= 0) continue;
                    currentUpdatedAttribute.add(newValue.trim());
                }
            } else {
                currentUpdatedAttribute.add(value);
            }
            updatedAttributes.put(currentUpdatedAttribute);
            subDirContext = (DirContext)dirContext.lookup(userSearchBase);
            subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
        }
        catch (InvalidAttributeValueException e) {
            try {
                String errorMessage = "One or more attribute values provided are incompatible. Please check and try again.";
                logger.error((Object)errorMessage, (Throwable)e);
                throw new UserStoreException(errorMessage, e);
                catch (InvalidAttributeIdentifierException e2) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    logger.error((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(errorMessage, e2);
                }
                catch (NoSuchAttributeException e3) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    logger.error((Object)errorMessage, (Throwable)e3);
                    throw new UserStoreException(errorMessage, e3);
                }
                catch (NamingException e4) {
                    errorMessage = "Profile information could not be updated in ApacheDS LDAP user store";
                    logger.error((Object)errorMessage, (Throwable)e4);
                    throw new UserStoreException(errorMessage, e4);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e5) {
                    errorMessage = "Error in obtaining claim mapping.";
                    logger.error((Object)errorMessage, (Throwable)e5);
                    throw new UserStoreException(errorMessage, e5);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        if (this.isInternalRole(roleName) || !this.readLDAPUserGroups && !this.writeLDAPUserGroups) {
            super.addRole(roleName, userList, permissions);
            return;
        }
        if (this.readLDAPUserGroups && !this.writeLDAPUserGroups) {
            super.addRole(roleName, userList, permissions);
            return;
        }
        if (!this.readLDAPUserGroups) return;
        if (!this.writeLDAPUserGroups) return;
        if (!this.roleNameValid(roleName)) {
            String roleNameRegEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
            String errorMsg = "Role name not valid. Role name must be a non null string with following format, " + roleNameRegEx;
            logger.error((Object)errorMsg);
            throw new UserStoreException(errorMsg);
        }
        if (this.isExistingRole(roleName)) {
            String errorMessage = "Can not add the role. Role name: " + roleName + " already exists.";
            logger.error((Object)errorMessage);
            throw new UserStoreException(errorMessage);
        }
        if (!(userList != null && userList.length != 0 || this.emptyRolesAllowed)) {
            String errorMessage = "Can not create empty role. There should be at least one user for the role.";
            logger.error((Object)errorMessage);
            throw new UserStoreException(errorMessage);
        }
        if (!(userList == null && this.emptyRolesAllowed || userList != null && userList.length > 0 && !this.emptyRolesAllowed)) {
            if (!this.emptyRolesAllowed) return;
        }
        DirContext mainDirContext = this.connectionSource.getContext();
        DirContext groupContext = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            BasicAttributes groupAttributes = new BasicAttributes(true);
            BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
            objectClassAttribute.add(this.realmConfig.getUserStoreProperty("GroupEntryObjectClass"));
            groupAttributes.put(objectClassAttribute);
            String groupNameAttributeName = (String)this.realmConfig.getUserStoreProperties().get("GroupNameAttribute");
            BasicAttribute cnAttribute = new BasicAttribute(groupNameAttributeName);
            cnAttribute.add(roleName);
            groupAttributes.put(cnAttribute);
            if (userList != null && userList.length > 0) {
                String string;
                String searchFilter;
                String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                BasicAttribute memberAttribute = new BasicAttribute(memberAttributeName);
                String[] stringArray = userList;
                int len$ = stringArray.length;
                for (int i$ = 0; i$ < len$; searchFilter = searchFilter.replace("?", string), ++i$) {
                    string = stringArray[i$];
                    searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
                    results = this.searchInUserBase(searchFilter, new String[0], 2, mainDirContext);
                    SearchResult userResult = null;
                    if (!results.hasMore()) {
                        String errorMsg = "There is no user with the user name: " + string + " to be added to this role.";
                        logger.error((Object)errorMsg);
                        throw new UserStoreException(errorMsg);
                    }
                    userResult = results.next();
                    String userEntryDN = userResult.getNameInNamespace();
                    memberAttribute.add(userEntryDN);
                }
                groupAttributes.put(memberAttribute);
            }
            groupContext = (DirContext)mainDirContext.lookup(this.groupSearchBase);
            NameParser ldapParser = groupContext.getNameParser(EMPTY_ATTRIBUTE_STRING);
            Name compoundGroupName = ldapParser.parse(groupNameAttributeName + "=" + roleName);
            groupContext.bind(compoundGroupName, null, (Attributes)groupAttributes);
            if (userList != null && userList.length > 0) {
                this.clearUserRolesCacheByTenant(this.tenantID);
            }
            if (permissions != null) {
                for (Permission permission : permissions) {
                    String resourceId = permission.getResourceId();
                    String action = permission.getAction();
                    this.userRealm.getAuthorizationManager().authorizeRole(roleName, resourceId, action);
                }
            }
        }
        catch (NamingException e) {
            try {
                String errorMsg = "Role: " + roleName + "could not be added.";
                logger.error((Object)errorMsg, (Throwable)e);
                throw new UserStoreException(errorMsg, e);
                catch (Exception e2) {
                    errorMsg = "Role: " + roleName + "could not be added.";
                    logger.error((Object)errorMsg, (Throwable)e2);
                    throw new UserStoreException(errorMsg, e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(results);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(results);
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        if (!this.readLDAPUserGroups && !this.writeLDAPUserGroups || this.readLDAPUserGroups && !this.writeLDAPUserGroups) {
            super.updateRoleListOfUser(userName, deletedRoles, newRoles);
        }
        if (this.readLDAPUserGroups && this.writeLDAPUserGroups) {
            String userNameDN = this.getNameInSpaceForUserName(userName);
            String membershipAttribute = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            String errorMessage = null;
            String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
            String roleSearchFilter = null;
            DirContext mainDirContext = this.connectionSource.getContext();
            try {
                String groupDN;
                SearchResult resultedGroup;
                NamingEnumeration<SearchResult> groupResults;
                String[] returningAttributes;
                if (deletedRoles != null && deletedRoles.length != 0) {
                    for (String deletedRole : deletedRoles) {
                        roleSearchFilter = searchFilter.replace("?", deletedRole);
                        returningAttributes = new String[]{membershipAttribute};
                        groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext);
                        resultedGroup = null;
                        if (groupResults.hasMore()) {
                            resultedGroup = groupResults.next();
                        }
                        if (resultedGroup != null && this.isOnlyUserInRole(userNameDN, resultedGroup) && !this.emptyRolesAllowed) {
                            errorMessage = userName + " is the only user in the role: " + deletedRole + ". Hence can not delete user from role.";
                            logger.error((Object)errorMessage);
                            throw new UserStoreException(errorMessage);
                        }
                        JNDIUtil.closeNamingEnumeration(groupResults);
                    }
                    for (String deletedRole : deletedRoles) {
                        if (this.isExistingRole(deletedRole)) {
                            roleSearchFilter = searchFilter.replace("?", deletedRole);
                            returningAttributes = new String[]{membershipAttribute};
                            groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext);
                            resultedGroup = null;
                            groupDN = null;
                            if (groupResults.hasMore()) {
                                resultedGroup = groupResults.next();
                                groupDN = resultedGroup.getName();
                            }
                        } else {
                            errorMessage = "The role: " + deletedRole + " does not exist.";
                            logger.error((Object)errorMessage);
                            throw new UserStoreException(errorMessage);
                        }
                        this.modifyUserInRole(userNameDN, groupDN, 3);
                        JNDIUtil.closeNamingEnumeration(groupResults);
                        this.userRealm.getAuthorizationManager().clearUserAuthorization(userName);
                    }
                }
                if (newRoles.length != 0) {
                    for (String newRole : newRoles) {
                        if (this.isExistingRole(newRole)) {
                            roleSearchFilter = searchFilter.replace("?", newRole);
                            returningAttributes = new String[]{membershipAttribute};
                            groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext);
                            resultedGroup = null;
                            groupDN = null;
                            if (groupResults.hasMore()) {
                                resultedGroup = groupResults.next();
                                groupDN = resultedGroup.getName();
                            }
                            if (resultedGroup == null || this.isUserInRole(userNameDN, resultedGroup)) {
                                errorMessage = "User: " + userName + " already belongs to role: " + groupDN;
                                logger.error((Object)errorMessage);
                                throw new UserStoreException(errorMessage);
                            }
                            this.modifyUserInRole(userNameDN, groupDN, 1);
                        } else {
                            errorMessage = "The role: " + newRole + " does not exist.";
                            logger.error((Object)errorMessage);
                            throw new UserStoreException(errorMessage);
                        }
                        JNDIUtil.closeNamingEnumeration(groupResults);
                    }
                }
            }
            catch (NamingException e) {
                errorMessage = "Error occurred while modifying the role list of user: " + userName;
                logger.error((Object)errorMessage);
                throw new UserStoreException(errorMessage);
            }
            finally {
                JNDIUtil.closeContext(mainDirContext);
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        if (!this.readLDAPUserGroups && !this.writeLDAPUserGroups || this.readLDAPUserGroups && !this.writeLDAPUserGroups) {
            super.updateUserListOfRole(roleName, deletedUsers, newUsers);
        }
        if (this.readLDAPUserGroups && this.writeLDAPUserGroups) {
            String errorMessage = null;
            NamingEnumeration<SearchResult> groupSearchResults = null;
            if (!this.isExistingRole(roleName)) {
                errorMessage = "The role: " + roleName + " does not exist.";
                logger.error((Object)errorMessage);
                throw new UserStoreException(errorMessage);
            }
            DirContext mainDirContext = this.connectionSource.getContext();
            try {
                String userNameDN;
                String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
                searchFilter = searchFilter.replace("?", roleName);
                String membershipAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                String[] returningAttributes = new String[]{membershipAttributeName};
                groupSearchResults = this.searchInGroupBase(searchFilter, returningAttributes, 2, mainDirContext);
                SearchResult resultedGroup = null;
                String groupName = null;
                while (groupSearchResults.hasMoreElements()) {
                    resultedGroup = groupSearchResults.next();
                    groupName = resultedGroup.getName();
                }
                Attribute returnedMemberAttribute = resultedGroup.getAttributes().get(membershipAttributeName);
                if (!this.emptyRolesAllowed && newUsers.length - deletedUsers.length + returnedMemberAttribute.size() == 0) {
                    errorMessage = "There should be at least one member in the role. Hence can not delete all the members.";
                    logger.error((Object)errorMessage);
                    throw new UserStoreException(errorMessage);
                }
                if (newUsers.length != 0) {
                    for (String newUser : newUsers) {
                        userNameDN = this.getNameInSpaceForUserName(newUser);
                        if (this.isUserInRole(userNameDN, resultedGroup)) {
                            errorMessage = "User: " + newUser + " already belongs to role: " + roleName;
                            logger.error((Object)errorMessage);
                            throw new UserStoreException(errorMessage);
                        }
                        this.modifyUserInRole(userNameDN, groupName, 1);
                    }
                }
                if (deletedUsers != null && deletedUsers.length != 0) {
                    for (String deletedUser : deletedUsers) {
                        userNameDN = this.getNameInSpaceForUserName(deletedUser);
                        this.modifyUserInRole(userNameDN, groupName, 3);
                        this.userRealm.getAuthorizationManager().clearUserAuthorization(deletedUser);
                    }
                }
            }
            catch (NamingException e) {
                errorMessage = "Error occurred while modifying the user list of role: " + roleName;
                logger.error((Object)errorMessage);
                throw new UserStoreException(errorMessage);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(mainDirContext);
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    @Override
    public boolean isExistingRole(String roleName) throws UserStoreException {
        boolean isExistingRole = false;
        if (this.isInternalRole(roleName) || !this.readLDAPUserGroups && !this.writeLDAPUserGroups) {
            return this.hybridRoleManager.isExistingRole(roleName);
        }
        if (this.readLDAPUserGroups && !this.writeLDAPUserGroups || this.readLDAPUserGroups && this.writeLDAPUserGroups) {
            return super.isExistingRole(roleName);
        }
        return isExistingRole;
    }

    protected void modifyUserInRole(String userNameDN, String groupRDN, int modifyType) throws UserStoreException {
        DirContext mainDirContext = null;
        DirContext groupContext = null;
        try {
            mainDirContext = this.connectionSource.getContext();
            groupContext = (DirContext)mainDirContext.lookup(this.groupSearchBase);
            String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            BasicAttributes modifyingAttributes = new BasicAttributes(true);
            BasicAttribute memberAttribute = new BasicAttribute(memberAttributeName);
            memberAttribute.add(userNameDN);
            modifyingAttributes.put(memberAttribute);
            groupContext.modifyAttributes(groupRDN, modifyType, (Attributes)modifyingAttributes);
            if (log.isDebugEnabled()) {
                logger.debug((Object)("Member attribute value: " + userNameDN + " was successfully " + "modified in LDAP group: " + groupRDN));
            }
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while modifying user entry: " + userNameDN + " in LDAP role: " + groupRDN;
                logger.error((Object)errorMessage, (Throwable)e);
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    protected boolean isUserInRole(String userDN, SearchResult groupEntry) throws UserStoreException {
        boolean isUserInRole = false;
        try {
            Attributes groupAttributes = groupEntry.getAttributes();
            if (groupAttributes != null) {
                NamingEnumeration<? extends Attribute> attributes = groupAttributes.getAll();
                while (attributes.hasMoreElements()) {
                    Attribute memberAttribute = attributes.next();
                    String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                    if (!memberAttributeName.equals(memberAttribute.getID())) continue;
                    for (int i = 0; i < memberAttribute.size(); ++i) {
                        if (!userDN.equals(memberAttribute.get(i))) continue;
                        return true;
                    }
                }
                attributes.close();
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while looping through attributes set of group: " + groupEntry.getNameInNamespace();
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        return isUserInRole;
    }

    protected boolean isOnlyUserInRole(String userDN, SearchResult groupEntry) throws UserStoreException {
        boolean isOnlyUserInRole = false;
        try {
            Attributes groupAttributes = groupEntry.getAttributes();
            if (groupAttributes != null) {
                NamingEnumeration<? extends Attribute> attributes = groupAttributes.getAll();
                while (attributes.hasMoreElements()) {
                    String attributeID;
                    Attribute memberAttribute = attributes.next();
                    String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                    if (!memberAttributeName.equals(attributeID = memberAttribute.getID()) || memberAttribute.size() != 1 || !userDN.equals(memberAttribute.get())) continue;
                    return true;
                }
                attributes.close();
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while looping through attributes set of group: " + groupEntry.getNameInNamespace();
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        return isOnlyUserInRole;
    }

    @Override
    public void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        if (!this.readLDAPUserGroups && !this.writeLDAPUserGroups || this.readLDAPUserGroups && !this.writeLDAPUserGroups) {
            super.updateRoleName(roleName, newRoleName);
        }
        if (this.readLDAPUserGroups && this.writeLDAPUserGroups) {
            if (this.realmConfig.getAdminRoleName().equals(roleName)) {
                throw new UserStoreException("Cannot rename admin role");
            }
            if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
                throw new UserStoreException("Cannot rename everyone role");
            }
            if (this.isExistingRole(newRoleName)) {
                throw new UserStoreException("Duplicate role name in the system. Please pick another name");
            }
            if (!this.isExistingRole(newRoleName)) {
                DirContext mainContext = this.connectionSource.getContext();
                DirContext groupContext = null;
                NamingEnumeration<SearchResult> groupSearchResults = null;
                try {
                    String groupSearchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
                    groupSearchFilter = groupSearchFilter.replace("?", roleName);
                    String roleNameAttributeName = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                    String[] returningAttributes = new String[]{roleNameAttributeName};
                    groupSearchResults = this.searchInGroupBase(groupSearchFilter, returningAttributes, 2, mainContext);
                    SearchResult resultedGroup = null;
                    while (groupSearchResults.hasMoreElements()) {
                        resultedGroup = groupSearchResults.next();
                    }
                    if (resultedGroup == null) {
                        throw new UserStoreException("Could not find user role " + roleName + " in LDAP server.");
                    }
                    String groupNameRDN = resultedGroup.getName();
                    String newGroupNameRDN = roleNameAttributeName + "=" + newRoleName;
                    groupContext = (DirContext)mainContext.lookup(this.groupSearchBase);
                    groupContext.rename(groupNameRDN, newGroupNameRDN);
                    this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
                }
                catch (NamingException e) {
                    try {
                        String errorMessage = "Error occurred while modifying the name of role: " + roleName;
                        logger.error((Object)errorMessage, (Throwable)e);
                        throw new UserStoreException(errorMessage, e);
                    }
                    catch (Throwable throwable) {
                        JNDIUtil.closeNamingEnumeration(groupSearchResults);
                        JNDIUtil.closeContext(groupContext);
                        JNDIUtil.closeContext(mainContext);
                        throw throwable;
                    }
                }
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainContext);
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    @Override
    public void deleteRole(String roleName) throws UserStoreException {
        block10: {
            block11: {
                if (!this.readLDAPUserGroups && !this.writeLDAPUserGroups || this.readLDAPUserGroups && !this.writeLDAPUserGroups) {
                    super.deleteRole(roleName);
                }
                if (!this.readLDAPUserGroups || !this.writeLDAPUserGroups) break block10;
                if (this.realmConfig.getAdminRoleName().equals(roleName)) {
                    throw new UserStoreException("Cannot delete admin role.");
                }
                if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
                    throw new UserStoreException("Cannot delete everyone role.");
                }
                if (!this.isExistingRole(roleName)) break block11;
                DirContext mainDirContext = null;
                DirContext groupContext = null;
                NamingEnumeration<SearchResult> groupSearchResults = null;
                try {
                    String groupSearchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
                    groupSearchFilter = groupSearchFilter.replace("?", roleName);
                    String[] returningAttributes = new String[]{this.realmConfig.getUserStoreProperty("GroupNameAttribute")};
                    mainDirContext = this.connectionSource.getContext();
                    groupSearchResults = this.searchInGroupBase(groupSearchFilter, returningAttributes, 2, mainDirContext);
                    SearchResult resultedGroup = null;
                    while (groupSearchResults.hasMoreElements()) {
                        resultedGroup = groupSearchResults.next();
                    }
                    if (resultedGroup == null) {
                        throw new UserStoreException("Could not find specified group/role - " + roleName);
                    }
                    String groupName = resultedGroup.getName();
                    groupContext = (DirContext)mainDirContext.lookup(this.groupSearchBase);
                    String groupNameAttributeValue = (String)resultedGroup.getAttributes().get(this.realmConfig.getUserStoreProperty("GroupNameAttribute")).get();
                    if (groupNameAttributeValue.equals(roleName)) {
                        groupContext.destroySubcontext(groupName);
                    }
                    this.userRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
                }
                catch (NamingException e) {
                    try {
                        String errorMessage = "Error occurred while deleting the role: " + roleName;
                        logger.error((Object)errorMessage, (Throwable)e);
                        throw new UserStoreException(errorMessage, e);
                    }
                    catch (Throwable throwable) {
                        JNDIUtil.closeNamingEnumeration(groupSearchResults);
                        JNDIUtil.closeContext(groupContext);
                        JNDIUtil.closeContext(mainDirContext);
                        throw throwable;
                    }
                }
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                break block10;
            }
            String errorMessage = "Role name: " + roleName + " does not exist in group base.";
            logger.error((Object)errorMessage);
            throw new UserStoreException(errorMessage);
        }
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    private NamingEnumeration<SearchResult> searchInUserBase(String searchFilter, String[] returningAttributes, int searchScope, DirContext rootContext) throws UserStoreException {
        String userBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        SearchControls userSearchControl = new SearchControls();
        userSearchControl.setReturningAttributes(returningAttributes);
        userSearchControl.setSearchScope(searchScope);
        NamingEnumeration<SearchResult> userSearchResults = null;
        try {
            userSearchResults = rootContext.search(userBase, searchFilter, userSearchControl);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while searching in user base.";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        return userSearchResults;
    }

    private NamingEnumeration<SearchResult> searchInGroupBase(String searchFilter, String[] returningAttributes, int searchScope, DirContext rootContext) throws UserStoreException {
        String userBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
        SearchControls userSearchControl = new SearchControls();
        userSearchControl.setReturningAttributes(returningAttributes);
        userSearchControl.setSearchScope(searchScope);
        NamingEnumeration<SearchResult> groupSearchResults = null;
        try {
            groupSearchResults = rootContext.search(userBase, searchFilter, userSearchControl);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while searching in group base.";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        return groupSearchResults;
    }

    @Override
    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        super.checkRequiredUserStoreConfigurations();
        String passwordHashMethod = this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD);
        if (passwordHashMethod == null || passwordHashMethod.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required PasswordHashMethod property is not set at the LDAP configurations");
        }
        String userObjectClass = this.realmConfig.getUserStoreProperty("UserEntryObjectClass");
        if (userObjectClass == null || userObjectClass.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required UserEntryObjectClass property is not set at the LDAP configurations");
        }
        String userNameSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        if (userNameSearchFilter == null || userNameSearchFilter.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required  UserNameSearchFilter property is not set at the LDAP configurations");
        }
        String usernameJavaRegEx = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
        if (usernameJavaRegEx == null || usernameJavaRegEx.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required UserNameJavaRegEx property is not set at the LDAP configurations");
        }
        String usernameJSRegEx = this.realmConfig.getUserStoreProperty("UsernameJavaScriptRegEx");
        if (usernameJSRegEx == null || usernameJSRegEx.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required UserNameJavaScriptRegEx property is not set at the LDAP configurations");
        }
        String passwordJSRegEx = this.realmConfig.getUserStoreProperty("PasswordJavaScriptRegEx");
        if (passwordJSRegEx == null || passwordJSRegEx.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required PasswordJavaScriptRegEx property is not set at the LDAP configurations");
        }
        String roleNameJavaRegEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
        if (roleNameJavaRegEx == null || roleNameJavaRegEx.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required RoleNameJavaRegEx property is not set at the LDAP configurations");
        }
        String roleNameJSRegEx = this.realmConfig.getUserStoreProperty("RolenameJavaScriptRegEx");
        if (roleNameJSRegEx == null || roleNameJSRegEx.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required RoleNameJavaScriptRegEx property is not set at the LDAP configurations");
        }
        String configWriteLdapGroups = this.realmConfig.getUserStoreProperty("WriteLDAPGroups");
        if (configWriteLdapGroups == null || configWriteLdapGroups.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required WriteLDAPGroups property is not set at the LDAP configurations");
        }
        this.writeLDAPUserGroups = Boolean.parseBoolean(configWriteLdapGroups);
        if (!this.readLDAPUserGroups && this.writeLDAPUserGroups) {
            throw new UserStoreException("Wrong combination for LDAP groups read-write properties.");
        }
        String configEmptyRolesAllowed = this.realmConfig.getUserStoreProperty("EmptyRolesAllowed");
        if ("true".equals(configEmptyRolesAllowed)) {
            this.emptyRolesAllowed = true;
        } else if ("false".equals(configEmptyRolesAllowed)) {
            this.emptyRolesAllowed = false;
        } else {
            throw new UserStoreException("Invalid value specified for user store manager configuration EmptyRolesAllowed . Allowed values are true or false");
        }
        String groupEntryObjectClass = this.realmConfig.getUserStoreProperty("GroupEntryObjectClass");
        if (groupEntryObjectClass == null || groupEntryObjectClass.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required GroupEntryObjectClass property is not set at the LDAP configurations");
        }
        String groupNameSearchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
        if (groupNameSearchFilter == null || groupNameSearchFilter.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required GroupNameSearchFilter property is not set at the LDAP configurations");
        }
        this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        this.groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
    }

    protected boolean isInternalRole(String roleName) {
        return roleName.equals(this.realmConfig.getEveryOneRoleName());
    }

    private void addInitialData() throws UserStoreException {
        if (this.realmConfig.getAdminUserName() == null || this.realmConfig.getAdminRoleName() == null) {
            String error = "Admin user name or role name is not valid. Please provide valid values.";
            log.error((Object)error);
            throw new UserStoreException(error);
        }
        if (isFirstStartup) {
            if (!this.isExistingUser(this.realmConfig.getAdminUserName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Admin user is not existing in the LDAP. Hence creating the user entry in LDAP.");
                }
                this.doAddUser(this.realmConfig.getAdminUserName(), this.realmConfig.getAdminPassword(), null, null, null);
            }
            if (!this.isExistingRole(this.realmConfig.getAdminRoleName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Admin role is not exisitng in the LDAP. Hence creating the group entry in LDAP.");
                }
                this.addRole(this.realmConfig.getAdminRoleName(), new String[]{this.realmConfig.getAdminUserName()}, (Permission[])null);
            }
            if (!this.isExistingUser("wso2.anonymous.user")) {
                byte[] password = new byte[12];
                this.random.nextBytes(password);
                this.doAddUser("wso2.anonymous.user", Base64Utils.encode((byte[])password), null, null, null);
            }
            if (!this.isExistingRole("wso2.anonymous.role")) {
                if (this.writeLDAPUserGroups) {
                    this.addRole("wso2.anonymous.role", new String[]{"wso2.anonymous.user"}, (Permission[])null);
                } else {
                    super.addRole("wso2.anonymous.role", new String[]{"wso2.anonymous.user"}, (Permission[])null);
                }
            }
        } else {
            if (!this.isExistingUser(this.realmConfig.getAdminUserName())) {
                String error = "Initial data has been changed after first start up. AdminUser isnot existing.";
                log.error((Object)error);
                throw new UserStoreException(error);
            }
            if (!this.isExistingRole(this.realmConfig.getAdminRoleName())) {
                String error = "Initial data has been changed after first start up. AdminRole is not existing.";
                log.error((Object)error);
                throw new UserStoreException(error);
            }
            if (!this.isExistingUser("wso2.anonymous.user")) {
                String error = "Initial data has been changed after first start up. Registry Anonymous User is not existing.";
                log.error((Object)error);
                throw new UserStoreException(error);
            }
            if (!this.isExistingRole("wso2.anonymous.role")) {
                String error = "Initial data has been changed after first start up. Registry Anonymous Role is not existing.";
                log.error((Object)error);
                throw new UserStoreException(error);
            }
        }
    }
}

