/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.jdbc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JDBCRealmUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class JDBCUserStoreManager
extends AbstractUserStoreManager {
    protected DataSource jdbcDataSource = null;
    protected UserRealm jdbcUserRealm = null;
    protected int tenantId;
    protected boolean useOnlyInternalRoles;
    protected Random random = new Random();
    private static Log log = LogFactory.getLog(JDBCUserStoreManager.class);

    public JDBCUserStoreManager(RealmConfiguration realmConfig, int tenantId) {
        this.realmConfig = realmConfig;
        this.tenantId = tenantId;
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        if ("true".equals(realmConfig.getUserStoreProperty("InternalJDBCRolesOnly"))) {
            this.useOnlyInternalRoles = true;
        }
        this.initUserRolesCache();
    }

    public JDBCUserStoreManager(DataSource ds, RealmConfiguration realmConfig, int tenantId, boolean addInitData) throws UserStoreException {
        this(realmConfig, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        if ("true".equals(realmConfig.getUserStoreProperty("InternalJDBCRolesOnly"))) {
            this.useOnlyInternalRoles = true;
        }
        this.jdbcDataSource = ds;
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("User Management Data Source is null");
        }
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, tenantId, realmConfig, this.jdbcUserRealm);
        if (addInitData) {
            this.addInitialData();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended " + System.currentTimeMillis()));
        }
    }

    public JDBCUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        this(realmConfig, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        this.claimManager = claimManager;
        this.profileManager = profileManager;
        this.jdbcUserRealm = realm;
        if ("true".equals(realmConfig.getUserStoreProperty("InternalJDBCRolesOnly"))) {
            this.useOnlyInternalRoles = true;
        }
        this.jdbcDataSource = this.loadUserStoreSpacificDataSoruce();
        if (this.jdbcDataSource == null) {
            this.jdbcDataSource = (DataSource)properties.get("um.datasource");
        }
        if (this.jdbcDataSource == null) {
            this.jdbcDataSource = DatabaseUtil.getRealmDataSource(realmConfig);
            properties.put("um.datasource", this.jdbcDataSource);
        }
        if (this.jdbcDataSource == null) {
            throw new UserStoreException("User Store Data Source is null");
        }
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("User Management Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The jdbcDataSource being used by JDBCUserStoreManager :: " + this.jdbcDataSource.hashCode()));
        }
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, tenantId, realmConfig, this.jdbcUserRealm);
        this.addInitialData();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended " + System.currentTimeMillis()));
        }
        this.initUserRolesCache();
    }

    @Override
    public boolean isExistingUser(String userName) throws UserStoreException {
        if ("wso2.system.user".equals(userName)) {
            return true;
        }
        return this.checkExistingUserName(userName);
    }

    @Override
    public String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        String[] users = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        if (maxItemLimit == 0) {
            return new String[0];
        }
        int givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace("*", "%");
                filter = filter.replace("?", "_");
            } else {
                filter = "%";
            }
            int i = 0;
            LinkedList<String> lst = new LinkedList<String>();
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            dbConnection.setAutoCommit(false);
            dbConnection.setTransactionIsolation(2);
            sqlStmt = this.realmConfig.getUserStoreProperty("UserFilterSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next() && i < maxItemLimit) {
                String name = rs.getString(1);
                if ("wso2.anonymous.user".equals(name)) continue;
                lst.add(name);
                ++i;
            }
            rs.close();
            if (lst.size() > 0) {
                users = lst.toArray(new String[lst.size()]);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return users;
    }

    @Override
    public String[] getRoleNames() throws UserStoreException {
        String[] names = null;
        if (this.useOnlyInternalRoles) {
            String[] hybrids = this.hybridRoleManager.getHybridRoles();
            names = UserCoreUtil.combineArrays(names, hybrids);
            return names;
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetRoleListSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving role name is null");
        }
        names = this.getStringValuesFromDatabase(sqlStmt, this.tenantId);
        if (this.isReadOnly()) {
            String[] hybrids = this.hybridRoleManager.getHybridRoles();
            names = UserCoreUtil.combineArrays(names, hybrids);
        }
        return names;
    }

    @Override
    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        String[] names = null;
        try {
            names = this.getRoleListOfUserFromCache(this.tenantId, userName);
            if (names != null) {
                return names;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.useOnlyInternalRoles) {
            String[] hybrids = this.hybridRoleManager.getHybridRoleListOfUser(userName);
            names = UserCoreUtil.combineArrays(names, hybrids);
        } else {
            String sqlStmt = this.realmConfig.getUserStoreProperty("UserRoleSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for retrieving user roles is null");
            }
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userName, this.tenantId, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userName);
            if (this.isReadOnly()) {
                String[] hybrids = this.hybridRoleManager.getHybridRoleListOfUser(userName);
                names = UserCoreUtil.combineArrays(names, hybrids);
            }
        }
        this.addToUserRolesCache(this.tenantId, userName, names);
        return names;
    }

    public boolean isUserInRole(String username, String roleName) throws UserStoreException {
        boolean hasRole = false;
        return hasRole;
    }

    @Override
    public String[] getUserListOfRole(String roleName) throws UserStoreException {
        String[] names;
        if (this.useOnlyInternalRoles && this.hybridRoleManager.isExistingRole(roleName)) {
            names = this.hybridRoleManager.getUserListOfHybridRole(roleName);
        } else if (this.isReadOnly() && this.hybridRoleManager.isExistingRole(roleName)) {
            names = this.hybridRoleManager.getUserListOfHybridRole(roleName);
        } else {
            String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserListOfRoleSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for retrieving user roles is null");
            }
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, roleName, this.tenantId, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, roleName);
        }
        return names;
    }

    @Override
    public boolean isExistingRole(String roleName) throws UserStoreException {
        boolean isExisting = false;
        if (this.useOnlyInternalRoles) {
            isExisting = this.hybridRoleManager.isExistingRole(roleName);
        } else {
            String sqlStmt = this.realmConfig.getUserStoreProperty("IsRoleExistingSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for is role existing role null");
            }
            isExisting = sqlStmt.contains("UM_TENANT_ID") ? this.isValueExisting(sqlStmt, null, roleName, this.tenantId) : this.isValueExisting(sqlStmt, null, roleName);
            if (!isExisting && this.isReadOnly()) {
                isExisting = this.hybridRoleManager.isExistingRole(roleName);
            }
        }
        return isExisting;
    }

    @Override
    public String[] getAllProfileNames() throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetProfileNamesSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving profile names is null");
        }
        String[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, new Object[0]);
        return names;
    }

    @Override
    public String[] getProfileNames(String userName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserProfileNamesSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving  is null");
        }
        Object[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userName, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userName);
        if (names.length == 0) {
            names = new String[]{"default"};
        } else {
            Arrays.sort(names);
            if (Arrays.binarySearch(names, "default") < 0) {
                String[] newNames = new String[names.length + 1];
                int i = 0;
                for (i = 0; i < names.length; ++i) {
                    newNames[i] = names[i];
                }
                newNames[i] = "default";
                names = newNames;
            }
        }
        return names;
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserIDFromUserNameSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving ID is null");
        }
        int id = -1;
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            id = sqlStmt.contains("UM_TENANT_ID") ? DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username, this.tenantId) : DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return id;
    }

    public String[] getUserNames(int tenantId) throws UserStoreException {
        String[] userNames;
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserNameFromTenantIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving user names is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            userNames = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, tenantId);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return userNames;
    }

    public String getAdminUser() throws UserStoreException {
        String[] users = this.getUserListOfRole(this.realmConfig.getAdminRoleName());
        if (users != null && users.length > 0) {
            return users[0];
        }
        return null;
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    public Map<String, String> getProperties(Tenant tenant) throws org.wso2.carbon.user.api.UserStoreException {
        return this.getProperties((org.wso2.carbon.user.core.tenant.Tenant)tenant);
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        if (this.tenantId != -1234) {
            throw new UserStoreException("Not allowed to perform this operation");
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetTenantIDFromUserNameSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving ID is null");
        }
        int id = -1;
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            id = DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return id;
    }

    @Override
    public Map<String, String> getUserPropertyValues(String userName, String[] propertyNames, String profileName) throws UserStoreException {
        Object name;
        if (profileName == null) {
            profileName = "default";
        }
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Object[] propertyNamesSorted = (String[])propertyNames.clone();
        Arrays.sort(propertyNamesSorted);
        HashMap<Object, String> map = new HashMap<Object, String>();
        try {
            dbConnection = this.getDBConnection();
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserPropertiesForProfileSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userName);
            prepStmt.setString(2, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(3, this.tenantId);
                prepStmt.setInt(4, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                name = rs.getString(1);
                String value = rs.getString(2);
                if (Arrays.binarySearch(propertyNamesSorted, name) < 0) continue;
                map.put(name, value);
            }
            name = map;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return name;
    }

    private String[] getStringValuesFromDatabase(String sqlStmt, Object ... params) throws UserStoreException {
        String[] values = new String[]{};
        Connection dbConnection = null;
        Object prepStmt = null;
        ResultSet rs = null;
        try {
            dbConnection = this.getDBConnection();
            values = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, params);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return values;
    }

    protected Connection getDBConnection() throws SQLException {
        Connection dbConnection = this.jdbcDataSource.getConnection();
        dbConnection.setAutoCommit(false);
        dbConnection.setTransactionIsolation(2);
        return dbConnection;
    }

    private boolean isValueExisting(String sqlStmt, Connection dbConnection, Object ... params) throws UserStoreException {
        boolean bl;
        block7: {
            Object prepStmt = null;
            ResultSet rs = null;
            boolean isExisting = false;
            boolean doClose = false;
            try {
                if (dbConnection == null) {
                    dbConnection = this.getDBConnection();
                    doClose = true;
                }
                if (DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, params) > -1) {
                    isExisting = true;
                }
                bl = isExisting;
                if (!doClose) break block7;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.error((Object)("Using sql : " + sqlStmt));
                    throw new UserStoreException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (doClose) {
                        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    }
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        }
        return bl;
    }

    protected boolean checkExistingUserName(String userName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("IsUserExistingSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for is user existing null");
        }
        boolean isExisting = false;
        String isUnique = this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenants");
        if ("true".equals(isUnique) && !"wso2.anonymous.user".equals(userName)) {
            String uniquenesSql = this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenantsSQL");
            isExisting = this.isValueExisting(uniquenesSql, null, userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)"The username should be unique across tenants.");
            }
        } else {
            isExisting = sqlStmt.contains("UM_TENANT_ID") ? this.isValueExisting(sqlStmt, null, userName, this.tenantId) : this.isValueExisting(sqlStmt, null, userName);
        }
        return isExisting;
    }

    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        boolean isAuthed;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block14: {
            if (!this.checkUserNameValid(userName)) {
                return false;
            }
            if (!this.checkUserPasswordValid(credential)) {
                return false;
            }
            if ("wso2.anonymous.user".equals(userName)) {
                log.error((Object)"Anonnymous user trying to login");
                return false;
            }
            dbConnection = null;
            rs = null;
            prepStmt = null;
            String sqlstmt = null;
            String password = (String)credential;
            isAuthed = false;
            try {
                dbConnection = this.getDBConnection();
                dbConnection.setAutoCommit(false);
                sqlstmt = this.realmConfig.getUserStoreProperty("SelectUserSQL");
                if (log.isDebugEnabled()) {
                    log.debug((Object)sqlstmt);
                }
                prepStmt = dbConnection.prepareStatement(sqlstmt);
                prepStmt.setString(1, userName);
                if (sqlstmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(2, this.tenantId);
                }
                if (!(rs = prepStmt.executeQuery()).next()) break block14;
                String storedPassword = rs.getString(3);
                String saltValue = null;
                if ("true".equals(this.realmConfig.getUserStoreProperty("StoreSaltedPassword"))) {
                    saltValue = rs.getString(4);
                }
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                GregorianCalendar gc = new GregorianCalendar();
                gc.add(10, -24);
                Date date = gc.getTime();
                if (requireChange && changedTime.before(date)) {
                    isAuthed = false;
                } else {
                    password = this.preparePassword(password, saltValue);
                    if (storedPassword != null && storedPassword.equals(password)) {
                        isAuthed = true;
                    }
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.error((Object)("Using sql : " + sqlstmt));
                    throw new UserStoreException("Authentication Failure");
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User " + userName + " login attempt. Login success :: " + isAuthed));
        }
        return isAuthed;
    }

    @Override
    public boolean isReadOnly() throws UserStoreException {
        return "true".equals(this.realmConfig.getUserStoreProperty("ReadOnly"));
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.doAddUser(userName, credential, roleList, claims, profileName, false);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.persistUser(userName, credential, roleList, claims, profileName, requirePasswordChange);
    }

    protected void persistUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        if (!this.checkUserNameValid(userName)) {
            throw new UserStoreException("Username not valid. User name must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("UsernameJavaRegEx"));
        }
        if (!this.checkUserPasswordValid(credential)) {
            throw new UserStoreException("Credential not valid. Credential must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("PasswordJavaRegEx"));
        }
        boolean isExisting = this.checkExistingUserName(userName);
        if (isExisting) {
            throw new UserStoreException("Username '" + userName + "' already exists in the system. Please pick another username.");
        }
        Connection dbConnection = null;
        String password = (String)credential;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt1 = this.realmConfig.getUserStoreProperty("AddUserSQL");
            String saltValue = null;
            if ("true".equals(this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
                byte[] bytes = new byte[16];
                this.random.nextBytes(bytes);
                saltValue = Base64.encode((byte[])bytes);
            }
            password = this.preparePassword(password, saltValue);
            if (sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, "", requirePasswordChange, new Date(), this.tenantId);
            } else if (sqlStmt1.contains("UM_TENANT_ID") && saltValue != null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, saltValue, requirePasswordChange, new Date(), this.tenantId);
            } else if (!sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, null, requirePasswordChange, new Date());
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, requirePasswordChange, new Date());
            }
            String[] roles = null;
            if ("wso2.anonymous.user".equals(userName)) {
                roles = new String[]{};
            } else if (roleList == null || roleList.length == 0) {
                roles = new String[]{this.realmConfig.getEveryOneRoleName()};
            } else {
                Arrays.sort(roleList);
                if (Arrays.binarySearch(roleList, this.realmConfig.getEveryOneRoleName()) < 0) {
                    roles = new String[roleList.length + 1];
                    int i = 0;
                    for (i = 0; i < roleList.length; ++i) {
                        roles[i] = roleList[i];
                    }
                    roles[i] = this.realmConfig.getEveryOneRoleName();
                } else {
                    roles = roleList;
                }
            }
            String sqlStmt2 = null;
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserSQL-" + type);
            if (sqlStmt2 == null) {
                sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserSQL");
            }
            if (sqlStmt2.contains("UM_TENANT_ID")) {
                if ("openedge".equals(type)) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, roles, this.tenantId, userName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userName, this.tenantId, this.tenantId);
                }
            } else {
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userName);
            }
            if (claims != null) {
                if (profileName == null) {
                    profileName = "default";
                }
                for (Map.Entry<String, String> entry : claims.entrySet()) {
                    String claimURI = entry.getKey();
                    String propName = this.claimManager.getAttributeName(claimURI);
                    String propValue = entry.getValue();
                    this.addProperty(dbConnection, userName, propName, propValue, profileName);
                }
            }
            dbConnection.commit();
        }
        catch (Throwable e) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                log.error((Object)e.getMessage(), (Throwable)e1);
                throw new UserStoreException(e.getMessage(), e1);
            }
            log.error((Object)e.getMessage(), e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        Connection dbConnection = null;
        try {
            if (!this.roleNameValid(roleName)) {
                throw new UserStoreException("Role name not valid. Role name must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("RolenameJavaRegEx"));
            }
            if (this.isExistingRole(roleName)) {
                throw new UserStoreException("Role name: " + roleName + " in the system. Please pick another role name.");
            }
            dbConnection = this.getDBConnection();
            if (this.useOnlyInternalRoles) {
                this.hybridRoleManager.addHybridRole(roleName, userList);
            } else if (this.isReadOnly()) {
                this.hybridRoleManager.addHybridRole(roleName, userList);
            } else {
                String sqlStmt = this.realmConfig.getUserStoreProperty("AddRoleSQL");
                if (sqlStmt.contains("UM_TENANT_ID")) {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName, this.tenantId);
                } else {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName);
                }
                if (userList != null) {
                    String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                    String sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL-" + type);
                    if (sqlStmt2 == null) {
                        sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL");
                    }
                    if (sqlStmt2.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, userList, this.tenantId, roleName, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userList, this.tenantId, roleName, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userList, this.tenantId, roleName);
                    }
                }
            }
            if (permissions != null) {
                for (Permission permission : permissions) {
                    String resourceId = permission.getResourceId();
                    String action = permission.getAction();
                    this.jdbcUserRealm.getAuthorizationManager().authorizeRole(roleName, resourceId, action);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new UserStoreException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        if (userList != null && userList.length > 0) {
            this.clearUserRolesCacheByTenant(this.tenantId);
        }
    }

    @Override
    public void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        if (this.useOnlyInternalRoles) {
            this.hybridRoleManager.updateHybridRoleName(roleName, newRoleName);
        } else if (this.isReadOnly()) {
            this.hybridRoleManager.updateHybridRoleName(roleName, newRoleName);
        } else {
            if (this.realmConfig.getAdminRoleName().equals(roleName)) {
                throw new UserStoreException("Cannot delete admin role");
            }
            if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
                throw new UserStoreException("Cannot delete everyone role");
            }
            if (this.isExistingRole(newRoleName)) {
                throw new UserStoreException("Role name: " + newRoleName + " in the system. Please pick another role name.");
            }
            String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateRoleNameSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for update role name is null");
            }
            Connection dbConnection = null;
            try {
                dbConnection = this.getDBConnection();
                if (sqlStmt.contains("UM_TENANT_ID")) {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId);
                } else {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, newRoleName, roleName);
                }
                dbConnection.commit();
                this.jdbcUserRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
    }

    @Override
    public boolean isBulkImportSupported() {
        return true;
    }

    public boolean isMultipleProfilesAllowed() {
        return true;
    }

    @Override
    public void deleteRole(String roleName) throws UserStoreException {
        if (this.useOnlyInternalRoles && this.hybridRoleManager.isExistingRole(roleName)) {
            this.hybridRoleManager.deleteHybridRole(roleName);
        } else if (this.isReadOnly() && this.hybridRoleManager.isExistingRole(roleName)) {
            this.hybridRoleManager.deleteHybridRole(roleName);
        } else {
            if (this.realmConfig.getAdminRoleName().equals(roleName)) {
                throw new UserStoreException("Cannot delete admin role");
            }
            if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
                throw new UserStoreException("Cannot delete everyone role");
            }
            String sqlStmt1 = this.realmConfig.getUserStoreProperty("OnDeleteRoleRemoveUserRoleMappingSQL");
            if (sqlStmt1 == null) {
                throw new UserStoreException("The sql statement for delete user-role mapping is null");
            }
            String sqlStmt2 = this.realmConfig.getUserStoreProperty("DeleteRoleSQL");
            if (sqlStmt2 == null) {
                throw new UserStoreException("The sql statement for delete role is null");
            }
            Connection dbConnection = null;
            try {
                dbConnection = this.getDBConnection();
                if (sqlStmt1.contains("UM_TENANT_ID")) {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt1, roleName, this.tenantId, this.tenantId);
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt2, roleName, this.tenantId);
                } else {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt1, roleName);
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt2, roleName);
                }
                this.jdbcUserRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
                dbConnection.commit();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt1));
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        String sqlStmt1 = this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserRoleMappingSQL");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for delete user-role mapping is null");
        }
        String sqlStmt2 = this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserAttributeSQL");
        if (sqlStmt2 == null) {
            throw new UserStoreException("The sql statement for delete user attribute is null");
        }
        String sqlStmt3 = this.realmConfig.getUserStoreProperty("DeleteUserSQL");
        if (sqlStmt3 == null) {
            throw new UserStoreException("The sql statement for delete user is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt1.contains("UM_TENANT_ID")) {
                if (this.useOnlyInternalRoles) {
                    this.hybridRoleManager.updateHybridRoleListOfUser(userName, this.getRoleNames(), null);
                } else {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, this.tenantId, this.tenantId);
                }
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userName, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userName, this.tenantId);
            } else {
                if (this.useOnlyInternalRoles) {
                    this.hybridRoleManager.updateHybridRoleListOfUser(userName, this.getRoleNames(), null);
                } else {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName);
                }
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userName);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userName);
            }
            this.jdbcUserRealm.getAuthorizationManager().clearUserAuthorization(userName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.error((Object)("Using sql : " + sqlStmt1 + " :: " + sqlStmt2));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws org.wso2.carbon.user.api.UserStoreException {
        this.addRole(roleName, userList, (Permission[])permissions);
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        if (this.useOnlyInternalRoles && this.hybridRoleManager.isExistingRole(roleName)) {
            this.hybridRoleManager.updateUserListOfHybridRole(roleName, deletedUsers, newUsers);
        } else if (this.isReadOnly() && this.hybridRoleManager.isExistingRole(roleName)) {
            this.hybridRoleManager.updateUserListOfHybridRole(roleName, deletedUsers, newUsers);
        } else {
            String sqlStmt1 = this.realmConfig.getUserStoreProperty("RemoveUserFromRoleSQL");
            if (sqlStmt1 == null) {
                throw new UserStoreException("The sql statement for remove user from role is null");
            }
            Connection dbConnection = null;
            try {
                dbConnection = this.getDBConnection();
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                String sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL");
                }
                if (sqlStmt2 == null) {
                    throw new UserStoreException("The sql statement for add user to role is null");
                }
                if (deletedUsers != null) {
                    if (sqlStmt1.contains("UM_TENANT_ID")) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, this.tenantId, roleName, this.tenantId, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, this.tenantId, roleName);
                    }
                    if (deletedUsers.length > 0) {
                        for (String deletedUser : deletedUsers) {
                            this.jdbcUserRealm.getAuthorizationManager().clearUserAuthorization(deletedUser);
                        }
                    }
                }
                if (newUsers != null) {
                    if (sqlStmt1.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, newUsers, this.tenantId, roleName, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, this.tenantId, roleName, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, this.tenantId, roleName);
                    }
                }
                dbConnection.commit();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        if (this.useOnlyInternalRoles) {
            this.hybridRoleManager.updateHybridRoleListOfUser(userName, deletedRoles, newRoles);
        } else if (this.isReadOnly()) {
            this.hybridRoleManager.updateHybridRoleListOfUser(userName, deletedRoles, newRoles);
        } else {
            String sqlStmt1 = this.realmConfig.getUserStoreProperty("RemoveRoleFromUserSQL");
            if (sqlStmt1 == null) {
                throw new UserStoreException("The sql statement for remove user from role is null");
            }
            Connection dbConnection = null;
            try {
                dbConnection = this.getDBConnection();
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                String sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserSQL-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserSQL");
                }
                if (sqlStmt2 == null) {
                    throw new UserStoreException("The sql statement for add user to role is null");
                }
                if (deletedRoles != null) {
                    if (sqlStmt1.contains("UM_TENANT_ID")) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedRoles, this.tenantId, userName, this.tenantId, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedRoles, this.tenantId, userName);
                    }
                }
                if (newRoles != null) {
                    if (sqlStmt1.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, newRoles, this.tenantId, userName, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newRoles, this.tenantId, userName, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newRoles, this.tenantId, userName);
                    }
                }
                dbConnection.commit();
                if (deletedRoles != null && deletedRoles.length > 0) {
                    this.jdbcUserRealm.getAuthorizationManager().clearUserAuthorization(userName);
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
    }

    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        if (claimValue == null) {
            throw new UserStoreException("Cannot set null values.");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            ClaimMapping cMapping = (ClaimMapping)this.claimManager.getClaimMapping(claimURI);
            String property = cMapping != null ? cMapping.getMappedAttribute() : claimURI;
            String value = this.getProperty(dbConnection, userName, property, profileName);
            if (value == null) {
                this.addProperty(dbConnection, userName, property, claimValue, profileName);
            } else {
                this.updateProperty(dbConnection, userName, property, claimValue, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        if (claims.get("profileConfiguration") == null) {
            claims.put("profileConfiguration", "default");
        }
        try {
            dbConnection = this.getDBConnection();
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                String claimURI = entry.getKey();
                ClaimMapping cMapping = (ClaimMapping)this.claimManager.getClaimMapping(claimURI);
                String property = null;
                property = cMapping != null ? cMapping.getMappedAttribute() : claimURI;
                String value = entry.getValue();
                String existingValue = this.getProperty(dbConnection, userName, property, profileName);
                if (existingValue == null) {
                    this.addProperty(dbConnection, userName, property, value, profileName);
                    continue;
                }
                this.updateProperty(dbConnection, userName, property, value, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            String property = null;
            property = "profileConfiguration".equals(claimURI) ? "profileConfiguration" : this.claimManager.getClaimMapping(claimURI).getMappedAttribute();
            dbConnection = this.getDBConnection();
            this.deleteProperty(dbConnection, userName, property, profileName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
                catch (org.wso2.carbon.user.api.UserStoreException e2) {
                    throw new UserStoreException(e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            dbConnection = this.getDBConnection();
            for (String claimURI : claims) {
                String property = this.claimManager.getClaimMapping(claimURI).getMappedAttribute();
                this.deleteProperty(dbConnection, userName, property, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        if (!this.authenticate(userName, oldCredential)) {
            log.error((Object)"Wrong username/password provided");
            throw new UserStoreException("Wrong username/password provided");
        }
        this.updateCredentialByAdmin(userName, newCredential);
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        if (!this.checkUserPasswordValid(newCredential)) {
            throw new UserStoreException("Credential not valid. Credential must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("PasswordJavaRegEx"));
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPasswordSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for delete user claim value is null");
        }
        String saltValue = null;
        if ("true".equals(this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
            byte[] bytes = new byte[16];
            this.random.nextBytes(bytes);
            saltValue = Base64.encode((byte[])bytes);
        }
        String password = this.preparePassword((String)newCredential, saltValue);
        if (sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, false, new Date(), userName, this.tenantId);
        } else if (sqlStmt.contains("UM_TENANT_ID") && saltValue != null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userName, this.tenantId);
        } else if (!sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, false, new Date(), userName);
        } else {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userName);
        }
    }

    @Override
    public String[] getHybridRoles() throws UserStoreException {
        String[] names = new String[]{};
        if (this.isReadOnly() || this.useOnlyInternalRoles) {
            names = this.hybridRoleManager.getHybridRoles();
        }
        return names;
    }

    @Override
    public Date getPasswordExpirationTime(String userName) throws UserStoreException {
        Date date;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block7: {
            dbConnection = null;
            rs = null;
            prepStmt = null;
            String sqlstmt = null;
            date = null;
            try {
                dbConnection = this.getDBConnection();
                dbConnection.setAutoCommit(false);
                sqlstmt = this.realmConfig.getUserStoreProperty("SelectUserSQL");
                if (log.isDebugEnabled()) {
                    log.debug((Object)sqlstmt);
                }
                prepStmt = dbConnection.prepareStatement(sqlstmt);
                prepStmt.setString(1, userName);
                if (sqlstmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(2, this.tenantId);
                }
                if (!(rs = prepStmt.executeQuery()).next()) break block7;
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                if (requireChange) {
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(changedTime);
                    gc.add(10, 24);
                    date = gc.getTime();
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.error((Object)("Using sql : " + sqlstmt));
                    throw new UserStoreException(e.getMessage());
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return date;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStringValuesToDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block15: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                int count;
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Invalid data provided");
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (param instanceof Integer) {
                            prepStmt.setInt(i + 1, (Integer)param);
                            continue;
                        }
                        if (param instanceof Date) {
                            prepStmt.setTimestamp(i + 1, new Timestamp(System.currentTimeMillis()));
                            continue;
                        }
                        if (!(param instanceof Boolean)) continue;
                        prepStmt.setBoolean(i + 1, (Boolean)param);
                    }
                }
                if ((count = prepStmt.executeUpdate()) == 0) {
                    log.info((Object)"No rows were updated");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executed querry is " + sqlStmt + " and number of updated rows :: " + count));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block15;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.error((Object)("Using sql : " + sqlStmt));
                    throw new UserStoreException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public void addProperty(Connection dbConnection, String userName, String propertyName, String value, String profileName) throws UserStoreException {
        try {
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for add user property sql is null");
            }
            if ("openedge".equals(type)) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, propertyName, value, profileName, this.tenantId, userName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, this.tenantId, propertyName, value, profileName, this.tenantId);
            }
        }
        catch (UserStoreException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    protected void updateProperty(Connection dbConnection, String userName, String propertyName, String value, String profileName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPropertySQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        this.updateStringValuesToDatabase(dbConnection, sqlStmt, value, userName, this.tenantId, propertyName, profileName, this.tenantId);
    }

    protected void deleteProperty(Connection dbConnection, String userName, String propertyName, String profileName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("DeleteUserPropertySQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, this.tenantId, propertyName, profileName, this.tenantId);
    }

    protected String getProperty(Connection dbConnection, String userName, String propertyName, String profileName) throws UserStoreException {
        String string;
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserPropertyForProfileSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String value = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userName);
            prepStmt.setString(2, propertyName);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                value = rs.getString(1);
            }
            string = value;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return string;
    }

    protected String preparePassword(String password, String saltValue) throws UserStoreException {
        try {
            String digsestFunction;
            String digestInput = password;
            if (saltValue != null) {
                digestInput = password + saltValue;
            }
            if ((digsestFunction = (String)this.realmConfig.getUserStoreProperties().get("PasswordDigest")) != null) {
                if (digsestFunction.equals("PLAIN_TEXT")) {
                    return password;
                }
                MessageDigest dgst = MessageDigest.getInstance(digsestFunction);
                byte[] byteValue = dgst.digest(digestInput.getBytes());
                password = Base64.encode((byte[])byteValue);
            }
            return password;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private void addInitialData() throws UserStoreException {
        String adminUserName;
        boolean isAdminRoleAdded = false;
        if (!this.isExistingRole(this.realmConfig.getAdminRoleName())) {
            this.addRole(this.realmConfig.getAdminRoleName(), (String[])null, (Permission[])null);
            isAdminRoleAdded = true;
        }
        if (!this.isExistingRole(this.realmConfig.getEveryOneRoleName())) {
            this.addRole(this.realmConfig.getEveryOneRoleName(), (String[])null, (Permission[])null);
        }
        if ((adminUserName = this.getAdminUser()) != null) {
            this.realmConfig.setAdminUserName(adminUserName);
        } else if (!this.isExistingUser(this.realmConfig.getAdminUserName())) {
            if ("true".equals(this.realmConfig.getUserStoreProperty("ReadOnly"))) {
                log.error((Object)"Admin user name is not valid");
                throw new UserStoreException("Admin user name is not valid");
            }
            this.persistUser(this.realmConfig.getAdminUserName(), this.realmConfig.getAdminPassword(), null, null, null, false);
        }
        if (isAdminRoleAdded) {
            this.updateRoleListOfUser(this.realmConfig.getAdminUserName(), null, new String[]{this.realmConfig.getAdminRoleName()});
        }
        if (!this.isExistingUser("wso2.anonymous.user") && !this.isReadOnly()) {
            byte[] password = new byte[12];
            this.random.nextBytes(password);
            this.persistUser("wso2.anonymous.user", Base64.encode((byte[])password), null, null, null, false);
        }
        if (!this.isExistingRole("wso2.anonymous.role")) {
            this.addRole("wso2.anonymous.role", new String[]{"wso2.anonymous.user"}, (Permission[])null);
        }
    }

    private DataSource loadUserStoreSpacificDataSoruce() throws UserStoreException {
        return DatabaseUtil.createUserStoreDataSource(this.realmConfig);
    }

    @Override
    public Map<String, String> getProperties(org.wso2.carbon.user.core.tenant.Tenant tenant) throws UserStoreException {
        return this.realmConfig.getUserStoreProperties();
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String[] values = DatabaseUtil.getStringValuesFromDatabase(dbConnection, "SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", userName, this.tenantId);
            Date createdTime = Calendar.getInstance().getTime();
            if (values != null && values.length > 0 && values[0].length() > 0) {
                DatabaseUtil.updateDatabase(dbConnection, "UPDATE UM_HYBRID_REMEMBER_ME SET UM_COOKIE_VALUE=?, UM_CREATED_TIME=? WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", token, createdTime, userName, this.tenantId);
            } else {
                DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_HYBRID_REMEMBER_ME (UM_USER_NAME, UM_COOKIE_VALUE, UM_CREATED_TIME, UM_TENANT_ID) VALUES (?,?,?,?)", userName, token, createdTime, this.tenantId);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isExistingRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        boolean isValid = false;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String value = null;
        Timestamp createdTime = null;
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, userName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                value = rs.getString(1);
                createdTime = rs.getTimestamp(2);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)"Using sql : SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        if (value != null && createdTime != null) {
            Calendar calendar = Calendar.getInstance();
            Date nowDate = calendar.getTime();
            calendar.setTime(createdTime);
            calendar.add(13, 604800);
            Date expDate = calendar.getTime();
            if (expDate.before(nowDate)) {
                log.debug((Object)"Remember me token has expired !!");
            } else if (value.equals(token)) {
                isValid = true;
            } else {
                log.debug((Object)"Remember me token in DB and token in request are different !!");
                isValid = false;
            }
        }
        return isValid;
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            if (this.isExistingUser(userName)) {
                return this.isExistingRememberMeToken(userName, token);
            }
        }
        catch (Exception e) {
            log.error((Object)("Validating remember me token failed for" + userName));
        }
        return false;
    }

    @Override
    public String[] getUserListFromProperties(String property, String value, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        String[] users = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserLisForPropertySQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                list.add(name);
            }
            if (list.size() > 0) {
                users = list.toArray(new String[list.size()]);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return users;
    }
}

