/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config.multitenancy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class SimpleRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static Log log = LogFactory.getLog(SimpleRealmConfigBuilder.class);

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        RealmConfiguration realmConfig;
        try {
            realmConfig = bootStrapConfig.cloneRealmConfiguration();
            realmConfig.setAdminUserName(persistedConfig.getAdminUserName());
            realmConfig.setAdminPassword(persistedConfig.getAdminPassword());
        }
        catch (Exception e) {
            String errorMessage = "Error while building tenant specific realm configurationwhen creating tenant's realm.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        return realmConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfig, Tenant tenantInfo, int tenantId) throws UserStoreException {
        try {
            RealmConfiguration realmConfig = bootStrapConfig.cloneRealmConfiguration();
            this.removePropertiesFromTenantRealmConfig(realmConfig);
            realmConfig.setAdminUserName(tenantInfo.getAdminName());
            realmConfig.setAdminPassword(UserCoreUtil.getDummyPassword());
            return realmConfig;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private void removePropertiesFromTenantRealmConfig(RealmConfiguration tenantRealmConfiguration) {
        tenantRealmConfiguration.getRealmProperties().clear();
        tenantRealmConfiguration.getUserStoreProperties().clear();
        tenantRealmConfiguration.getAuthzProperties().clear();
    }
}

