/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.authorization.AuthorizationCache;
import org.wso2.carbon.caching.core.authorization.AuthorizationCacheException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.authorization.PermissionTree;
import org.wso2.carbon.user.core.authorization.PermissionTreeUtil;
import org.wso2.carbon.user.core.authorization.SearchResult;
import org.wso2.carbon.user.core.authorization.TreeNode;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class JDBCAuthorizationManager
implements AuthorizationManager {
    private DataSource dataSource = null;
    private PermissionTree permissionTree = null;
    private AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
    private UserRealm userRealm = null;
    private RealmConfiguration realmConfig = null;
    private int tenantId;
    private static Log log = LogFactory.getLog(JDBCAuthorizationManager.class);

    public JDBCAuthorizationManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
            properties.put("um.datasource", this.dataSource);
        }
        this.permissionTree = new PermissionTree(tenantId, this.dataSource);
        this.realmConfig = realmConfig;
        this.userRealm = realm;
        this.tenantId = tenantId;
        if (log.isDebugEnabled()) {
            log.debug((Object)("The jdbcDataSource being used by JDBCAuthorizationManager :: " + this.dataSource.hashCode()));
        }
        this.populatePermissionTreeFromDB();
        this.addInitialData();
    }

    @Override
    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.isRoleAuthorized(roleName, resourceId, action, this)) continue;
            return false;
        }
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getRolePermission(roleName, PermissionTreeUtil.actionToPermission(action), null, null, PermissionTreeUtil.toComponenets(resourceId));
        if (log.isDebugEnabled() && !sr.getLastNodeAllowedAccess().booleanValue()) {
            log.debug((Object)(roleName + " role is not Authorized to perform " + action + " on " + resourceId));
        }
        return sr.getLastNodeAllowedAccess();
    }

    @Override
    public boolean isUserAuthorized(String userName, String resourceId, String action) throws UserStoreException {
        if ("wso2.system.user".equals(userName)) {
            return true;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.isUserAuthorized(userName, resourceId, action, this)) continue;
            return false;
        }
        try {
            boolean userAllowed = this.authorizationCache.isUserAuthorized(this.tenantId, userName, resourceId, action);
            if (log.isDebugEnabled() && !userAllowed) {
                log.debug((Object)(userName + " user is not Authorized to perform " + action + " on " + resourceId));
            }
            return userAllowed;
        }
        catch (AuthorizationCacheException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authorization cache entry is not found for username : " + userName));
            }
            this.permissionTree.updatePermissionTree();
            SearchResult sr = this.permissionTree.getUserPermission(userName, PermissionTreeUtil.actionToPermission(action), null, null, PermissionTreeUtil.toComponenets(resourceId));
            if (sr.getLastNodeAllowedAccess().booleanValue()) {
                this.authorizationCache.addToCache(this.tenantId, userName, resourceId, action, true);
                return true;
            }
            String[] userRoles = this.userRealm.getUserStoreManager().getRoleListOfUser(userName);
            if (log.isDebugEnabled() && (userRoles == null || userRoles.length < 1)) {
                log.debug((Object)("No roles are assigned to user : " + userName));
            }
            boolean userAllowed = false;
            List<String> allowedRoles = Arrays.asList(this.getAllowedRolesForResource(resourceId, action));
            if (userRoles != null) {
                for (String role : userRoles) {
                    if (!allowedRoles.contains(role)) continue;
                    userAllowed = true;
                    break;
                }
            }
            this.authorizationCache.addToCache(this.tenantId, userName, resourceId, action, userAllowed);
            if (log.isDebugEnabled() && !userAllowed) {
                log.debug((Object)(userName + " user is not Authorized to perform " + action + " on " + resourceId));
            }
            return userAllowed;
        }
    }

    @Override
    public String[] getAllowedRolesForResource(String resourceId, String action) throws UserStoreException {
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getAllowedRolesForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws UserStoreException {
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getAllowedUsersForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getDeniedRolesForResource(String resourceId, String action) throws UserStoreException {
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getDeniedRolesForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getDeniedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws UserStoreException {
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getDeniedUsersForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getDeniedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws UserStoreException {
        ArrayList<String> lstPermissions = new ArrayList<String>();
        String[] roles = this.userRealm.getUserStoreManager().getRoleListOfUser(userName);
        this.permissionTree.updatePermissionTree();
        this.permissionTree.getUIResourcesForRoles(roles, lstPermissions, permissionRootPath);
        String[] permissions = lstPermissions.toArray(new String[lstPermissions.size()]);
        String[] optimizedList = UserCoreUtil.optimizePermissions(permissions);
        return optimizedList;
    }

    @Override
    public void authorizeRole(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.authorizeRole(roleName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        this.addAuthorizationForRole(roleName, resourceId, action, (short)1);
    }

    @Override
    public void denyRole(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.denyRole(roleName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        this.addAuthorizationForRole(roleName, resourceId, action, (short)0);
    }

    @Override
    public void authorizeUser(String userName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.authorizeUser(userName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        this.addAuthorizationForUser(userName, resourceId, action, (short)1);
    }

    @Override
    public void denyUser(String userName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.denyUser(userName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        this.addAuthorizationForUser(userName, resourceId, action, (short)0);
    }

    @Override
    public void clearResourceAuthorizations(String resourceId) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearResourceAuthorizations(resourceId, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByResource(this.tenantId, resourceId);
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=?) AND UM_TENANT_ID=?", resourceId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=?) AND UM_TENANT_ID=?", resourceId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_TENANT_ID=?", resourceId, this.tenantId);
            this.permissionTree.clearResourceAuthorizations(resourceId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Error! " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleAuthorization(roleName, resourceId, action, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", roleName, resourceId, action, this.tenantId, this.tenantId);
            this.permissionTree.clearRoleAuthorization(roleName, resourceId, action);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Error! " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void clearUserAuthorization(String userName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearUserAuthorization(userName, resourceId, action, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheEntry(this.tenantId, userName, resourceId, action);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            int permissionId = this.getPermissionId(dbConnection, resourceId, action);
            if (permissionId == -1) {
                this.addPermissionId(dbConnection, resourceId, action);
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", userName, resourceId, action, this.tenantId, this.tenantId);
            this.permissionTree.clearUserAuthorization(userName, resourceId, action);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearRoleActionOnAllResources(String roleName, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleActionOnAllResources(roleName, action, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearRoleAuthorization(roleName, action);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", roleName, action, this.tenantId, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearRoleAuthorization(String roleName) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleAuthorization(roleName, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearRoleAuthorization(roleName);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?", roleName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearUserAuthorization(String userName) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearUserAuthorization(userName, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByUser(this.tenantId, userName);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearUserAuthorization(userName);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", userName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.resetPermissionOnUpdateRole(roleName, newRoleName, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        String sqlStmt = "UPDATE UM_ROLE_PERMISSION set UM_ROLE_NAME=? WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update role name is null");
        }
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.updateRoleNameInCache(roleName, newRoleName);
            DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    private void addAuthorizationForRole(String roleName, String resourceId, String action, short allow) throws UserStoreException {
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            int permissionId = this.getPermissionId(dbConnection, resourceId, action);
            if (permissionId == -1) {
                this.addPermissionId(dbConnection, resourceId, action);
                permissionId = this.getPermissionId(dbConnection, resourceId, action);
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", roleName, resourceId, action, this.tenantId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_ROLE_PERMISSION (UM_PERMISSION_ID, UM_ROLE_NAME, UM_IS_ALLOWED, UM_TENANT_ID) VALUES (?, ?, ?, ?)", permissionId, roleName, allow, this.tenantId);
            if (allow == 1) {
                this.permissionTree.authorizeRoleInTree(roleName, resourceId, action, true);
            } else {
                this.permissionTree.denyRoleInTree(roleName, resourceId, action, true);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    private void addAuthorizationForUser(String userName, String resourceId, String action, short allow) throws UserStoreException {
        this.authorizationCache.clearCacheByUser(this.tenantId, userName);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            int permissionId = this.getPermissionId(dbConnection, resourceId, action);
            if (permissionId == -1) {
                this.addPermissionId(dbConnection, resourceId, action);
                permissionId = this.getPermissionId(dbConnection, resourceId, action);
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", userName, resourceId, action, this.tenantId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_USER_PERMISSION (UM_PERMISSION_ID, UM_USER_NAME, UM_IS_ALLOWED, UM_TENANT_ID) VALUES (?, ?, ?, ?)", permissionId, userName, allow, this.tenantId);
            if (allow == 1) {
                this.permissionTree.authorizeUserInTree(userName, resourceId, action, true);
            } else {
                this.permissionTree.denyUserInTree(userName, resourceId, action, true);
                this.authorizationCache.clearCacheEntry(this.tenantId, userName, resourceId, action);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    private int getPermissionId(Connection dbConnection, String resourceId, String action) throws UserStoreException {
        int n;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int value = -1;
        try {
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=? AND UM_ACTION=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, resourceId);
            prepStmt.setString(2, action);
            prepStmt.setInt(3, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                value = rs.getInt(1);
            }
            n = value;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return n;
    }

    private void addPermissionId(Connection dbConnection, String resourceId, String action) throws UserStoreException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("INSERT INTO UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID) VALUES (?, ?, ?)");
            prepStmt.setString(1, resourceId);
            prepStmt.setString(2, action);
            prepStmt.setInt(3, this.tenantId);
            int count = prepStmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executed querry is INSERT INTO UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID) VALUES (?, ?, ?) and number of updated rows :: " + count));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = this.dataSource.getConnection();
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }

    public void populatePermissionTreeFromDB() throws UserStoreException {
        this.permissionTree.updatePermissionTreeFromDB();
    }

    public void clearPermissionTree() {
        this.permissionTree.clear();
        this.authorizationCache.clearCache();
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    private void addInitialData() throws UserStoreException {
        String mgtPermissions = this.realmConfig.getAuthorizationManagerProperty("EveryoneRoleManagementPermissions");
        if (mgtPermissions != null) {
            String[] resourceIds;
            String everyoneRole = this.realmConfig.getEveryOneRoleName();
            for (String resourceId : resourceIds = mgtPermissions.split(",")) {
                if (this.isRoleAuthorized(everyoneRole, resourceId, "ui.execute")) continue;
                this.authorizeRole(everyoneRole, resourceId, "ui.execute");
            }
        }
        if ((mgtPermissions = this.realmConfig.getAuthorizationManagerProperty("AdminRoleManagementPermissions")) != null) {
            String[] resourceIds = mgtPermissions.split(",");
            String adminRole = this.realmConfig.getAdminRoleName();
            for (String resourceId : resourceIds) {
                if (this.isRoleAuthorized(adminRole, resourceId, "ui.execute")) continue;
                this.authorizeRole(adminRole, resourceId, "ui.execute");
            }
        }
    }
}

