/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Utils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public final class PersistenceUtils {
    private static Log log = LogFactory.getLog(PersistenceUtils.class);
    private static OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private static final String PROXY_SERVICE = "proxy";
    private static final String GLOBALLY_ENGAGED_PARAM_NAME = "globallyEngaged";
    private static final String GLOBALLY_ENGAGED_CUSTOM = "globallyEngagedCustom";
    private static XMLInputFactory xif = XMLInputFactory.newInstance();

    private PersistenceUtils() {
    }

    public static String getResourcePath(AxisService service) {
        return "/service" + PersistenceUtils.getXPathAttrPredicate("name", service.getName());
    }

    public static String getRegistryResourcePath(AxisService service) {
        return "/repository/axis2/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + service.getName();
    }

    public static String getResourcePath(AxisOperation operation) {
        return PersistenceUtils.getResourcePath(operation.getAxisService()) + "/" + "operation" + PersistenceUtils.getXPathAttrPredicate("name", operation.getName().getLocalPart());
    }

    public static String getResourcePath(AxisModule module) {
        String version = PersistenceUtils.getModuleVersion(module);
        return "/version" + PersistenceUtils.getXPathAttrPredicate("id", version);
    }

    public static String getBindingPath(String serviceXPath, AxisBinding binding) {
        return serviceXPath + "/" + "bindings" + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate("name", binding.getName().getLocalPart());
    }

    public static String getBindingOperationPath(String serviceXPath, AxisBindingOperation abo) {
        return PersistenceUtils.getBindingPath(serviceXPath, abo.getAxisBinding()) + "/" + "operation" + PersistenceUtils.getXPathAttrPredicate("name", abo.getName().getLocalPart());
    }

    public static OMElement getPolicyElementFromList(String policyId, List policyElementList) {
        for (Object resource : policyElementList) {
            OMElement currentElement = (OMElement)resource;
            if (!policyId.equalsIgnoreCase(currentElement.getFirstChildWithName(new QName("policyUUID")).getText())) continue;
            return currentElement;
        }
        return null;
    }

    public static boolean isProxyService(AxisService service) {
        ArrayList axisServiceParameters = service.getParameters();
        ListIterator iter = axisServiceParameters.listIterator();
        boolean isProxyService = false;
        while (iter.hasNext()) {
            Parameter elem = (Parameter)iter.next();
            Object value = elem.getValue();
            if (value == null || !PROXY_SERVICE.equals(value.toString())) continue;
            isProxyService = true;
        }
        return isProxyService;
    }

    public static void markFaultyModule(AxisModule axisModule) {
        String version = PersistenceUtils.getModuleVersion(axisModule);
        axisModule.getParent().getFaultyModules().put(Utils.getModuleName((String)axisModule.getName(), (String)version), axisModule.getName());
    }

    public static void handleGlobalParams(AxisModule axisModule, OMElement moduleVerEl) throws AxisFault {
        if (Boolean.parseBoolean(moduleVerEl.getAttributeValue(new QName(GLOBALLY_ENGAGED_PARAM_NAME)))) {
            axisModule.addParameter(new Parameter(GLOBALLY_ENGAGED_PARAM_NAME, (Object)Boolean.TRUE.toString()));
            axisModule.getParent().engageModule(axisModule);
        }
        if (Boolean.parseBoolean(moduleVerEl.getAttributeValue(new QName(GLOBALLY_ENGAGED_CUSTOM)))) {
            axisModule.addParameter(new Parameter(GLOBALLY_ENGAGED_PARAM_NAME, (Object)Boolean.TRUE.toString()));
        }
    }

    public static String getXPathAttrPredicate(String attrName, String attrValue) {
        return "[@" + attrName + "=\"" + attrValue + "\"]";
    }

    public static String getXPathTextPredicate(String prefixes, String textValue) {
        if (prefixes == null || "".equals(prefixes)) {
            return "[text()=\"" + textValue + "\"]";
        }
        return "[" + prefixes + "/text()=\"" + textValue + "\"]";
    }

    public static OMElement createAssociation(String destinationPath, String type) {
        OMElement association = omFactory.createOMElement("association", null);
        association.addAttribute("destinationPath", destinationPath, null);
        association.addAttribute("type", type, null);
        return association;
    }

    public static OMElement createModule(String moduleName, String moduleVersion, String type) {
        OMElement module = omFactory.createOMElement("module", null);
        module.addAttribute("name", moduleName, null);
        if (moduleVersion != null) {
            module.addAttribute("version", moduleVersion, null);
        } else {
            module.addAttribute("version", "undefined", null);
        }
        module.addAttribute("type", type, null);
        return module;
    }

    public static OMElement createOperation(AxisDescription ad, String opName) {
        OMElement operationElement = omFactory.createOMElement("operation", null);
        String doc = ad.getDocumentation();
        if (doc != null) {
            operationElement.addAttribute("serviceDocumentation", doc, null);
        }
        operationElement.addAttribute("name", opName, null);
        return operationElement;
    }

    public static OMElement createPolicyElement(Policy policy) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
        policy.serialize(writer);
        writer.flush();
        OMElement policyElement = AXIOMUtil.stringToOM((String)outputStream.toString());
        if (policyElement.getParent() instanceof OMDocument) {
            policyElement.detach();
        }
        return policyElement;
    }

    public static Resource createPolicyResource(Registry configRegistry, Policy policy, String policyId, String policyType) throws RegistryException {
        try {
            Resource policyResource = configRegistry.newResource();
            policyResource.setProperty("policy.uuid", policyId);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
            policy.serialize(writer);
            writer.flush();
            policyResource.setContent((Object)outputStream.toString());
            policyResource.setProperty("policy.type", policyType);
            return policyResource;
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error creating the registry resource for " + policyId), (Throwable)e);
            throw new RegistryException("Error creating the registry resource for " + policyId, (Throwable)e);
        }
    }

    public static String getPolicyUUIDFromWrapperOM(OMElement policyWrapperElement) {
        return policyWrapperElement.getFirstChildWithName(new QName("policyUUID")).getText();
    }

    public static String getModuleVersion(AxisModule axisModule) {
        String version = "undefined";
        if (axisModule.getVersion() != null) {
            version = axisModule.getVersion().toString();
        }
        return version;
    }

    public static OMElement getResourceDocumentElement(File resourceFile) throws XMLStreamException, IOException {
        OMElement resourceElement;
        FileInputStream fis = null;
        XMLStreamReader reader = null;
        try {
            fis = FileUtils.openInputStream((File)resourceFile);
            reader = xif.createXMLStreamReader(fis);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            resourceElement = builder.getDocumentElement();
            resourceElement.detach();
        }
        catch (XMLStreamException e) {
            throw new XMLStreamException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return resourceElement;
    }
}

