/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ModuleDeployer;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.CarbonAxisConfigurator;
import org.wso2.carbon.core.deployment.CarbonDeploymentSchedulerTask;
import org.wso2.carbon.core.deployment.DeploymentInterceptor;
import org.wso2.carbon.core.deployment.RegistryBasedRepository;
import org.wso2.carbon.core.deployment.RegistryBasedRepositoryUpdater;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.multitenancy.TenantAxisConfiguration;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.PreAxisConfigurationPopulationObserver;
import org.wso2.carbon.utils.deployment.Axis2DeployerRegistry;
import org.wso2.carbon.utils.deployment.Axis2ModuleRegistry;
import org.wso2.carbon.utils.deployment.GhostDeployerRegistry;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class TenantAxisConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static Log log = LogFactory.getLog(TenantAxisConfigurator.class);
    private Collection globallyEngagedModules = new ArrayList();
    private final AxisConfiguration mainAxisConfig;
    private final String tenantDomain;
    private final int tenantId;
    private final String repoLocation;
    private final UserRegistry registry;
    private final BundleContext bundleContext;
    private final Bundle[] moduleBundles;
    private final Bundle[] deployerBundles;
    private File repositoryDir;
    private ScheduledExecutorService scheduler;
    private CarbonDeploymentSchedulerTask schedulerTask;

    @Deprecated
    public TenantAxisConfigurator(AxisConfiguration mainAxisConfig, String tenantDomain, int tenantId, UserRegistry registry) throws AxisFault {
        this.tenantDomain = tenantDomain;
        this.tenantId = tenantId;
        this.mainAxisConfig = mainAxisConfig;
        this.registry = registry;
        this.bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        this.moduleBundles = ((CarbonAxisConfigurator)mainAxisConfig.getConfigurator()).getConfigItemHolder().getModuleBundles();
        this.deployerBundles = ((CarbonAxisConfigurator)mainAxisConfig.getConfigurator()).getConfigItemHolder().getDeployerBundles();
        File tenantDir = new File(CarbonUtils.getCarbonTenantsDirPath() + File.separator + tenantId);
        if (!tenantDir.exists() && !tenantDir.mkdirs()) {
            log.warn((Object)("Could not create directory " + tenantDir.getAbsolutePath()));
        }
        this.repoLocation = tenantDir.getAbsolutePath();
        if (CarbonUtils.useRegistryBasedRepository()) {
            String registryPath = "/repository/deployment";
            new RegistryBasedRepository(registry, registryPath, this.repoLocation).updateFileSystemFromRegistry();
            RegistryBasedRepositoryUpdater.scheduleAtFixedRate(registry, registryPath, this.repoLocation, 0L, 10L);
        }
    }

    public TenantAxisConfigurator(AxisConfiguration mainAxisConfig, String tenantDomain, int tenantId, UserRegistry configRegistry, UserRegistry localRegistry) throws AxisFault {
        this.tenantDomain = tenantDomain;
        this.tenantId = tenantId;
        this.mainAxisConfig = mainAxisConfig;
        this.registry = configRegistry;
        this.bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        this.moduleBundles = ((CarbonAxisConfigurator)mainAxisConfig.getConfigurator()).getConfigItemHolder().getModuleBundles();
        this.deployerBundles = ((CarbonAxisConfigurator)mainAxisConfig.getConfigurator()).getConfigItemHolder().getDeployerBundles();
        String filePath = MultitenantUtils.getAxis2RepositoryPath((int)tenantId);
        File tenantDir = new File(filePath);
        if (!tenantDir.exists() && !tenantDir.mkdirs()) {
            log.warn((Object)("Could not create directory " + tenantDir.getAbsolutePath()));
        }
        this.repoLocation = filePath;
        if (CarbonUtils.useRegistryBasedRepository()) {
            String registryPath = "/repository/deployment";
            new RegistryBasedRepository(localRegistry, registryPath, this.repoLocation).updateFileSystemFromRegistry();
            RegistryBasedRepositoryUpdater.scheduleAtFixedRate(localRegistry, registryPath, this.repoLocation, 0L, 10L);
        }
    }

    private String getTenantString(String tenantDomain, int tenantId) {
        return tenantDomain + "[" + tenantId + "]";
    }

    public void loadRepository(String repoDir) throws DeploymentException {
        File axisRepo = new File(repoDir);
        if (!axisRepo.exists()) {
            throw new DeploymentException(Messages.getMessage((String)"cannotfindrepo", (String)repoDir));
        }
        this.setDeploymentFeatures();
        this.prepareRepository(repoDir);
        this.setClassLoaders(repoDir);
        this.repoListener = new RepositoryListener((DeploymentEngine)this, false);
        Utils.calculateDefaultModuleVersion((HashMap)this.axisConfig.getModules(), (AxisConfiguration)this.axisConfig);
        try {
            try {
                if (this.axisConfig.getRepository() == null) {
                    this.axisConfig.setRepository(axisRepo.toURL());
                }
            }
            catch (MalformedURLException e) {
                log.info((Object)e.getMessage());
            }
            this.axisConfig.validateSystemPredefinedPhases();
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException((Throwable)axisFault);
        }
    }

    protected void prepareRepository(String repositoryName) {
        this.repositoryDir = new File(repositoryName);
        if (this.servicesPath != null && !GhostDeployerUtils.isGhostOn()) {
            this.servicesDir = new File(this.servicesPath);
            if (!this.servicesDir.exists()) {
                this.servicesDir = new File(this.repositoryDir, this.servicesPath);
            }
        } else {
            this.servicesDir = new File(this.repositoryDir, "services");
        }
        if (this.modulesPath != null) {
            this.modulesDir = new File(this.modulesPath);
            if (!this.modulesDir.exists()) {
                this.modulesDir = new File(this.repositoryDir, this.modulesPath);
            }
        } else {
            this.modulesDir = new File(this.repositoryDir, "modules");
        }
        if (!this.modulesDir.exists()) {
            log.info((Object)Messages.getMessage((String)"nomoduledirfound", (String)this.getRepositoryPath(this.repositoryDir)));
        }
    }

    public File getRepositoryDir() {
        return this.repositoryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        log.info((Object)("Creating tenant AxisConfiguration for tenant: " + this.getTenantString(this.tenantDomain, this.tenantId)));
        SuperTenantCarbonContext.startTenantFlow();
        try {
            SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext();
            carbonContext.setTenantId(this.tenantId);
            carbonContext.setTenantDomain(this.tenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Axis2 repo: " + this.repoLocation));
            }
            this.populateAxisConfig();
            this.addDeployer((Deployer)new ModuleDeployer(), this.repoLocation + File.separator + "axis2modules", "mar");
            this.axisConfig.setConfigurator((AxisConfigurator)this);
            this.axisConfig.addParameter(new Parameter("hotdeployment", (Object)"true"));
            this.axisConfig.addParameter(new Parameter("hotupdate", (Object)"true"));
            this.globallyEngagedModules = this.axisConfig.getEngagedModules();
            this.loadRepository(this.repoLocation);
            File axis2ServicesDir = new File(this.repoLocation, CarbonUtils.getAxis2ServicesDir((AxisConfiguration)this.axisConfig));
            if (axis2ServicesDir.exists()) {
                this.axisConfig.setServiceClassLoader(org.apache.axis2.deployment.util.Utils.getClassLoader((ClassLoader)this.axisConfig.getSystemClassLoader(), (File)axis2ServicesDir, (boolean)this.axisConfig.isChildFirstClassLoading()));
            }
            for (Object globallyEngagedModule : this.globallyEngagedModules) {
                AxisModule module = (AxisModule)globallyEngagedModule;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Globally engaging module: " + module.getName()));
            }
            this.axisConfig.getTransportsOut().clear();
            this.axisConfig.getTransportsIn().clear();
            TenantAxisUtils.setTenantTransports(this.mainAxisConfig, this.tenantDomain, this.axisConfig);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
        return this.axisConfig;
    }

    private void populateAxisConfig() throws DeploymentException {
        InputStream axis2xmlStream = null;
        try {
            File tenantAxis2XML = new File(CarbonUtils.getCarbonConfigDirPath() + File.separator + "axis2" + File.separator + "tenant-axis2.xml");
            axis2xmlStream = new FileInputStream(tenantAxis2XML);
            this.axisConfig = this.populateAxisConfiguration(axis2xmlStream);
        }
        catch (FileNotFoundException e) {
            String msg = "Cannot read tenant-axis2.xml";
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
        finally {
            try {
                if (axis2xmlStream != null) {
                    axis2xmlStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not close input stream to org/apache/axis2/deployment/axis2_default.xml", (Throwable)e);
            }
        }
    }

    public boolean isGlobalyEngaged(AxisModule axisModule) {
        String modName = axisModule.getName();
        for (Object globallyEngagedModule : this.globallyEngagedModules) {
            AxisModule module = (AxisModule)globallyEngagedModule;
            if (!modName.startsWith(module.getName())) continue;
            return true;
        }
        return false;
    }

    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }

    public AxisConfiguration populateAxisConfiguration(InputStream in) throws DeploymentException {
        ServiceTracker tracker;
        this.axisConfig = TenantAxisConfiguration.createInstance();
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext(this.axisConfig);
        carbonContext.setTenantId(this.tenantId);
        carbonContext.setTenantDomain(this.tenantDomain);
        boolean isUrlRepo = CarbonUtils.isURL((String)this.repoLocation);
        if (this.repoLocation != null && this.repoLocation.trim().length() != 0) {
            try {
                if (isUrlRepo) {
                    URL axis2Repository = new URL(this.repoLocation);
                    this.axisConfig.setRepository(axis2Repository);
                } else {
                    this.axisConfig.setRepository(new URL("file://" + this.repoLocation));
                }
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Invalid URL " + this.repoLocation, (Throwable)e);
            }
        }
        if (this.bundleContext != null) {
            tracker = new ServiceTracker(this.bundleContext, PreAxisConfigurationPopulationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((PreAxisConfigurationPopulationObserver)service).createdAxisConfiguration(this.axisConfig);
                }
            }
            tracker.close();
        }
        try {
            File servicesDir;
            if (this.bundleContext != null) {
                tracker = new ServiceTracker(this.bundleContext, AxisObserver.class.getName(), null);
                tracker.open();
                ServiceReference[] serviceRefs = tracker.getServiceReferences();
                if (serviceRefs != null) {
                    for (ServiceReference serviceRef : serviceRefs) {
                        if (serviceRef.getProperty("tenantId") == null || this.tenantId != (Integer)serviceRef.getProperty("tenantId")) continue;
                        this.axisConfig.addObservers((AxisObserver)this.bundleContext.getService(serviceRef));
                    }
                }
                tracker.close();
            }
            if (!(servicesDir = new File(this.repoLocation + File.separator + CarbonUtils.getAxis2ServicesDir((AxisConfiguration)this.axisConfig))).exists() && !servicesDir.mkdirs()) {
                throw new DeploymentException("Could not create services directory " + servicesDir.getAbsolutePath());
            }
            String modulesDirName = "axis2modules";
            File modulesDir = new File(this.repoLocation + File.separator + modulesDirName);
            if (!modulesDir.exists() && !modulesDir.mkdirs()) {
                throw new DeploymentException("Could not create modules directory " + modulesDir.getAbsolutePath());
            }
            this.axisConfig.addParameter(new Parameter("ModulesDirectory", (Object)modulesDirName));
        }
        catch (AxisFault e) {
            String msg = "Cannot add DeploymentConstants.SERVICE_DIR_PATH or DeploymentConstants.MODULE_DIR_PATH parameters";
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
        carbonContext.setRegistry(RegistryType.SYSTEM_CONFIGURATION, (org.wso2.carbon.registry.api.Registry)this.registry);
        try {
            carbonContext.setRegistry(RegistryType.SYSTEM_GOVERNANCE, (org.wso2.carbon.registry.api.Registry)CarbonCoreDataHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(this.tenantId));
            carbonContext.setRegistry(RegistryType.LOCAL_REPOSITORY, (org.wso2.carbon.registry.api.Registry)CarbonCoreDataHolder.getInstance().getRegistryService().getLocalRepository(this.tenantId));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.setRegistry();
        this.setUserRealm();
        DeploymentInterceptor interceptor = new DeploymentInterceptor();
        interceptor.setRegistry((Registry)this.registry);
        interceptor.init(this.axisConfig);
        this.axisConfig.addObservers((AxisObserver)interceptor);
        TenantAxisConfigurator.setHostName(this.axisConfig);
        AxisConfigBuilder builder = new AxisConfigBuilder(in, this.axisConfig, (DeploymentEngine)this);
        builder.populateConfig();
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            String msg = "error in closing input stream";
            log.error((Object)msg, (Throwable)e);
        }
        this.axisConfig.setConfigurator((AxisConfigurator)this);
        Parameter disableArtifactLoading = this.axisConfig.getParameter("DisableArtifactLoading");
        if (disableArtifactLoading == null || "false".equals(disableArtifactLoading.getValue())) {
            this.moduleDeployer = new ModuleDeployer(this.axisConfig);
            new Axis2ModuleRegistry(this.axisConfig).register(this.moduleBundles);
            if (GhostDeployerUtils.isGhostOn()) {
                new GhostDeployerRegistry(this.axisConfig).register(this.deployerBundles);
            } else {
                new Axis2DeployerRegistry(this.axisConfig).register(this.deployerBundles);
            }
        }
        return this.axisConfig;
    }

    public void runDeployment() {
        this.schedulerTask.runAxisDeployment();
    }

    public void setRepoUpdateFailed() {
        this.schedulerTask.setRepoUpdateFailed();
    }

    protected void startSearch(RepositoryListener listener) {
        this.schedulerTask = new CarbonDeploymentSchedulerTask(listener, this.axisConfig, this.tenantId, this.tenantDomain);
        this.scheduler = Executors.newScheduledThreadPool(1);
        String deploymentInterval = CarbonCoreDataHolder.getInstance().getServerConfigurationService().getFirstProperty("Axis2Config.DeploymentUpdateInterval");
        int deploymentIntervalInt = 15;
        if (deploymentInterval != null) {
            deploymentIntervalInt = Integer.parseInt(deploymentInterval);
        }
        this.scheduler.scheduleWithFixedDelay((Runnable)((Object)this.schedulerTask), 0L, deploymentIntervalInt, TimeUnit.SECONDS);
    }

    public void cleanup() {
        this.scheduler.shutdown();
        super.cleanup();
        if (CarbonUtils.useRegistryBasedRepository()) {
            RegistryBasedRepositoryUpdater.cancelTask(this.repoLocation);
        }
    }

    private void setRegistry() throws DeploymentException {
        Parameter param = new Parameter("WSO2ConfigurationSystemRegistry", (Object)this.registry);
        try {
            this.axisConfig.addParameter(param);
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault.getMessage(), (Throwable)axisFault);
        }
    }

    private void setUserRealm() throws DeploymentException {
        Parameter param = new Parameter("WSO2UserRealm", (Object)this.registry.getUserRealm());
        try {
            this.axisConfig.addParameter(param);
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault.getMessage(), (Throwable)axisFault);
        }
    }

    private static void setHostName(AxisConfiguration axisConfig) throws DeploymentException {
        try {
            String hostName = CarbonCoreDataHolder.getInstance().getServerConfigurationService().getFirstProperty("HostName");
            if (hostName != null) {
                Parameter param = ParameterUtil.createParameter("hostname", hostName);
                axisConfig.addParameter(param);
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault.getMessage(), (Throwable)axisFault);
        }
    }
}

