/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpSession;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.user.api.TenantManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ThriftSession;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public final class SuperTenantCarbonContext
extends CarbonContext {
    private static CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();
    private static final Log log = LogFactory.getLog(SuperTenantCarbonContext.class);

    private SuperTenantCarbonContext(CarbonContextHolder carbonContextHolder) {
        super(carbonContextHolder);
    }

    public static void startTenantFlow() {
        SuperTenantCarbonContext.getCurrentContext().getCarbonContextHolder().startTenantFlow();
    }

    public static void endTenantFlow() {
        SuperTenantCarbonContext.getCurrentContext().getCarbonContextHolder().endTenantFlow();
    }

    public static SuperTenantCarbonContext getCurrentContext() {
        return new SuperTenantCarbonContext(null);
    }

    public static SuperTenantCarbonContext getCurrentContext(MessageContext messageContext) {
        return new SuperTenantCarbonContext(CarbonContextHolder.getCurrentCarbonContextHolder((MessageContext)messageContext));
    }

    public static SuperTenantCarbonContext getCurrentContext(ConfigurationContext configContext) {
        return new SuperTenantCarbonContext(CarbonContextHolder.getCurrentCarbonContextHolder((ConfigurationContext)configContext));
    }

    public static SuperTenantCarbonContext getCurrentContext(AxisConfiguration axisConfiguration) {
        return new SuperTenantCarbonContext(CarbonContextHolder.getCurrentCarbonContextHolder((AxisConfiguration)axisConfiguration));
    }

    public static SuperTenantCarbonContext getCurrentContext(AxisService axisService) {
        AxisConfiguration axisConfiguration = axisService.getAxisConfiguration();
        return axisConfiguration != null ? SuperTenantCarbonContext.getCurrentContext(axisConfiguration) : SuperTenantCarbonContext.getCurrentContext();
    }

    public static SuperTenantCarbonContext getCurrentContext(HttpSession httpSession) {
        return new SuperTenantCarbonContext(CarbonContextHolder.getCurrentCarbonContextHolder((HttpSession)httpSession));
    }

    public static SuperTenantCarbonContext getCurrentContext(ThriftSession thriftSession) {
        return new SuperTenantCarbonContext(CarbonContextHolder.getCurrentCarbonContextHolder((ThriftSession)thriftSession));
    }

    public void setTenantId(int tenantId) {
        this.setTenantId(tenantId, false);
    }

    public void setTenantId(int tenantId, boolean resolveTenantDomain) {
        this.getCarbonContextHolder().setTenantId(tenantId);
        if (!resolveTenantDomain || tenantId == -1234) {
            return;
        }
        this.resolveTenantDomain(tenantId);
    }

    public void setUsername(String username) {
        this.getCarbonContextHolder().setUsername(username);
    }

    public void setTenantDomain(String tenantDomain) {
        this.setTenantDomain(tenantDomain, false);
    }

    public void setTenantDomain(String tenantDomain, boolean resolveTenantId) {
        CarbonUtils.checkSecurity();
        this.getCarbonContextHolder().setTenantDomain(tenantDomain);
        if (!resolveTenantId) {
            return;
        }
        this.resolveTenantId(tenantDomain);
    }

    public String getTenantDomain(boolean resolve) {
        if (resolve && this.getTenantDomain() == null && (this.getTenantId() > 0 || this.getTenantId() == -1234)) {
            this.resolveTenantDomain(this.getTenantId());
        }
        return this.getTenantDomain();
    }

    public int getTenantId(boolean resolve) {
        if (resolve && this.getTenantId() == -1 && this.getTenantDomain() != null) {
            this.resolveTenantId(this.getTenantDomain());
        }
        return this.getTenantId();
    }

    private void resolveTenantDomain(int tenantId) {
        TenantManager tenantManager = this.getTenantManager();
        if (tenantManager != null) {
            try {
                log.debug((Object)"Resolving tenant domain from tenant id");
                this.setTenantDomain(tenantManager.getDomain(tenantId));
            }
            catch (UserStoreException userStoreException) {
                // empty catch block
            }
        }
    }

    private void resolveTenantId(String tenantDomain) {
        TenantManager tenantManager = this.getTenantManager();
        if (tenantManager != null) {
            try {
                log.debug((Object)"Resolving tenant id from tenant domain");
                this.setTenantId(tenantManager.getTenantId(tenantDomain));
            }
            catch (UserStoreException userStoreException) {
                // empty catch block
            }
        }
    }

    private TenantManager getTenantManager() {
        try {
            RealmService realmService = dataHolder.getRealmService();
            if (realmService != null) {
                return realmService.getTenantManager();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setRegistry(RegistryType type, Registry registry) {
        if (registry != null) {
            switch (type) {
                case USER_CONFIGURATION: {
                    log.trace((Object)"Setting config user registry instance.");
                    this.getCarbonContextHolder().setProperty("configUserRegistry", (Object)registry);
                    break;
                }
                case SYSTEM_CONFIGURATION: {
                    log.trace((Object)"Setting config system registry instance.");
                    this.getCarbonContextHolder().setProperty("configSystemRegistry", (Object)registry);
                    break;
                }
                case USER_GOVERNANCE: {
                    log.trace((Object)"Setting governance user registry instance.");
                    this.getCarbonContextHolder().setProperty("governanceUserRegistry", (Object)registry);
                    break;
                }
                case SYSTEM_GOVERNANCE: {
                    log.trace((Object)"Setting governance system registry instance.");
                    this.getCarbonContextHolder().setProperty("governanceSystemRegistry", (Object)registry);
                    break;
                }
                case LOCAL_REPOSITORY: {
                    log.trace((Object)"Setting local repository instance.");
                    this.getCarbonContextHolder().setProperty("localRepository", (Object)registry);
                }
            }
        }
    }

    public Registry getRegistry(RegistryType type) {
        Registry registry = super.getRegistry(type);
        if (registry != null) {
            return registry;
        }
        switch (type) {
            case SYSTEM_CONFIGURATION: {
                CarbonUtils.checkSecurity();
                try {
                    int tenantId = this.getTenantId();
                    if (tenantId != -1) {
                        registry = dataHolder.getRegistryService().getConfigSystemRegistry(tenantId);
                        this.setRegistry(RegistryType.SYSTEM_CONFIGURATION, registry);
                        return registry;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                return null;
            }
            case SYSTEM_GOVERNANCE: {
                CarbonUtils.checkSecurity();
                try {
                    int tenantId = this.getTenantId();
                    if (tenantId != -1) {
                        registry = dataHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
                        this.setRegistry(RegistryType.SYSTEM_GOVERNANCE, registry);
                        return registry;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public Cache getCache(String name) {
        return CacheManager.getInstance().getCache(name);
    }

    public void setUserRealm(UserRealm userRealm) {
        this.getCarbonContextHolder().setProperty("userRealm", (Object)userRealm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOSGiService(Class clazz) {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, clazz, null);
        try {
            serviceTracker.open();
            Object object = serviceTracker.getServices()[0];
            return object;
        }
        finally {
            serviceTracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getOSGiServices(Class clazz) {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, clazz, null);
        ArrayList<Object> services = new ArrayList<Object>();
        try {
            serviceTracker.open();
            Collections.addAll(services, serviceTracker.getServices());
        }
        finally {
            serviceTracker.close();
        }
        return services;
    }
}

