/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.utils.deployment.Axis2ModuleRegistry;

public class OSGiBundleDeployer
implements Deployer,
BundleListener {
    private static Log log = LogFactory.getLog(OSGiBundleDeployer.class);
    private BundleContext context;
    private AxisConfiguration axisConfig;
    private Axis2ModuleRegistry registry;

    public OSGiBundleDeployer(AxisConfiguration axisConfig, BundleContext context) {
        this.axisConfig = axisConfig;
        this.context = context;
        this.context.addBundleListener((BundleListener)this);
        this.registry = new Axis2ModuleRegistry(this.axisConfig);
    }

    public void init(ConfigurationContext configCtx) {
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        for (Bundle bundle : this.context.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.registry.register(bundle);
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
    }

    public void cleanup() throws DeploymentException {
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                if (this.context.getBundle() == bundle) break;
                this.registry.register(event.getBundle());
                break;
            }
            case 4: {
                if (this.context.getBundle() == bundle) break;
                this.registry.register(event.getBundle());
            }
        }
    }
}

