/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core;

import java.lang.management.ManagementPermission;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ManagementFactory;

public class ServerManagement {
    private static final Log log = LogFactory.getLog(ServerManagement.class);
    private static final long TIMEOUT = 60000L;
    private Map<String, TransportInDescription> inTransports;
    private ConfigurationContext serverConfigContext;

    public ServerManagement(Map<String, TransportInDescription> inTransports, ConfigurationContext serverConfigContext) {
        this.inTransports = inTransports;
        this.serverConfigContext = serverConfigContext;
    }

    public void startMaintenance() throws Exception {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        log.info((Object)"Starting to switch to maintenance mode...");
        for (TransportInDescription tinDesc : this.inTransports.values()) {
            TransportListener transport = tinDesc.getReceiver();
            transport.stop();
        }
        log.info((Object)"Stopped all transport listeners");
        this.waitForRequestCompletion();
    }

    public void startMaintenanceForShutDown() throws Exception {
        this.startMaintenance();
        this.waitForDeploymentThreadCompletion();
    }

    private void waitForDeploymentThreadCompletion() {
        boolean isDeploymentSchedulerRunning;
        CarbonUtils.checkSecurity();
        log.info((Object)"Waiting for deployment completion...");
        Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(this.serverConfigContext);
        this.serverConfigContext.getAxisConfiguration().getConfigurator().cleanup();
        for (ConfigurationContext tenantConfigCtx : tenantConfigContexts.values()) {
            tenantConfigCtx.getAxisConfiguration().getConfigurator().cleanup();
        }
        do {
            ConfigurationContext tenantConfigCtx;
            if (isDeploymentSchedulerRunning = this.isDeploymentSchedulerRunning(this.serverConfigContext)) continue;
            Iterator<ConfigurationContext> i$ = tenantConfigContexts.values().iterator();
            while (i$.hasNext() && !(isDeploymentSchedulerRunning = this.isDeploymentSchedulerRunning(tenantConfigCtx = i$.next()))) {
            }
        } while (isDeploymentSchedulerRunning);
        log.info((Object)"All deployment tasks have been completed.");
    }

    private boolean isDeploymentSchedulerRunning(ConfigurationContext configurationContext) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)configurationContext.getAxisConfiguration().getConfigurator();
        return deploymentEngine.isDeploymentTaskRunning();
    }

    public void waitForRequestCompletion() throws Exception {
        boolean areRequestsInService;
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        log.info((Object)"Waiting for request service completion...");
        MBeanServer mbs = ManagementFactory.getMBeanServer();
        long start = System.currentTimeMillis();
        do {
            QueryExp query;
            Set<ObjectName> set;
            if ((set = mbs.queryNames(new ObjectName("Catalina:type=RequestProcessor,*"), query = Query.eq(Query.attr("stage"), Query.value(3)))).size() > 0) {
                areRequestsInService = true;
                if (System.currentTimeMillis() - start > 60000L) {
                    log.warn((Object)"Timeout occurred even though there are active connections.");
                    break;
                }
                Thread.sleep(2000L);
                continue;
            }
            areRequestsInService = false;
        } while (areRequestsInService);
        log.info((Object)"All requests have been served.");
    }

    public void endMaintenance() throws Exception {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        log.info((Object)"Switching to normal mode...");
        for (TransportInDescription tinDesc : this.inTransports.values()) {
            TransportListener transport = tinDesc.getReceiver();
            transport.start();
        }
        log.info((Object)"Switched to normal mode");
    }
}

