/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.service;

import java.net.SocketException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.ServerManagement;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.common.ServerData;
import org.wso2.carbon.server.admin.common.ServerUpTime;
import org.wso2.carbon.server.admin.internal.ServerAdminDataHolder;
import org.wso2.carbon.server.admin.service.ServerAdminMBean;
import org.wso2.carbon.utils.Controllable;
import org.wso2.carbon.utils.NetworkUtils;

public class ServerAdmin
extends AbstractAdmin
implements ServerAdminMBean,
IServerAdmin {
    private static final Log log = LogFactory.getLog(ServerAdmin.class);
    private static final int SECONDS_PER_DAY = 86400;
    private ServerAdminDataHolder dataHolder = ServerAdminDataHolder.getInstance();

    @Override
    public ServerData getServerData() throws Exception {
        boolean isRestricted = true;
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        if (msgContext != null) {
            HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
                isRestricted = !this.getUserRealm().getAuthorizationManager().isUserAuthorized(userName, "/permission/protected/server-admin/homepage", "ui.execute");
            }
        } else {
            isRestricted = false;
        }
        String location = null;
        if (!isRestricted) {
            location = this.getAxisConfig().getRepository().toString();
        }
        ServerData data = new ServerData("WSO2", location, this.getTenantDomain() != null && this.getTenantDomain() != "carbon.super", isRestricted);
        if (!isRestricted) {
            Parameter systemStartTime = this.getAxisConfig().getParameter("wso2carbon.server.start.time");
            long startTime = 0L;
            if (systemStartTime != null) {
                startTime = Long.parseLong((String)systemStartTime.getValue());
            }
            Date stTime = new Date(startTime);
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
            data.setServerStartTime(dateFormatter.format(stTime));
            data.setServerUpTime(this.getTime((System.currentTimeMillis() - startTime) / 1000L));
            ServerConfigurationService serverConfig = this.dataHolder.getServerConfig();
            String registryType = serverConfig.getFirstProperty("Registry.Type");
            if (registryType == null) {
                registryType = "embedded";
            }
            data.setRegistryType(registryType);
            if (registryType.equals("embedded")) {
                try {
                    DataAccessManager dataAccessManager = RegistryContext.getBaseInstance().getDataAccessManager();
                    if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
                        String msg = "Failed to obtain DB connection. Invalid data access manager.";
                        log.error((Object)msg);
                        throw new AxisFault(msg);
                    }
                    DataSource dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
                    Connection dbConnection = dataSource.getConnection();
                    DatabaseMetaData metaData = dbConnection.getMetaData();
                    if (metaData != null) {
                        data.setDbName(metaData.getDatabaseProductName());
                        data.setDbVersion(metaData.getDatabaseProductVersion());
                        data.setDbDriverName(metaData.getDriverName());
                        data.setDbDriverVersion(metaData.getDriverVersion());
                        data.setDbURL(metaData.getURL());
                    }
                    dbConnection.close();
                }
                catch (SQLException e) {
                    String msg = "Cannot create DB connection";
                    log.error((Object)msg, (Throwable)e);
                    throw new AxisFault(msg, (Throwable)e);
                }
            } else if (registryType.equals("remote")) {
                data.setRemoteRegistryChroot(serverConfig.getFirstProperty("Registry.Chroot"));
                data.setRemoteRegistryURL(serverConfig.getFirstProperty("Registry.Url"));
            }
        }
        try {
            data.setServerIp(NetworkUtils.getLocalHostname());
        }
        catch (SocketException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    @Override
    public String getServerDataAsString() throws Exception {
        try {
            return this.getServerData().toString();
        }
        catch (AxisFault e) {
            String msg = "Cannot get server data";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    @Override
    public String getServerVersion() {
        return ServerConfiguration.getInstance().getFirstProperty("Version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restart() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.restart();
                    }
                    catch (Exception e) {
                        String msg = "Cannot restart server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restartGracefully() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.restartGracefully();
                    }
                    catch (Exception e) {
                        String msg = "Cannot restart server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown() throws AxisFault {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.shutdown();
                    }
                    catch (Exception e) {
                        String msg = "Cannot shutdown server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdownGracefully() throws AxisFault {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.shutdownGracefully();
                    }
                    catch (Exception e) {
                        String msg = "Cannot gracefully shutdown server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMaintenance() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            try {
                ServerStatus.setServerInMaintenance();
            }
            catch (AxisFault e) {
                String msg = "Cannot set server to maintenance mode";
                log.error((Object)msg, (Throwable)e);
            }
            HashMap inTransports = this.getAxisConfig().getTransportsIn();
            new ServerManagement((Map)inTransports, this.getConfigContext()).startMaintenance();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endMaintenance() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            HashMap inTransports = this.getAxisConfig().getTransportsIn();
            new ServerManagement((Map)inTransports, this.getConfigContext()).endMaintenance();
            try {
                ServerStatus.setServerRunning();
            }
            catch (AxisFault e) {
                String msg = "Cannot set server to running mode";
                log.error((Object)msg, (Throwable)e);
            }
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public String getServerStatus() throws Exception {
        return ServerStatus.getCurrentStatus();
    }

    private void invalidateSession() {
        block4: {
            MessageContext msgCtx = MessageContext.getCurrentMessageContext();
            if (msgCtx == null) {
                return;
            }
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            try {
                if (request != null) {
                    request.getSession().invalidate();
                }
            }
            catch (Exception ignored) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Ignore invalidation of invalidated sessions", (Throwable)ignored);
            }
        }
    }

    private ServerUpTime getTime(long timeInSeconds) {
        long days = timeInSeconds / 86400L;
        int hours = (int)((timeInSeconds -= days * 86400L) / 3600L);
        int minutes = (int)((timeInSeconds -= (long)hours * 3600L) / 60L);
        int seconds = (int)(timeInSeconds -= (long)minutes * 60L);
        return new ServerUpTime(days, hours, minutes, seconds);
    }
}

