/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.privilegedaction;

import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedAction;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedActionMessageReceiver;

public abstract class PrivilegedActionActivator {
    private static final Log log = LogFactory.getLog(PrivilegedActionActivator.class);
    private PrivilegedAction privilegedAction = null;

    protected void activate(ComponentContext ctxt) {
        this.privilegedAction = this.getServiceInstance();
        PrivilegedActionMessageReceiver.privilegedActions.add(this.privilegedAction);
        Collections.sort(PrivilegedActionMessageReceiver.privilegedActions, new PrivilegedActionComparator());
        if (log.isDebugEnabled()) {
            String msg = this.privilegedAction.getExtensionName() + "activated";
            log.debug((Object)msg);
        }
    }

    public abstract PrivilegedAction getServiceInstance();

    private static class PrivilegedActionComparator
    implements Comparator<PrivilegedAction> {
        private PrivilegedActionComparator() {
        }

        @Override
        public int compare(PrivilegedAction ex1, PrivilegedAction ex2) {
            return ex2.getPriority() - ex1.getPriority();
        }
    }
}

