/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryDSAvailabilityManager {
    private static final Log log = LogFactory.getLog(RegistryDSAvailabilityManager.class);
    public static final String REG_DS_AVAIL_MANAGE_BASE_PATH = "/repository/components/org.wso2.carbon.ndatasource/availability";
    private Registry registry = DataSourceUtils.getGovRegistryForTenant(-1234);

    public Registry getRegistry() {
        return this.registry;
    }

    private String generateDSAvailablePath(int tenantId) {
        return "/repository/components/org.wso2.carbon.ndatasource/availability/" + tenantId;
    }

    public boolean checkDSAvailable(int tenantId) throws DataSourceException {
        try {
            boolean result = this.registry.resourceExists(this.generateDSAvailablePath(tenantId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking data sources available for tenant: " + tenantId + ", result: " + result));
            }
            return result;
        }
        catch (RegistryException e) {
            throw new DataSourceException("Error in checking data sources availability: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void setDSAvailable(int tenantId, boolean exists) throws DataSourceException {
        try {
            if (exists) {
                this.getRegistry().put(this.generateDSAvailablePath(tenantId), this.getRegistry().newResource());
            } else {
                this.getRegistry().delete(this.generateDSAvailablePath(tenantId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting data sources available for tenant: " + tenantId + ", exists: " + exists));
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in setting data sources availability: " + e.getMessage(), e);
        }
    }
}

