/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceConstants;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.DataSourceRepository;
import org.wso2.carbon.ndatasource.core.SystemDataSourcesConfiguration;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class DataSourceManager {
    private static DataSourceManager instance = new DataSourceManager();
    private Map<Integer, DataSourceRepository> dsRepoMap;
    private Map<String, DataSourceReader> dsReaders = new HashMap<String, DataSourceReader>();

    public DataSourceManager() {
        this.dsRepoMap = new HashMap<Integer, DataSourceRepository>();
    }

    public static DataSourceManager getInstance() {
        return instance;
    }

    public DataSourceRepository getDataSourceRepository() throws DataSourceException {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        return this.getDataSourceRepository(tenantId);
    }

    private synchronized DataSourceRepository getDataSourceRepository(int tenantId) throws DataSourceException {
        DataSourceRepository dsRepo = this.dsRepoMap.get(tenantId);
        if (dsRepo == null) {
            dsRepo = new DataSourceRepository(tenantId);
            this.dsRepoMap.put(tenantId, dsRepo);
        }
        return dsRepo;
    }

    public void initAllTenants() throws DataSourceException {
        for (int tenantId : DataSourceUtils.getAllTenantIds()) {
            this.initTenant(tenantId);
        }
    }

    public void initTenant(int tenantId) throws DataSourceException {
        this.getDataSourceRepository(tenantId).initRepository();
    }

    public List<String> getDataSourceTypes() throws DataSourceException {
        if (this.dsReaders == null) {
            throw new DataSourceException("The data source readers are not initialized yet");
        }
        return new ArrayList<String>(this.dsReaders.keySet());
    }

    public DataSourceReader getDataSourceReader(String dsType) throws DataSourceException {
        if (this.dsReaders == null) {
            throw new DataSourceException("The data source readers are not initialized yet");
        }
        return this.dsReaders.get(dsType);
    }

    private void addDataSourceProviders(List<String> providers) throws DataSourceException {
        if (providers == null) {
            return;
        }
        for (String provider : providers) {
            try {
                DataSourceReader tmpReader = (DataSourceReader)Class.forName(provider).newInstance();
                this.dsReaders.put(tmpReader.getType(), tmpReader);
            }
            catch (Exception e) {
                throw new DataSourceException("Error in loading data source provider: " + e.getMessage(), e);
            }
        }
    }

    public void initSystemDataSources() throws DataSourceException {
        try {
            String dataSourcesDir = CarbonUtils.getCarbonConfigDirPath() + File.separator + DataSourceConstants.DATASOURCES_DIRECTORY_NAME;
            File masterDSFile = new File(dataSourcesDir + File.separator + DataSourceConstants.MASTER_DS_FILE_NAME);
            if (masterDSFile.exists()) {
                this.initSystemDataSource(masterDSFile);
            }
            File dataSourcesFolder = new File(dataSourcesDir);
            for (File sysDSFile : dataSourcesFolder.listFiles()) {
                if (!sysDSFile.getName().endsWith(DataSourceConstants.SYS_DS_FILE_NAME_SUFFIX) || sysDSFile.getName().equals(DataSourceConstants.MASTER_DS_FILE_NAME)) continue;
                this.initSystemDataSource(sysDSFile);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in initializing system data sources: " + e.getMessage(), e);
        }
    }

    private void initSystemDataSource(File sysDSFile) throws DataSourceException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemDataSourcesConfiguration.class});
            SystemDataSourcesConfiguration sysDS = (SystemDataSourcesConfiguration)ctx.createUnmarshaller().unmarshal(sysDSFile);
            this.addDataSourceProviders(sysDS.getProviders());
            DataSourceRepository dsRepo = this.getDataSourceRepository(-1234);
            for (DataSourceMetaInfo dsmInfo : sysDS.getDataSources()) {
                dsmInfo.setSystem(true);
                dsRepo.addDataSource(DataSourceUtils.secureLoadDSMInfo(dsmInfo, true));
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in initializing system data sources at '" + sysDSFile.getAbsolutePath() + "' - " + e.getMessage(), e);
        }
    }
}

