/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.util.BitSet;
import org.h2.engine.Session;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageFreeList
extends Page {
    private static final int DATA_START = 3;
    private final PageStore store;
    private final BitSet used = new BitSet();
    private final int pageCount;
    private boolean full;
    private Data data;

    private PageFreeList(PageStore pageStore, int n) {
        this.setPos(n);
        this.store = pageStore;
        this.pageCount = (pageStore.getPageSize() - 3) * 8;
        this.used.set(0);
    }

    static PageFreeList read(PageStore pageStore, Data data, int n) {
        PageFreeList pageFreeList = new PageFreeList(pageStore, n);
        pageFreeList.data = data;
        pageFreeList.read();
        return pageFreeList;
    }

    static PageFreeList create(PageStore pageStore, int n) {
        return new PageFreeList(pageStore, n);
    }

    int allocate(BitSet bitSet, int n) {
        int n2;
        block4: {
            if (this.full) {
                return -1;
            }
            int n3 = Math.max(0, n - this.getPos());
            do {
                if ((n2 = this.used.nextClearBit(n3)) >= this.pageCount) {
                    if (n3 == 0) {
                        this.full = true;
                    }
                    return -1;
                }
                if (bitSet == null || !bitSet.get(n2 + this.getPos())) break block4;
            } while ((n3 = bitSet.nextClearBit(n2 + this.getPos()) - this.getPos()) < this.pageCount);
            return -1;
        }
        this.used.set(n2);
        this.store.logUndo(this, this.data);
        this.store.update(this);
        return n2 + this.getPos();
    }

    int getFirstFree() {
        if (this.full) {
            return -1;
        }
        int n = this.used.nextClearBit(0);
        if (n >= this.pageCount) {
            return -1;
        }
        return n + this.getPos();
    }

    int getLastUsed() {
        int n = this.used.length() - 1;
        return n <= 0 ? -1 : n + this.getPos();
    }

    int allocate(int n) {
        int n2 = n - this.getPos();
        if (n2 >= 0 && !this.used.get(n2)) {
            this.used.set(n2);
            this.store.logUndo(this, this.data);
            this.store.update(this);
        }
        return n;
    }

    void free(int n) {
        this.full = false;
        this.store.logUndo(this, this.data);
        this.used.clear(n - this.getPos());
        this.store.update(this);
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        for (int i = 0; i < this.pageCount; i += 8) {
            int n = this.data.readByte() & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1 << j) == 0) continue;
                this.used.set(i + j);
            }
        }
        this.full = false;
    }

    @Override
    public void write() {
        this.data = this.store.createData();
        this.data.writeByte((byte)6);
        this.data.writeShortInt(0);
        for (int i = 0; i < this.pageCount; i += 8) {
            int n = 0;
            for (int j = 0; j < 8; ++j) {
                if (!this.used.get(i + j)) continue;
                n += 1 << j;
            }
            this.data.writeByte((byte)n);
        }
        this.store.writePage(this.getPos(), this.data);
    }

    public static int getPagesAddressed(int n) {
        return (n - 3) * 8;
    }

    @Override
    public int getMemory() {
        return this.store.getPageSize() >> 2;
    }

    boolean isUsed(int n) {
        return this.used.get(n - this.getPos());
    }

    @Override
    public void moveTo(Session session, int n) {
        this.store.free(this.getPos(), false);
    }

    public String toString() {
        return "page [" + this.getPos() + "] freeList" + (this.full ? "full" : "");
    }

    @Override
    public boolean canRemove() {
        return false;
    }
}

