/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private static final int MAX_LOAD = 90;
    private static final WeakReference<Object> DELETED_KEY = new WeakReference<Object>(null);
    private int mask;
    private int len;
    private int size;
    private int deletedCount;
    private int level;
    private int maxSize;
    private int minSize;
    private int maxDeleted;
    private WeakReference<K>[] keys;
    private V[] values;

    public WeakIdentityHashMap() {
        this.reset(2);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void checkSizePut() {
        if (this.deletedCount > this.size) {
            this.rehash(this.level);
        }
        if (this.size + this.deletedCount >= this.maxSize) {
            this.rehash(this.level + 1);
        }
    }

    private void checkSizeRemove() {
        if (this.size < this.minSize && this.level > 0) {
            this.rehash(this.level - 1);
        } else if (this.deletedCount > this.maxDeleted) {
            this.rehash(this.level);
        }
    }

    private int getIndex(Object object) {
        return System.identityHashCode(object) & this.mask;
    }

    private void reset(int n) {
        this.minSize = this.size * 3 / 4;
        this.size = 0;
        this.level = n;
        this.len = 2 << this.level;
        this.mask = this.len - 1;
        this.maxSize = (int)((long)(this.len * 90) / 100L);
        this.deletedCount = 0;
        this.maxDeleted = 20 + this.len / 2;
        this.keys = new WeakReference[this.len];
        this.values = new Object[this.len];
    }

    @Override
    public V put(K k, V v) {
        this.checkSizePut();
        int n = this.getIndex(k);
        int n2 = 1;
        int n3 = -1;
        do {
            WeakReference<K> weakReference;
            if ((weakReference = this.keys[n]) == null) {
                if (n3 >= 0) {
                    n = n3;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[n] = new WeakReference<K>(k);
                this.values[n] = v;
                return null;
            }
            if (weakReference == DELETED_KEY) {
                if (n3 < 0) {
                    n3 = n;
                }
            } else {
                Object t = weakReference.get();
                if (t == null) {
                    this.delete(n);
                } else if (t == k) {
                    V v2 = this.values[n];
                    this.values[n] = v;
                    return v2;
                }
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        throw new RuntimeException("Hashmap is full");
    }

    @Override
    public V remove(Object object) {
        this.checkSizeRemove();
        int n = this.getIndex(object);
        int n2 = 1;
        do {
            WeakReference<K> weakReference;
            if ((weakReference = this.keys[n]) == null) {
                return null;
            }
            if (weakReference != DELETED_KEY) {
                Object t = weakReference.get();
                if (t == null) {
                    this.delete(n);
                } else if (t == object) {
                    V v = this.values[n];
                    this.delete(n);
                    return v;
                }
            }
            n = n + n2++ & this.mask;
            weakReference = this.keys[n];
        } while (n2 <= this.len);
        return null;
    }

    private void delete(int n) {
        this.keys[n] = DELETED_KEY;
        this.values[n] = null;
        ++this.deletedCount;
        --this.size;
    }

    private void rehash(int n) {
        WeakReference<K>[] weakReferenceArray = this.keys;
        V[] VArray = this.values;
        this.reset(n);
        for (int i = 0; i < weakReferenceArray.length; ++i) {
            Object t;
            WeakReference<K> weakReference = weakReferenceArray[i];
            if (weakReference == null || weakReference == DELETED_KEY || (t = weakReference.get()) == null) continue;
            this.put(t, VArray[i]);
        }
    }

    @Override
    public V get(Object object) {
        int n = this.getIndex(object);
        int n2 = 1;
        do {
            WeakReference<K> weakReference;
            if ((weakReference = this.keys[n]) == null) {
                return null;
            }
            if (weakReference != DELETED_KEY) {
                Object t = weakReference.get();
                if (t == null) {
                    this.delete(n);
                } else if (t == object) {
                    return this.values[n];
                }
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        return null;
    }

    @Override
    public void clear() {
        this.reset(2);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        for (V v : this.values) {
            if (!object.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }
}

