/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu.bytecode;

import org.h2.jaqu.Query;
import org.h2.jaqu.SQLStatement;
import org.h2.jaqu.Token;

class Operation
implements Token {
    private final Token left;
    private final Token right;
    private final Type op;

    private Operation(Token token, Type type, Token token2) {
        this.left = token;
        this.op = type;
        this.right = token2;
    }

    static Token get(Token token, Type type, Token token2) {
        if (type == Type.NOT_EQUALS && "0".equals(token2.toString())) {
            return token;
        }
        return new Operation(token, type, token2);
    }

    public String toString() {
        return this.left + " " + (Object)((Object)this.op) + " " + this.right;
    }

    public Token reverse() {
        return Operation.get(this.left, this.op.reverse(), this.right);
    }

    @Override
    public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
        this.left.appendSQL(sQLStatement, query);
        sQLStatement.appendSQL(this.op.toString());
        this.right.appendSQL(sQLStatement, query);
    }

    static enum Type {
        EQUALS("="){

            @Override
            Type reverse() {
                return NOT_EQUALS;
            }
        }
        ,
        NOT_EQUALS("<>"){

            @Override
            Type reverse() {
                return EQUALS;
            }
        }
        ,
        BIGGER(">"){

            @Override
            Type reverse() {
                return SMALLER_EQUALS;
            }
        }
        ,
        BIGGER_EQUALS(">="){

            @Override
            Type reverse() {
                return SMALLER;
            }
        }
        ,
        SMALLER_EQUALS("<="){

            @Override
            Type reverse() {
                return BIGGER;
            }
        }
        ,
        SMALLER("<"){

            @Override
            Type reverse() {
                return BIGGER_EQUALS;
            }
        }
        ,
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MOD("%");

        private String name;

        private Type(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        Type reverse() {
            return null;
        }
    }
}

