/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import java.util.List;
import org.h2.jaqu.ConditionAndOr;
import org.h2.jaqu.OrderExpression;
import org.h2.jaqu.Query;
import org.h2.jaqu.QueryCondition;
import org.h2.jaqu.SQLStatement;

public class QueryWhere<T> {
    Query<T> query;

    QueryWhere(Query<T> query) {
        this.query = query;
    }

    public <A> QueryCondition<T, A> and(A a) {
        this.query.addConditionToken(ConditionAndOr.AND);
        return new QueryCondition<T, A>(this.query, a);
    }

    public <A> QueryCondition<T, A> or(A a) {
        this.query.addConditionToken(ConditionAndOr.OR);
        return new QueryCondition<T, A>(this.query, a);
    }

    public <X, Z> List<X> select(Z z) {
        return this.query.select(z);
    }

    public String getSQL() {
        SQLStatement sQLStatement = new SQLStatement(this.query.getDb());
        sQLStatement.appendSQL("*");
        return this.query.prepare(sQLStatement, false).getSQL().trim();
    }

    public <X, Z> List<X> selectDistinct(Z z) {
        return this.query.selectDistinct(z);
    }

    public <X, Z> X selectFirst(Z z) {
        List list = this.query.select(z);
        return list.isEmpty() ? null : (X)list.get(0);
    }

    public List<T> select() {
        return this.query.select();
    }

    public T selectFirst() {
        List<T> list = this.select();
        return list.isEmpty() ? null : (T)list.get(0);
    }

    public List<T> selectDistinct() {
        return this.query.selectDistinct();
    }

    public QueryWhere<T> orderBy(Object ... objectArray) {
        for (Object object : objectArray) {
            OrderExpression<T> orderExpression = new OrderExpression<T>(this.query, object, false, false, false);
            this.query.addOrderBy(orderExpression);
        }
        return this;
    }

    public QueryWhere<T> orderByNullsFirst(Object object) {
        OrderExpression<T> orderExpression = new OrderExpression<T>(this.query, object, false, true, false);
        this.query.addOrderBy(orderExpression);
        return this;
    }

    public QueryWhere<T> orderByNullsLast(Object object) {
        OrderExpression<T> orderExpression = new OrderExpression<T>(this.query, object, false, false, true);
        this.query.addOrderBy(orderExpression);
        return this;
    }

    public QueryWhere<T> orderByDesc(Object object) {
        OrderExpression<T> orderExpression = new OrderExpression<T>(this.query, object, true, false, false);
        this.query.addOrderBy(orderExpression);
        return this;
    }

    public QueryWhere<T> orderByDescNullsFirst(Object object) {
        OrderExpression<T> orderExpression = new OrderExpression<T>(this.query, object, true, true, false);
        this.query.addOrderBy(orderExpression);
        return this;
    }

    public QueryWhere<T> orderByDescNullsLast(Object object) {
        OrderExpression<T> orderExpression = new OrderExpression<T>(this.query, object, true, false, true);
        this.query.addOrderBy(orderExpression);
        return this;
    }

    public int delete() {
        return this.query.delete();
    }

    public long selectCount() {
        return this.query.selectCount();
    }
}

