/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import org.h2.jaqu.Db;
import org.h2.jaqu.Query;
import org.h2.jaqu.SQLStatement;
import org.h2.jaqu.Token;
import org.h2.jaqu.util.Utils;

public class Function
implements Token {
    private static final Long COUNT_STAR = new Long(0L);
    protected Object[] x;
    private String name;

    protected Function(String string, Object ... objectArray) {
        this.name = string;
        this.x = objectArray;
    }

    @Override
    public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
        sQLStatement.appendSQL(this.name).appendSQL("(");
        int n = 0;
        for (Object object : this.x) {
            if (n++ > 0) {
                sQLStatement.appendSQL(",");
            }
            query.appendSQL(sQLStatement, object);
        }
        sQLStatement.appendSQL(")");
    }

    public static Long count() {
        return COUNT_STAR;
    }

    public static Integer length(Object object) {
        return Db.registerToken(Utils.newObject(Integer.class), new Function("LENGTH", object));
    }

    public static <T extends Number> T sum(T t) {
        return (T)((Number)Db.registerToken(Utils.newObject(t.getClass()), new Function("SUM", t)));
    }

    public static Long count(Object object) {
        return Db.registerToken(Utils.newObject(Long.class), new Function("COUNT", object));
    }

    public static Boolean isNull(Object object) {
        return Db.registerToken(Utils.newObject(Boolean.class), new Function("", new Object[]{object}){

            @Override
            public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
                query.appendSQL(sQLStatement, this.x[0]);
                sQLStatement.appendSQL(" IS NULL");
            }
        });
    }

    public static Boolean isNotNull(Object object) {
        return Db.registerToken(Utils.newObject(Boolean.class), new Function("", new Object[]{object}){

            @Override
            public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
                query.appendSQL(sQLStatement, this.x[0]);
                sQLStatement.appendSQL(" IS NOT NULL");
            }
        });
    }

    public static Boolean not(Boolean bl) {
        return Db.registerToken(Utils.newObject(Boolean.class), new Function("", new Object[]{bl}){

            @Override
            public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
                sQLStatement.appendSQL("NOT ");
                query.appendSQL(sQLStatement, this.x[0]);
            }
        });
    }

    public static Boolean or(Boolean ... booleanArray) {
        return Db.registerToken(Utils.newObject(Boolean.class), new Function("", booleanArray){

            @Override
            public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
                int n = 0;
                for (Object object : this.x) {
                    if (n++ > 0) {
                        sQLStatement.appendSQL(" OR ");
                    }
                    query.appendSQL(sQLStatement, object);
                }
            }
        });
    }

    public static Boolean and(Boolean ... booleanArray) {
        return Db.registerToken(Utils.newObject(Boolean.class), new Function("", booleanArray){

            @Override
            public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
                int n = 0;
                for (Object object : this.x) {
                    if (n++ > 0) {
                        sQLStatement.appendSQL(" AND ");
                    }
                    query.appendSQL(sQLStatement, object);
                }
            }
        });
    }

    public static <X> X min(X x) {
        Class<?> clazz = x.getClass();
        Object obj = Utils.newObject(clazz);
        return (X)Db.registerToken(obj, new Function("MIN", x));
    }

    public static <X> X max(X x) {
        Class<?> clazz = x.getClass();
        Object obj = Utils.newObject(clazz);
        return (X)Db.registerToken(obj, new Function("MAX", x));
    }

    public static Boolean like(String string, String string2) {
        Boolean bl = Utils.newObject(Boolean.class);
        return Db.registerToken(bl, new Function("LIKE", new Object[]{string, string2}){

            @Override
            public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
                sQLStatement.appendSQL("(");
                query.appendSQL(sQLStatement, this.x[0]);
                sQLStatement.appendSQL(" LIKE ");
                query.appendSQL(sQLStatement, this.x[1]);
                sQLStatement.appendSQL(")");
            }
        });
    }
}

