/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.fulltext.FullText;
import org.h2.fulltext.IndexInfo;
import org.h2.util.New;
import org.h2.util.SoftHashMap;

public class FullTextSettings {
    protected static final HashMap<String, FullTextSettings> SETTINGS = New.hashMap();
    protected boolean initialized;
    protected HashSet<String> ignoreList = New.hashSet();
    protected HashMap<String, Integer> words = New.hashMap();
    protected HashMap<Integer, IndexInfo> indexes = New.hashMap();
    protected SoftHashMap<String, PreparedStatement> cache = new SoftHashMap();

    protected FullTextSettings() {
    }

    protected HashSet<String> getIgnoreList() {
        return this.ignoreList;
    }

    protected HashMap<String, Integer> getWordList() {
        return this.words;
    }

    protected IndexInfo getIndexInfo(int n) {
        return this.indexes.get(n);
    }

    protected void addIndexInfo(IndexInfo indexInfo) {
        this.indexes.put(indexInfo.id, indexInfo);
    }

    protected String convertWord(String string) {
        if (this.ignoreList.contains(string = string.toUpperCase())) {
            return null;
        }
        return string;
    }

    protected static FullTextSettings getInstance(Connection connection) throws SQLException {
        String string = FullTextSettings.getIndexPath(connection);
        FullTextSettings fullTextSettings = SETTINGS.get(string);
        if (fullTextSettings == null) {
            fullTextSettings = new FullTextSettings();
            SETTINGS.put(string, fullTextSettings);
        }
        return fullTextSettings;
    }

    protected static String getIndexPath(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL IFNULL(DATABASE_PATH(), 'MEM:' || DATABASE())");
        resultSet.next();
        String string = resultSet.getString(1);
        if ("MEM:UNNAMED".equals(string)) {
            throw FullText.throwException("Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        resultSet.close();
        return string;
    }

    protected synchronized PreparedStatement prepare(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.cache.get(string);
        if (preparedStatement != null && preparedStatement.getConnection().isClosed()) {
            preparedStatement = null;
        }
        if (preparedStatement == null) {
            preparedStatement = connection.prepareStatement(string);
            this.cache.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    protected void removeAllIndexes() {
        this.indexes.clear();
    }

    protected void removeIndexInfo(IndexInfo indexInfo) {
        this.indexes.remove(indexInfo.id);
    }

    protected void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected static void closeAll() {
        SETTINGS.clear();
    }
}

