/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.store.FileLister;
import org.h2.store.PageStore;
import org.h2.util.IOUtils;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression expression) {
        this.fileNameExpr = expression;
    }

    @Override
    public int update() {
        String string = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string) {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            String string2 = database.getName();
            string2 = IOUtils.getFileName(string2);
            OutputStream outputStream = IOUtils.openFileOutputStream(string, false);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            database.flush();
            String string3 = database.getName() + ".h2.db";
            this.backupPageStore(zipOutputStream, string3, database.getPageStore());
            String string4 = IOUtils.getParent(string3);
            Object object = database.getLobSyncObject();
            synchronized (object) {
                String string5 = database.getDatabasePath();
                String string6 = IOUtils.getParent(string5);
                ArrayList<String> arrayList = FileLister.getDatabaseFiles(string6, string2, true);
                for (String string7 : arrayList) {
                    if (!string7.endsWith(".lob.db")) continue;
                    this.backupFile(zipOutputStream, string4, string7);
                }
            }
            zipOutputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    private void backupPageStore(ZipOutputStream zipOutputStream, String string, PageStore pageStore) throws IOException {
        Database database = this.session.getDatabase();
        string = IOUtils.getFileName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = pageStore.getPageCount();
        int n2 = 0;
        while ((n2 = pageStore.copyDirect(n2, zipOutputStream)) >= 0) {
            database.setProgress(3, string, n2, n);
        }
        zipOutputStream.closeEntry();
    }

    private void backupFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        String string3 = IOUtils.getAbsolutePath(string2);
        if (!string3.startsWith(string = IOUtils.getAbsolutePath(string))) {
            DbException.throwInternalError(string3 + " does not start with " + string);
        }
        string3 = string3.substring(string.length());
        string3 = BackupCommand.correctFileName(string3);
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        InputStream inputStream = IOUtils.openFileInputStream(string2);
        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }
}

