/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;

public class DropSchema
extends DefineCommand {
    private String schemaName;
    private boolean ifExists;

    public DropSchema(Session session) {
        super(session);
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Schema schema = database.findSchema(this.schemaName);
        if (schema == null) {
            if (!this.ifExists) {
                throw DbException.get(90079, this.schemaName);
            }
        } else {
            if (!schema.canDrop()) {
                throw DbException.get(90090, this.schemaName);
            }
            database.removeDatabaseObject(this.session, schema);
        }
        return 0;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }
}

