/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.AffiliateMember;
import org.opensaml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Attr;

public class AffiliationDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)parentSAMLObject;
        if (childSAMLObject instanceof Extensions) {
            descriptor.setExtensions((Extensions)childSAMLObject);
        } else if (childSAMLObject instanceof Signature) {
            descriptor.setSignature((Signature)childSAMLObject);
        } else if (childSAMLObject instanceof AffiliateMember) {
            descriptor.getMembers().add((AffiliateMember)childSAMLObject);
        } else if (childSAMLObject instanceof KeyDescriptor) {
            descriptor.getKeyDescriptors().add((KeyDescriptor)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)samlObject;
        if (attribute.getLocalName().equals("affiliationOwnerID")) {
            descriptor.setOwnerID(attribute.getValue());
        } else if (attribute.getLocalName().equals("ID")) {
            descriptor.setID(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else if (attribute.getLocalName().equals("validUntil") && !DatatypeHelper.isEmpty(attribute.getValue())) {
            descriptor.setValidUntil(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if (attribute.getLocalName().equals("cacheDuration")) {
            descriptor.setCacheDuration(XMLHelper.durationToLong(attribute.getValue()));
        } else {
            QName attribQName = XMLHelper.getNodeQName(attribute);
            if (attribute.isId()) {
                descriptor.getUnknownAttributes().registerID(attribQName);
            }
            descriptor.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }
}

