/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.bootup.validator.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.core.bootup.validator.ConfigurationValidator;
import org.wso2.carbon.core.bootup.validator.util.ConfigValidationXMLProcessor;
import org.wso2.carbon.core.bootup.validator.util.ValidationResult;
import org.wso2.carbon.core.bootup.validator.util.ValidationResultPrinter;

public class BootupValidationActivator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(BootupValidationActivator.class);
    private ConfigValidationXMLProcessor configXMLProcessor;
    private List<ConfigurationValidator> validators;
    private Map<String, ValidationResult> allResults = new HashMap<String, ValidationResult>();

    public void start(BundleContext bundleContext) {
        try {
            this.configXMLProcessor = new ConfigValidationXMLProcessor();
            this.configXMLProcessor.parseConfigValidationXml();
            if (ConfigValidationXMLProcessor.isActivated()) {
                log.debug((Object)"Bootup Validator is activated...");
                this.validators = this.configXMLProcessor.getValidators();
                this.validateConfigurations(this.validators);
                this.printWarnings();
            } else {
                log.debug((Object)"Bootup Validator is disabled...");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while starting Bootup Validation Activator", (Throwable)e);
        }
    }

    private void validateConfigurations(List<ConfigurationValidator> configValidators) {
        for (ConfigurationValidator validator : configValidators) {
            Map<String, ValidationResult> results = validator.validate();
            this.allResults.putAll(results);
        }
    }

    private void printWarnings() {
        ValidationResultPrinter.logConsoleWarnings(this.allResults);
    }

    public void stop(BundleContext arg0) throws Exception {
    }
}

