/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.feature.mgt.stub.RepositoryAdminServiceCallbackHandler;
import org.wso2.carbon.feature.mgt.stub.RepositoryAdminServiceStub;
import org.wso2.carbon.feature.mgt.stub.prov.data.Feature;
import org.wso2.carbon.feature.mgt.stub.prov.data.FeatureInfo;
import org.wso2.carbon.feature.mgt.stub.prov.data.RepositoryInfo;
import org.wso2.carbon.feature.mgt.ui.FeatureWrapper;
import org.wso2.carbon.feature.mgt.ui.util.Utils;

public class RepositoryAdminServiceClient {
    private static final Log log = LogFactory.getLog(RepositoryAdminServiceClient.class);
    private static final String BUNDLE = "org.wso2.carbon.feature.mgt.ui.i18n.Resources";
    private ResourceBundle bundle;
    public static final String ENABLED = "Enabled";
    public static final String DISABLED = "Disabled";
    public static String AVAILABLE_FEATURES = "available.features";
    private boolean isComplete = false;
    private boolean isError = false;
    private Exception exception;
    public RepositoryAdminServiceStub repositoryAdminServiceStub;
    RepositoryAdminServiceCallbackHandler callback = new RepositoryAdminServiceCallbackHandler(){

        public void receiveResultaddRepository(boolean result) {
            RepositoryAdminServiceClient.this.isComplete = true;
        }

        public void receiveErroraddRepository(Exception e) {
            RepositoryAdminServiceClient.this.isError = true;
            RepositoryAdminServiceClient.this.exception = e;
        }
    };

    public RepositoryAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext, Locale locale) throws Exception {
        try {
            this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
            String serviceURL = backendServerURL + "RepositoryAdminService";
            this.repositoryAdminServiceStub = new RepositoryAdminServiceStub(configContext, serviceURL);
            ServiceClient client = this.repositoryAdminServiceStub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addRepository(String repoURL, String nickName, boolean localRepo) throws Exception {
        if (nickName == null || nickName.length() == 0) {
            throw new Exception(this.bundle.getString("missing.repo.name"));
        }
        if (repoURL == null || repoURL.length() == 0) {
            throw new Exception(this.bundle.getString("missing.repo.location"));
        }
        URI uri = null;
        if (localRepo) {
            repoURL = repoURL.replaceAll("\\b\\s+\\b", "%20");
            if (!(repoURL = repoURL.replace('\\', '/')).startsWith("file:") && repoURL.startsWith("/")) {
                repoURL = "file://" + repoURL;
            } else if (!repoURL.startsWith("file:")) {
                repoURL = "file:///" + repoURL;
            }
        } else {
            try {
                uri = new URI(repoURL);
                String scheme = uri.getScheme();
                if (!(scheme.equals("http") || scheme.equals("https") || scheme.equals("file"))) {
                    throw new Exception(MessageFormat.format(this.bundle.getString("invalid.url.protocol"), scheme));
                }
            }
            catch (URISyntaxException e) {
                throw new Exception(MessageFormat.format(this.bundle.getString("invalid.repo.location"), ""));
            }
        }
        try {
            ServiceClient client = this.repositoryAdminServiceStub._getServiceClient();
            client.engageModule("addressing");
            Options options = client.getOptions();
            options.setUseSeparateListener(true);
            options.setTransportInProtocol("http");
            this.repositoryAdminServiceStub.startaddRepository(repoURL, nickName, this.callback);
            this.handleCallback();
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(MessageFormat.format(this.bundle.getString(e.getFaultCode().getLocalPart()), repoURL), (Exception)((Object)e));
            }
            this.handleException(MessageFormat.format(this.bundle.getString("failed.add.repository"), repoURL), (Exception)((Object)e));
        }
    }

    public RepositoryInfo[] getAllRepositories() throws Exception {
        RepositoryInfo[] repositoryInfo = null;
        try {
            repositoryInfo = this.repositoryAdminServiceStub.getAllRepositories();
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.get.repositories"), (Exception)((Object)e));
        }
        return repositoryInfo;
    }

    public RepositoryInfo[] getEnabledRepositories() throws Exception {
        RepositoryInfo[] repositoryInfo = null;
        try {
            return this.repositoryAdminServiceStub.getEnabledRepositories();
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            } else {
                this.handleException(this.bundle.getString("failed.get.repositories"), (Exception)((Object)e));
            }
            return repositoryInfo;
        }
    }

    public void updateRepository(String prevLocation, String prevNickName, String updatedLocation, String updatedNickName) throws Exception {
        try {
            this.repositoryAdminServiceStub.updateRepository(prevLocation, prevNickName, updatedLocation, updatedNickName);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(MessageFormat.format(this.bundle.getString(e.getFaultCode().getLocalPart()), updatedLocation), (Exception)((Object)e));
            }
            this.handleException(MessageFormat.format(this.bundle.getString("failed.update.repository"), updatedLocation), (Exception)((Object)e));
        }
    }

    public void removeRepository(String location) throws Exception {
        try {
            this.repositoryAdminServiceStub.removeRepository(location);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(MessageFormat.format(this.bundle.getString(e.getFaultCode().getLocalPart()), location), (Exception)((Object)e));
            }
            this.handleException(MessageFormat.format(this.bundle.getString("failed.remove.repository"), location), (Exception)((Object)e));
        }
    }

    public void enableRepository(String location, String enabled) throws Exception {
        try {
            boolean isEnabled = false;
            if (ENABLED.equals(enabled)) {
                isEnabled = true;
            }
            this.repositoryAdminServiceStub.enableRepository(location, isEnabled);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(MessageFormat.format(this.bundle.getString(e.getFaultCode().getLocalPart()), location), (Exception)((Object)e));
            }
            this.handleException(MessageFormat.format(this.bundle.getString("failed.enable.repository"), location), (Exception)((Object)e));
        }
    }

    public FeatureWrapper[] getInstallableFeatures(String repoLocation, boolean groupByCategory, boolean hideInstalledFeatures, boolean showOnlyTheLatestFeatures) throws Exception {
        FeatureWrapper[] featureWrappers = null;
        try {
            Feature[] features;
            if ("ALL_REPOS".equals(repoLocation)) {
                repoLocation = null;
            }
            featureWrappers = (features = this.repositoryAdminServiceStub.getInstallableFeatures(repoLocation, groupByCategory, hideInstalledFeatures, showOnlyTheLatestFeatures)) == null || features.length == 0 ? new FeatureWrapper[]{} : Utils.processFeatureTree(features, 0);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.get.installable.features"), (Exception)((Object)e));
        }
        return featureWrappers;
    }

    public FeatureInfo getInstallableFeatureDetails(String featureID, String featureVersion) throws Exception {
        FeatureInfo featureInfo = null;
        try {
            return this.repositoryAdminServiceStub.getInstallableFeatureInfo(featureID, featureVersion);
        }
        catch (AxisFault e) {
            this.handleException(MessageFormat.format(this.bundle.getString(e.getMessage()), featureID, featureVersion), (Exception)((Object)e));
            if (e.getFaultCode() != null) {
                this.handleException(MessageFormat.format(this.bundle.getString(e.getFaultCode().getLocalPart()), featureID, featureVersion), (Exception)((Object)e));
            } else {
                this.handleException(MessageFormat.format(this.bundle.getString("failed.get.feature.information"), featureID, featureVersion), (Exception)((Object)e));
            }
            return featureInfo;
        }
    }

    private void handleCallback() throws Exception {
        int i = 0;
        while (!this.isComplete && !this.isError) {
            Thread.sleep(500L);
            if (++i <= 288000) continue;
            throw new Exception("Response not received within 4 hours");
        }
        if (this.isError) {
            this.isError = false;
            throw this.exception;
        }
        this.isComplete = false;
    }

    private void handleException(String msg, Exception e) throws Exception {
        log.error((Object)msg, (Throwable)e);
        throw new Exception(msg, e);
    }
}

