/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.tracker;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.tracker.AuthenticatorComparator;

public class AuthenticatorRegistry {
    private static Log log = LogFactory.getLog(AuthenticatorRegistry.class);
    private static ServiceTracker authTracker;
    public static final String AUTHENTICATOR_TYPE = "authenticator.type";

    public static void init(BundleContext bc) throws Exception {
        try {
            authTracker = new ServiceTracker(bc, CarbonUIAuthenticator.class.getName(), null);
            authTracker.open();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static CarbonUIAuthenticator getCarbonAuthenticator(Object object) {
        CarbonUIAuthenticator authenticator = null;
        Object[] objects = authTracker.getServices();
        CarbonUIAuthenticator[] authenticators = new CarbonUIAuthenticator[objects.length];
        int i = 0;
        for (Object obj : objects) {
            authenticators[i] = (CarbonUIAuthenticator)obj;
            ++i;
        }
        Arrays.sort(authenticators, new AuthenticatorComparator());
        for (CarbonUIAuthenticator auth : authenticators) {
            if (auth.isDisabled() || !auth.isHandle(object)) continue;
            authenticator = auth;
            break;
        }
        return authenticator;
    }
}

