/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.wso2.carbon.ui.JspClassLoader;
import org.wso2.carbon.ui.UIResourceRegistry;

public class JspServlet
extends HttpServlet {
    private Servlet jspServlet = new org.apache.jasper.servlet.JspServlet();
    Bundle bundle;
    private BundlePermissionCollection bundlePermissions;
    private URLClassLoader jspLoader;
    private String bundleResourcePath;
    private String alias;
    private UIResourceRegistry uiResourceRegistry;

    public JspServlet(Bundle bundle, UIResourceRegistry uiResourceRegistry, String alias) {
        this.bundle = bundle;
        this.uiResourceRegistry = uiResourceRegistry;
        this.alias = alias == null || alias.equals("/") ? null : alias;
        try {
            if (System.getSecurityManager() != null) {
                this.bundlePermissions = new BundlePermissionCollection(bundle);
            }
            this.jspLoader = new JspClassLoader(bundle, this.bundlePermissions);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public JspServlet(Bundle bundle, UIResourceRegistry uiResourceRegistry) {
        this(bundle, uiResourceRegistry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        block5: {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.jspLoader);
                this.jspServlet.init((ServletConfig)new ServletConfigAdaptor(config));
                if (System.getSecurityManager() == null) break block5;
                try {
                    Field jspRuntimeContextField = this.jspServlet.getClass().getDeclaredField("rctxt");
                    jspRuntimeContextField.setAccessible(true);
                    Object jspRuntimeContext = jspRuntimeContextField.get(this.jspServlet);
                    Field permissionCollectionField = jspRuntimeContext.getClass().getDeclaredField("permissionCollection");
                    permissionCollectionField.setAccessible(true);
                    permissionCollectionField.set(jspRuntimeContext, this.bundlePermissions);
                }
                catch (Exception e) {
                    throw new ServletException("Cannot initialize JSPServlet. Failed to set JSPRuntimeContext permission collection.");
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jspLoader);
            this.jspServlet.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/WEB-INF/")) {
            response.sendError(404);
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jspLoader);
            this.jspServlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public ServletConfig getServletConfig() {
        return this.jspServlet.getServletConfig();
    }

    public String getServletInfo() {
        return this.jspServlet.getServletInfo();
    }

    public class ServletContextAdaptor
    implements ServletContext {
        private ServletContext delegate;

        public ServletContextAdaptor(ServletContext delegate) {
            this.delegate = delegate;
        }

        public URL getResource(String name) throws MalformedURLException {
            URL url;
            if (JspServlet.this.alias != null && name.startsWith(JspServlet.this.alias)) {
                name = name.substring(JspServlet.this.alias.length());
            }
            if ((url = JspServlet.this.uiResourceRegistry.getUIResource(name)) != null) {
                return url;
            }
            return this.delegate.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            try {
                URL resourceURL = this.getResource(name);
                if (resourceURL != null) {
                    return resourceURL.openStream();
                }
            }
            catch (IOException e) {
                this.log("Error opening stream for resource '" + name + "'", e);
            }
            return null;
        }

        public Set getResourcePaths(String name) {
            Set result = this.delegate.getResourcePaths(name);
            Set<String> resultFromProviders = JspServlet.this.uiResourceRegistry.getUIResourcePaths(name);
            if (resultFromProviders != null && result != null) {
                for (String resourcePath : resultFromProviders) {
                    result.add(resourcePath);
                }
                return result;
            }
            if (resultFromProviders != null) {
                return resultFromProviders;
            }
            return result;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return this.delegate.getRequestDispatcher(arg0);
        }

        public Object getAttribute(String arg0) {
            return this.delegate.getAttribute(arg0);
        }

        public Enumeration getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public ServletContext getContext(String arg0) {
            return this.delegate.getContext(arg0);
        }

        public String getInitParameter(String arg0) {
            return this.delegate.getInitParameter(arg0);
        }

        public Enumeration getInitParameterNames() {
            return this.delegate.getInitParameterNames();
        }

        public int getMajorVersion() {
            return this.delegate.getMajorVersion();
        }

        public String getMimeType(String arg0) {
            return this.delegate.getMimeType(arg0);
        }

        public int getMinorVersion() {
            return this.delegate.getMinorVersion();
        }

        public RequestDispatcher getNamedDispatcher(String arg0) {
            return this.delegate.getNamedDispatcher(arg0);
        }

        public String getRealPath(String arg0) {
            return this.delegate.getRealPath(arg0);
        }

        public String getServerInfo() {
            return this.delegate.getServerInfo();
        }

        public Servlet getServlet(String arg0) throws ServletException {
            return this.delegate.getServlet(arg0);
        }

        public String getServletContextName() {
            return this.delegate.getServletContextName();
        }

        public Enumeration getServletNames() {
            return this.delegate.getServletNames();
        }

        public Enumeration getServlets() {
            return this.delegate.getServlets();
        }

        public void log(Exception arg0, String arg1) {
            this.delegate.log(arg0, arg1);
        }

        public void log(String arg0, Throwable arg1) {
            this.delegate.log(arg0, arg1);
        }

        public void log(String arg0) {
            this.delegate.log(arg0);
        }

        public void removeAttribute(String arg0) {
            this.delegate.removeAttribute(arg0);
        }

        public void setAttribute(String arg0, Object arg1) {
            this.delegate.setAttribute(arg0, arg1);
        }

        public String getContextPath() {
            try {
                Method getContextPathMethod = this.delegate.getClass().getMethod("getContextPath", null);
                return (String)getContextPathMethod.invoke((Object)this.delegate, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public class ServletConfigAdaptor
    implements ServletConfig {
        private ServletConfig config;
        private ServletContext context;

        public ServletConfigAdaptor(ServletConfig config) {
            this.config = config;
            this.context = new ServletContextAdaptor(config.getServletContext());
        }

        public String getInitParameter(String arg0) {
            return this.config.getInitParameter(arg0);
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getServletName() {
            return this.config.getServletName();
        }
    }

    private static class BundlePermissionCollection
    extends PermissionCollection {
        private Bundle bundle;

        public BundlePermissionCollection(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public void add(Permission permission) {
            throw new SecurityException();
        }

        @Override
        public boolean implies(Permission permission) {
            return this.bundle.hasPermission((Object)permission);
        }

        public Enumeration elements() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    }
}

