/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.tcpmon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.ws.commons.tcpmon.Listener;
import org.apache.ws.commons.tcpmon.Sender;
import org.apache.ws.commons.tcpmon.SlowLinkSimulator;
import org.apache.ws.commons.tcpmon.TCPMon;

class AdminPane
extends JPanel {
    public JRadioButton listenerButton;
    public JRadioButton proxyButton;
    public JLabel hostLabel;
    public JLabel tportLabel;
    public NumberField port;
    public HostnameField host;
    public NumberField tport;
    public JTabbedPane noteb;
    public JCheckBox HTTPProxyBox;
    public HostnameField HTTPProxyHost;
    public NumberField HTTPProxyPort;
    public JLabel HTTPProxyHostLabel;
    public JLabel HTTPProxyPortLabel;
    public JLabel delayTimeLabel;
    public JLabel delayBytesLabel;
    public NumberField delayTime;
    public NumberField delayBytes;
    public JCheckBox delayBox;

    public AdminPane(JTabbedPane notebook, String name) {
        JPanel mainPane = null;
        JButton addButton = null;
        this.setLayout(new BorderLayout());
        this.noteb = notebook;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainPane = new JPanel(layout);
        c.anchor = 17;
        c.gridwidth = 0;
        mainPane.add((Component)new JLabel(TCPMon.getMessage("newTCP00", "Create a new TCPMon...") + " "), c);
        mainPane.add(Box.createRigidArea(new Dimension(1, 5)), c);
        JPanel tmpPanel = new JPanel(new GridBagLayout());
        c.anchor = 17;
        c.gridwidth = 1;
        tmpPanel.add((Component)new JLabel(TCPMon.getMessage("listenPort00", "Listen Port #") + " "), c);
        c.anchor = 17;
        c.gridwidth = 0;
        this.port = new NumberField(4);
        tmpPanel.add((Component)this.port, c);
        mainPane.add((Component)tmpPanel, c);
        mainPane.add(Box.createRigidArea(new Dimension(1, 5)), c);
        ButtonGroup btns = new ButtonGroup();
        c.anchor = 17;
        c.gridwidth = 0;
        mainPane.add((Component)new JLabel(TCPMon.getMessage("actAs00", "Act as a...")), c);
        c.anchor = 17;
        c.gridwidth = 0;
        final String listener = TCPMon.getMessage("listener00", "Listener");
        this.listenerButton = new JRadioButton(listener);
        mainPane.add((Component)this.listenerButton, c);
        btns.add(this.listenerButton);
        this.listenerButton.setSelected(true);
        this.listenerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (listener.equals(event.getActionCommand())) {
                    boolean state = AdminPane.this.listenerButton.isSelected();
                    AdminPane.this.tport.setEnabled(state);
                    AdminPane.this.host.setEnabled(state);
                    AdminPane.this.hostLabel.setForeground(state ? Color.black : Color.gray);
                    AdminPane.this.tportLabel.setForeground(state ? Color.black : Color.gray);
                }
            }
        });
        c.anchor = 17;
        c.gridwidth = 1;
        mainPane.add(Box.createRigidArea(new Dimension(25, 0)));
        this.hostLabel = new JLabel(TCPMon.getMessage("targetHostname00", "Target Hostname") + " ");
        mainPane.add((Component)this.hostLabel, c);
        c.anchor = 17;
        c.gridwidth = 0;
        this.host = new HostnameField(30);
        mainPane.add((Component)this.host, c);
        this.host.setText("127.0.0.1");
        c.anchor = 17;
        c.gridwidth = 1;
        mainPane.add(Box.createRigidArea(new Dimension(25, 0)));
        this.tportLabel = new JLabel(TCPMon.getMessage("targetPort00", "Target Port #") + " ");
        mainPane.add((Component)this.tportLabel, c);
        c.anchor = 17;
        c.gridwidth = 0;
        this.tport = new NumberField(4);
        mainPane.add((Component)this.tport, c);
        this.tport.setValue(8888);
        c.anchor = 17;
        c.gridwidth = 0;
        final String proxy = TCPMon.getMessage("proxy00", "Proxy");
        this.proxyButton = new JRadioButton(proxy);
        mainPane.add((Component)this.proxyButton, c);
        btns.add(this.proxyButton);
        this.proxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (proxy.equals(event.getActionCommand())) {
                    boolean state = AdminPane.this.proxyButton.isSelected();
                    AdminPane.this.tport.setEnabled(!state);
                    AdminPane.this.host.setEnabled(!state);
                    AdminPane.this.hostLabel.setForeground(state ? Color.gray : Color.black);
                    AdminPane.this.tportLabel.setForeground(state ? Color.gray : Color.black);
                }
            }
        });
        c.anchor = 17;
        c.gridwidth = 0;
        mainPane.add(Box.createRigidArea(new Dimension(1, 10)), c);
        JPanel opts = new JPanel(new GridBagLayout());
        opts.setBorder(new TitledBorder(TCPMon.getMessage("options00", "Options")));
        c.anchor = 17;
        c.gridwidth = 0;
        mainPane.add((Component)opts, c);
        c.anchor = 17;
        c.gridwidth = 0;
        final String proxySupport = TCPMon.getMessage("proxySupport00", "HTTP Proxy Support");
        this.HTTPProxyBox = new JCheckBox(proxySupport);
        opts.add((Component)this.HTTPProxyBox, c);
        c.anchor = 17;
        c.gridwidth = 1;
        this.HTTPProxyHostLabel = new JLabel(TCPMon.getMessage("hostname00", "Hostname") + " ");
        opts.add((Component)this.HTTPProxyHostLabel, c);
        this.HTTPProxyHostLabel.setForeground(Color.gray);
        c.anchor = 17;
        c.gridwidth = 0;
        this.HTTPProxyHost = new HostnameField(30);
        opts.add((Component)this.HTTPProxyHost, c);
        this.HTTPProxyHost.setEnabled(false);
        c.anchor = 17;
        c.gridwidth = 1;
        this.HTTPProxyPortLabel = new JLabel(TCPMon.getMessage("port00", "Port #") + " ");
        opts.add((Component)this.HTTPProxyPortLabel, c);
        this.HTTPProxyPortLabel.setForeground(Color.gray);
        c.anchor = 17;
        c.gridwidth = 0;
        this.HTTPProxyPort = new NumberField(4);
        opts.add((Component)this.HTTPProxyPort, c);
        this.HTTPProxyPort.setEnabled(false);
        this.HTTPProxyBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (proxySupport.equals(event.getActionCommand())) {
                    boolean b = AdminPane.this.HTTPProxyBox.isSelected();
                    Color color = b ? Color.black : Color.gray;
                    AdminPane.this.HTTPProxyHost.setEnabled(b);
                    AdminPane.this.HTTPProxyPort.setEnabled(b);
                    AdminPane.this.HTTPProxyHostLabel.setForeground(color);
                    AdminPane.this.HTTPProxyPortLabel.setForeground(color);
                }
            }
        });
        String tmp = System.getProperty("http.proxyHost");
        if (tmp != null && tmp.equals("")) {
            tmp = null;
        }
        this.HTTPProxyBox.setSelected(tmp != null);
        this.HTTPProxyHost.setEnabled(tmp != null);
        this.HTTPProxyPort.setEnabled(tmp != null);
        this.HTTPProxyHostLabel.setForeground(tmp != null ? Color.black : Color.gray);
        this.HTTPProxyPortLabel.setForeground(tmp != null ? Color.black : Color.gray);
        if (tmp != null) {
            this.HTTPProxyBox.setSelected(true);
            this.HTTPProxyHost.setText(tmp);
            tmp = System.getProperty("http.proxyPort");
            if (tmp != null && tmp.equals("")) {
                tmp = null;
            }
            if (tmp == null) {
                tmp = "80";
            }
            this.HTTPProxyPort.setText(tmp);
        }
        opts.add(Box.createRigidArea(new Dimension(1, 10)), c);
        c.anchor = 17;
        c.gridwidth = 0;
        final String delaySupport = TCPMon.getMessage("delay00", "Simulate Slow Connection");
        this.delayBox = new JCheckBox(delaySupport);
        opts.add((Component)this.delayBox, c);
        c.anchor = 17;
        c.gridwidth = 1;
        this.delayBytesLabel = new JLabel(TCPMon.getMessage("delay01", "Bytes per Pause"));
        opts.add((Component)this.delayBytesLabel, c);
        this.delayBytesLabel.setForeground(Color.gray);
        c.anchor = 17;
        c.gridwidth = 0;
        this.delayBytes = new NumberField(6);
        opts.add((Component)this.delayBytes, c);
        this.delayBytes.setEnabled(false);
        c.anchor = 17;
        c.gridwidth = 1;
        this.delayTimeLabel = new JLabel(TCPMon.getMessage("delay02", "Delay in Milliseconds"));
        opts.add((Component)this.delayTimeLabel, c);
        this.delayTimeLabel.setForeground(Color.gray);
        c.anchor = 17;
        c.gridwidth = 0;
        this.delayTime = new NumberField(6);
        opts.add((Component)this.delayTime, c);
        this.delayTime.setEnabled(false);
        this.delayBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (delaySupport.equals(event.getActionCommand())) {
                    boolean b = AdminPane.this.delayBox.isSelected();
                    Color color = b ? Color.black : Color.gray;
                    AdminPane.this.delayBytes.setEnabled(b);
                    AdminPane.this.delayTime.setEnabled(b);
                    AdminPane.this.delayBytesLabel.setForeground(color);
                    AdminPane.this.delayTimeLabel.setForeground(color);
                }
            }
        });
        mainPane.add(Box.createRigidArea(new Dimension(1, 10)), c);
        c.anchor = 17;
        c.gridwidth = 0;
        final String add = TCPMon.getMessage("add00", "Add");
        addButton = new JButton(add);
        mainPane.add((Component)addButton, c);
        this.add((Component)new JScrollPane(mainPane), "Center");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (add.equals(event.getActionCommand())) {
                    Listener l = null;
                    int lPort = AdminPane.this.port.getValue(0);
                    if (lPort == 0) {
                        return;
                    }
                    String tHost = AdminPane.this.host.getText();
                    int tPort = 0;
                    tPort = AdminPane.this.tport.getValue(0);
                    SlowLinkSimulator slowLink = null;
                    if (AdminPane.this.delayBox.isSelected()) {
                        int bytes = AdminPane.this.delayBytes.getValue(0);
                        int time = AdminPane.this.delayTime.getValue(0);
                        slowLink = new SlowLinkSimulator(bytes, time);
                    }
                    try {
                        l = new Listener(AdminPane.this.noteb, null, lPort, tHost, tPort, AdminPane.this.proxyButton.isSelected(), slowLink);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String text = AdminPane.this.HTTPProxyHost.getText();
                    if ("".equals(text)) {
                        text = null;
                    }
                    l.HTTPProxyHost = text;
                    text = AdminPane.this.HTTPProxyPort.getText();
                    int proxyPort = AdminPane.this.HTTPProxyPort.getValue(-1);
                    if (proxyPort != -1) {
                        l.HTTPProxyPort = Integer.parseInt(text);
                    }
                    AdminPane.this.port.setText(null);
                }
            }
        });
        notebook.addTab(name, this);
        new Sender(this.noteb);
        notebook.repaint();
        notebook.setSelectedIndex(notebook.getTabCount() - 1);
    }

    static class HostnameField
    extends RestrictedTextField {
        private static final String VALID_TEXT = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWZYZ-.";

        public HostnameField(int columns) {
            super(columns, VALID_TEXT);
        }

        public HostnameField() {
            super(VALID_TEXT);
        }
    }

    static class NumberField
    extends RestrictedTextField {
        private static final String VALID_TEXT = "0123456789";

        public NumberField() {
            super(VALID_TEXT);
        }

        public NumberField(int columns) {
            super(columns, VALID_TEXT);
        }

        public int getValue(int def) {
            int result = def;
            String text = this.getText();
            if (text != null && text.length() != 0) {
                try {
                    result = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return result;
        }

        public void setValue(int value) {
            this.setText(Integer.toString(value));
        }
    }

    static class RestrictedTextField
    extends JTextField {
        protected String validText;

        public RestrictedTextField(String validText) {
            this.setValidText(validText);
        }

        public RestrictedTextField(int columns, String validText) {
            super(columns);
            this.setValidText(validText);
        }

        public RestrictedTextField(String text, String validText) {
            super(text);
            this.setValidText(validText);
        }

        public RestrictedTextField(String text, int columns, String validText) {
            super(text, columns);
            this.setValidText(validText);
        }

        private void setValidText(String validText) {
            this.validText = validText;
        }

        public Document createDefaultModel() {
            return new RestrictedDocument();
        }

        class RestrictedDocument
        extends PlainDocument {
            public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
                if (string == null) {
                    return;
                }
                int len = string.length();
                StringBuffer buffer = new StringBuffer(string.length());
                for (int i = 0; i < len; ++i) {
                    char ch = string.charAt(i);
                    if (RestrictedTextField.this.validText.indexOf(ch) < 0) continue;
                    buffer.append(ch);
                }
                super.insertString(offset, new String(buffer), attributes);
            }
        }
    }
}

